/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTreeChildNode;
import org.broad.igv.bbfile.RPTreeChildNodeItem;
import org.broad.igv.bbfile.RPTreeHeader;
import org.broad.igv.bbfile.RPTreeLeafNode;
import org.broad.igv.bbfile.RPTreeLeafNodeItem;
import org.broad.igv.bbfile.RPTreeNode;
import org.broad.igv.bbfile.RPTreeNodeProxy;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.SeekableStream;

public class RPTree {
    private static Logger log = Logger.getLogger(RPTree.class);
    public static final int RPTREE_NODE_FORMAT_SIZE = 4;
    public static final int RPTREE_NODE_LEAF_ITEM_SIZE = 32;
    public static final int RPTREE_NODE_CHILD_ITEM_SIZE = 24;
    private int uncompressBuffSize;
    private boolean isLowToHigh;
    private long rpTreeOffset;
    private RPTreeHeader rpTreeHeader;
    private RPChromosomeRegion chromosomeBounds;
    private int order;
    private RPTreeNode rootNode;
    private long nodeCount;
    private long leafCount;

    public RPTree(SeekableStream seekableStream, long l, boolean bl, int n, boolean bl2) {
        this.rpTreeOffset = l;
        this.uncompressBuffSize = n;
        this.isLowToHigh = bl;
        this.rpTreeHeader = new RPTreeHeader(seekableStream, this.rpTreeOffset, bl);
        if (!this.rpTreeHeader.isHeaderOK()) {
            int n2 = this.rpTreeHeader.getMagic();
            log.error((Object)("Error reading R+ tree header: bad magic = " + n2));
            throw new RuntimeException("Error reading R+ tree header: bad magic = " + n2);
        }
        this.order = this.rpTreeHeader.getBlockSize();
        this.chromosomeBounds = new RPChromosomeRegion(this.rpTreeHeader.getStartChromID(), this.rpTreeHeader.getStartBase(), this.rpTreeHeader.getEndChromID(), this.rpTreeHeader.getEndBase());
        long l2 = this.rpTreeOffset + (long)this.rpTreeHeader.getHeaderSize();
        Object var9_8 = null;
        this.rootNode = RPTree.readRPTreeNode(seekableStream, l2, bl, bl2);
    }

    public RPTree(int n) {
        this.order = n;
        this.chromosomeBounds = null;
    }

    public int getUncompressBuffSize() {
        return this.uncompressBuffSize;
    }

    public boolean isIsLowToHigh() {
        return this.isLowToHigh;
    }

    public int getOrder() {
        return this.order;
    }

    public RPTreeHeader getRPTreeHeader() {
        return this.rpTreeHeader;
    }

    public long getItemCount() {
        return this.rpTreeHeader.getItemCount();
    }

    public RPChromosomeRegion getChromosomeBounds() {
        return this.chromosomeBounds;
    }

    public long getNodeCount() {
        return this.nodeCount;
    }

    public RPChromosomeRegion getChromosomeRegion(int n, int n2) {
        RPTreeNode rPTreeNode = this.rootNode;
        RPChromosomeRegion rPChromosomeRegion = null;
        RPChromosomeRegion rPChromosomeRegion2 = this.findChromosomeRegion(rPTreeNode, n, n2, rPChromosomeRegion);
        return rPChromosomeRegion2;
    }

    public ArrayList<RPChromosomeRegion> getAllChromosomeRegions() {
        RPTreeNode rPTreeNode = this.rootNode;
        ArrayList<RPChromosomeRegion> arrayList = new ArrayList<RPChromosomeRegion>();
        this.findAllChromosomeRegions(rPTreeNode, arrayList);
        return arrayList;
    }

    public ArrayList<RPTreeLeafNodeItem> getChromosomeDataHits(RPChromosomeRegion rPChromosomeRegion, boolean bl) {
        ArrayList<RPTreeLeafNodeItem> arrayList = new ArrayList<RPTreeLeafNodeItem>();
        if (rPChromosomeRegion == null) {
            return arrayList;
        }
        this.findChromosomeRegionItems(this.rootNode, rPChromosomeRegion, arrayList);
        return arrayList;
    }

    public void print() {
        if (!this.rpTreeHeader.isHeaderOK()) {
            int n = this.rpTreeHeader.getMagic();
            log.error((Object)("Error reading R+ tree header: bad magic = " + n));
            return;
        }
        this.rpTreeHeader.print();
        if (this.rootNode != null) {
            this.rootNode.printItems();
        }
    }

    private RPChromosomeRegion findChromosomeRegion(RPTreeNode rPTreeNode, int n, int n2, RPChromosomeRegion rPChromosomeRegion) {
        if (rPTreeNode.isLeaf()) {
            int n3 = rPTreeNode.getItemCount();
            for (int i = 0; i < n3; ++i) {
                RPTreeLeafNodeItem rPTreeLeafNodeItem = (RPTreeLeafNodeItem)rPTreeNode.getItem(i);
                RPChromosomeRegion rPChromosomeRegion2 = rPTreeLeafNodeItem.getChromosomeBounds();
                if ((n < rPChromosomeRegion2.getStartChromID() || n > rPChromosomeRegion2.getEndChromID()) && (n2 < rPChromosomeRegion2.getStartChromID() || n2 > rPChromosomeRegion2.getEndChromID())) continue;
                rPChromosomeRegion = rPChromosomeRegion == null ? new RPChromosomeRegion(rPChromosomeRegion2) : rPChromosomeRegion.getExtremes(rPChromosomeRegion2);
            }
        } else {
            int n4 = rPTreeNode.getItemCount();
            for (int i = 0; i < n4; ++i) {
                RPTreeChildNodeItem rPTreeChildNodeItem = (RPTreeChildNodeItem)rPTreeNode.getItem(i);
                RPChromosomeRegion rPChromosomeRegion3 = rPTreeChildNodeItem.getChromosomeBounds();
                if ((n < rPChromosomeRegion3.getStartChromID() || n > rPChromosomeRegion3.getEndChromID()) && (n2 < rPChromosomeRegion3.getStartChromID() || n2 > rPChromosomeRegion3.getEndChromID())) continue;
                RPTreeNode rPTreeNode2 = rPTreeChildNodeItem.getChildNode();
                rPChromosomeRegion = this.findChromosomeRegion(rPTreeNode2, n, n2, rPChromosomeRegion);
            }
        }
        return rPChromosomeRegion;
    }

    private void findAllChromosomeRegions(RPTreeNode rPTreeNode, ArrayList<RPChromosomeRegion> arrayList) {
        if (rPTreeNode.isLeaf()) {
            int n = rPTreeNode.getItemCount();
            for (int i = 0; i < n; ++i) {
                RPTreeLeafNodeItem rPTreeLeafNodeItem = (RPTreeLeafNodeItem)rPTreeNode.getItem(i);
                RPChromosomeRegion rPChromosomeRegion = rPTreeLeafNodeItem.getChromosomeBounds();
                arrayList.add(rPChromosomeRegion);
            }
        } else {
            int n = rPTreeNode.getItemCount();
            for (int i = 0; i < n; ++i) {
                RPTreeChildNodeItem rPTreeChildNodeItem = (RPTreeChildNodeItem)rPTreeNode.getItem(i);
                RPTreeNode rPTreeNode2 = rPTreeChildNodeItem.getChildNode();
                this.findAllChromosomeRegions(rPTreeNode2, arrayList);
            }
        }
    }

    private void findChromosomeRegionItems(RPTreeNode rPTreeNode, RPChromosomeRegion rPChromosomeRegion, ArrayList<RPTreeLeafNodeItem> arrayList) {
        if (rPChromosomeRegion == null) {
            return;
        }
        int n = rPTreeNode.compareRegions(rPChromosomeRegion);
        if (Math.abs(n) >= 2) {
            return;
        }
        if (rPTreeNode.isLeaf()) {
            int n2 = rPTreeNode.getItemCount();
            for (int i = 0; i < n2; ++i) {
                RPTreeLeafNodeItem rPTreeLeafNodeItem = (RPTreeLeafNodeItem)rPTreeNode.getItem(i);
                n = rPTreeLeafNodeItem.compareRegions(rPChromosomeRegion);
                if (Math.abs(n) < 2) {
                    arrayList.add(rPTreeLeafNodeItem);
                    continue;
                }
                if (n <= 1) {
                    continue;
                }
                break;
            }
        } else {
            int n3 = rPTreeNode.getItemCount();
            for (int i = 0; i < n3; ++i) {
                RPTreeChildNodeItem rPTreeChildNodeItem = (RPTreeChildNodeItem)rPTreeNode.getItem(i);
                n = rPTreeChildNodeItem.compareRegions(rPChromosomeRegion);
                if (Math.abs(n) < 2) {
                    RPTreeNode rPTreeNode2 = rPTreeChildNodeItem.getChildNode();
                    this.findChromosomeRegionItems(rPTreeNode2, rPChromosomeRegion, arrayList);
                    continue;
                }
                if (n <= 1) {
                    continue;
                }
                break;
            }
        }
    }

    static RPTreeNode readRPTreeNode(SeekableStream seekableStream, long l, boolean bl, boolean bl2) {
        LittleEndianInputStream littleEndianInputStream = null;
        DataInputStream dataInputStream = null;
        byte[] byArray = new byte[4];
        RPTreeNode rPTreeNode = null;
        try {
            int n;
            int n2;
            boolean bl3;
            seekableStream.seek(l);
            seekableStream.readFully(byArray);
            if (bl) {
                littleEndianInputStream = new LittleEndianInputStream(new ByteArrayInputStream(byArray));
            } else {
                dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            }
            byte by = bl ? littleEndianInputStream.readByte() : dataInputStream.readByte();
            if (by == 1) {
                bl3 = true;
                n2 = 32;
                rPTreeNode = new RPTreeLeafNode();
            } else {
                bl3 = false;
                n2 = 24;
                rPTreeNode = new RPTreeChildNode();
            }
            if (bl) {
                littleEndianInputStream.readByte();
                n = littleEndianInputStream.readShort();
            } else {
                dataInputStream.readByte();
                n = dataInputStream.readShort();
            }
            int n3 = n * n2;
            byArray = new byte[n3];
            seekableStream.readFully(byArray);
            if (bl) {
                littleEndianInputStream = new LittleEndianInputStream(new ByteArrayInputStream(byArray));
            } else {
                dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            }
            for (int i = 0; i < n; ++i) {
                long l2;
                int n4;
                int n5;
                int n6;
                int n7;
                if (bl) {
                    n7 = littleEndianInputStream.readInt();
                    n6 = littleEndianInputStream.readInt();
                    n5 = littleEndianInputStream.readInt();
                    n4 = littleEndianInputStream.readInt();
                } else {
                    n7 = dataInputStream.readInt();
                    n6 = dataInputStream.readInt();
                    n5 = dataInputStream.readInt();
                    n4 = dataInputStream.readInt();
                }
                if (bl3) {
                    long l3;
                    if (bl) {
                        l2 = littleEndianInputStream.readLong();
                        l3 = littleEndianInputStream.readLong();
                    } else {
                        l2 = dataInputStream.readLong();
                        l3 = dataInputStream.readLong();
                    }
                    rPTreeNode.insertItem(new RPTreeLeafNodeItem(n7, n6, n5, n4, l2, l3));
                } else {
                    l2 = bl ? littleEndianInputStream.readLong() : dataInputStream.readLong();
                    RPTreeNode rPTreeNode2 = n7 != n5 || bl2 ? RPTree.readRPTreeNode(seekableStream, l2, bl, bl2) : new RPTreeNodeProxy(seekableStream, l2, bl, n7);
                    rPTreeNode.insertItem(new RPTreeChildNodeItem(n7, n6, n5, n4, rPTreeNode2));
                }
                l += (long)n2;
            }
        }
        catch (IOException iOException) {
            log.error((Object)("Error reading in R+ tree nodes: " + iOException));
            throw new RuntimeException("Error reading R+ tree nodes: \n", iOException);
        }
        return rPTreeNode;
    }
}

