/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTreeChildNodeItem;
import org.broad.igv.bbfile.RPTreeNode;
import org.broad.igv.bbfile.RPTreeNodeItem;

public class RPTreeChildNode
implements RPTreeNode {
    private static Logger log = Logger.getLogger(RPTreeChildNode.class);
    private RPChromosomeRegion chromosomeBounds;
    private ArrayList<RPTreeChildNodeItem> childItems = new ArrayList();

    @Override
    public RPChromosomeRegion getChromosomeBounds() {
        return this.chromosomeBounds;
    }

    @Override
    public int compareRegions(RPChromosomeRegion rPChromosomeRegion) {
        int n = this.chromosomeBounds.compareRegions(rPChromosomeRegion);
        return n;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public int getItemCount() {
        return this.childItems.size();
    }

    @Override
    public RPTreeNodeItem getItem(int n) {
        if (n < 0 || n >= this.childItems.size()) {
            return null;
        }
        RPTreeChildNodeItem rPTreeChildNodeItem = this.childItems.get(n);
        return rPTreeChildNodeItem;
    }

    @Override
    public boolean insertItem(RPTreeNodeItem rPTreeNodeItem) {
        RPTreeChildNodeItem rPTreeChildNodeItem = (RPTreeChildNodeItem)rPTreeNodeItem;
        this.childItems.add(rPTreeChildNodeItem);
        this.chromosomeBounds = this.chromosomeBounds == null ? new RPChromosomeRegion(rPTreeChildNodeItem.getChromosomeBounds()) : this.chromosomeBounds.getExtremes(rPTreeChildNodeItem.getChromosomeBounds());
        return true;
    }

    @Override
    public boolean deleteItem(int n) {
        int n2 = this.getItemCount();
        if (n < 0 || n >= n2) {
            return false;
        }
        this.childItems.remove(n);
        return true;
    }

    @Override
    public void printItems() {
        for (int i = 0; i < this.childItems.size(); ++i) {
            this.childItems.get(i).print();
        }
    }
}

