/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import org.apache.log4j.Logger;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTree;
import org.broad.igv.bbfile.RPTreeNode;
import org.broad.igv.bbfile.RPTreeNodeItem;
import org.broad.igv.bbfile.RPTreeNodeProxy;

public class RPTreeChildNodeItem
implements RPTreeNodeItem {
    private static Logger log = Logger.getLogger(RPTreeChildNodeItem.class);
    private RPChromosomeRegion chromosomeBounds;
    private RPTreeNode childNode;

    public RPTreeChildNodeItem(int n, int n2, int n3, int n4, RPTreeNode rPTreeNode) {
        this.chromosomeBounds = new RPChromosomeRegion(n, n2, n3, n4);
        this.childNode = rPTreeNode;
    }

    public RPTreeChildNodeItem(int n, int n2, int n3, int n4, long l) {
        this.chromosomeBounds = new RPChromosomeRegion(n, n2, n3, n4);
    }

    @Override
    public RPChromosomeRegion getChromosomeBounds() {
        return this.chromosomeBounds;
    }

    public RPTreeNode getChildNode() {
        if (this.childNode instanceof RPTreeNodeProxy) {
            RPTreeNodeProxy rPTreeNodeProxy = (RPTreeNodeProxy)this.childNode;
            this.childNode = RPTree.readRPTreeNode(rPTreeNodeProxy.fis, rPTreeNodeProxy.fileOffset, rPTreeNodeProxy.isLowToHigh, true);
        }
        return this.childNode;
    }

    @Override
    public int compareRegions(RPChromosomeRegion rPChromosomeRegion) {
        int n = this.chromosomeBounds.compareRegions(rPChromosomeRegion);
        return n;
    }

    @Override
    public void print() {
        log.debug((Object)"Child node item :\n");
        log.debug((Object)(" StartChromID = " + this.chromosomeBounds.getStartChromID() + "\n"));
        log.debug((Object)(" StartBase = " + this.chromosomeBounds.getStartBase() + "\n"));
        log.debug((Object)(" EndChromID = " + this.chromosomeBounds.getEndChromID() + "\n"));
        log.debug((Object)(" EndBase = " + this.chromosomeBounds.getEndBase() + "\n"));
        this.childNode.printItems();
    }
}

