/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data;

import de.jstacs.DataType;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.ContinuousAlphabet;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.alphabets.ProteinAlphabet;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.ArrayParameterSet;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.InstanceParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import java.util.Iterator;
import java.util.LinkedList;

public class AlphabetContainerParameterSet
extends AlphabetContainer.AbstractAlphabetContainerParameterSet<AlphabetContainer> {
    private AlphabetContainer.AlphabetContainerType type;
    private boolean simple;

    public AlphabetContainerParameterSet(AlphabetContainer.AlphabetContainerType type, boolean simple) throws Exception {
        super(AlphabetContainer.class);
        this.type = type;
        this.simple = simple;
        this.addParameters();
    }

    public AlphabetContainerParameterSet() throws Exception {
        this(AlphabetContainer.AlphabetContainerType.BOTH, false);
    }

    public AlphabetContainerParameterSet(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public AlphabetContainerParameterSet(Alphabet alph) throws Exception {
        super(AlphabetContainer.class);
        this.type = alph instanceof DiscreteAlphabet ? AlphabetContainer.AlphabetContainerType.DISCRETE : AlphabetContainer.AlphabetContainerType.CONTINUOUS;
        this.simple = true;
        this.addParameters();
        if (this.type == AlphabetContainer.AlphabetContainerType.CONTINUOUS) {
            ((Parameter)this.parameters.get(0)).setValue(alph.getCurrentParameterSet());
        } else {
            InstanceParameterSet<? extends Alphabet> ap = alph.getCurrentParameterSet();
            ((Parameter)this.parameters.get(0)).setValue(ap);
            ((SelectionParameter)this.parameters.get(0)).getParametersInCollection().getParameterAt(((SelectionParameter)this.parameters.get(0)).getSelected()).setValue(ap);
        }
    }

    public AlphabetContainerParameterSet(Alphabet[] alphabets) throws Exception {
        this(AlphabetContainer.class, alphabets);
    }

    protected AlphabetContainerParameterSet(Class<? extends AlphabetContainer> instanceClass, Alphabet ... alphabets) throws Exception {
        super(instanceClass);
        this.simple = false;
        this.type = AlphabetContainer.AlphabetContainerType.determineType(alphabets);
        this.addParameters();
        AlphabetArrayParameterSet pars = new AlphabetArrayParameterSet(alphabets, this.type);
        ((Parameter)this.parameters.get(0)).setValue(pars);
        ((SelectionParameter)this.parameters.get(0)).getParametersInCollection().getParameterAt(((SelectionParameter)this.parameters.get(0)).getSelected()).setValue(pars);
    }

    public AlphabetContainerParameterSet(Alphabet[] alphabets, int[] indexes) throws Exception {
        super(AlphabetContainer.class);
        this.simple = false;
        this.type = AlphabetContainer.AlphabetContainerType.determineType(alphabets);
        this.addParameters();
        SectionDefinedAlphabetParameterSet pars = new SectionDefinedAlphabetParameterSet(alphabets, indexes);
        ((Parameter)this.parameters.get(0)).setValue(pars);
        ((SelectionParameter)this.parameters.get(0)).getParametersInCollection().getParameterAt(((SelectionParameter)this.parameters.get(0)).getSelected()).setValue(pars);
    }

    @Override
    public boolean isDiscrete() {
        return this.type == AlphabetContainer.AlphabetContainerType.DISCRETE;
    }

    @Override
    public boolean isSimple() {
        return this.simple;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = super.toXML();
        XMLParser.addTags(buf, "superParameters");
        XMLParser.appendObjectWithTags(buf, (Object)this.type, "type");
        XMLParser.appendObjectWithTags(buf, this.simple, "simple");
        XMLParser.addTags(buf, "alphabetContainerParameterSet");
        return buf;
    }

    @Override
    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "alphabetContainerParameterSet");
        super.fromXML(XMLParser.extractForTag(representation, "superParameters"));
        this.type = XMLParser.extractObjectForTags(representation, "type", AlphabetContainer.AlphabetContainerType.class);
        this.simple = XMLParser.extractObjectForTags(representation, "simple", Boolean.TYPE);
    }

    @Override
    public int getPossibleLength() {
        Object o = ((Parameter)this.parameters.get(0)).getValue();
        if (o instanceof ProteinAlphabet.ProteinAlphabetParameterSet || o instanceof DNAAlphabet.DNAAlphabetParameterSet || o instanceof DiscreteAlphabet.DiscreteAlphabetParameterSet || o instanceof ContinuousAlphabet.ContinuousAlphabetParameterSet) {
            return 0;
        }
        ParameterSet set = (ParameterSet)o;
        return (Integer)set.getParameterAt(0).getValue();
    }

    private void addParameters() throws Exception {
        LinkedList<InstanceParameterSet> list = this.type.getInstanceParameterSets();
        ParameterSet[] ar = new ParameterSet[list.size() + (this.simple ? 0 : 2)];
        list.toArray(ar);
        if (!this.simple) {
            AlphabetArrayParameterSet arrayParameters = new AlphabetArrayParameterSet(this.type);
            SectionDefinedAlphabetParameterSet sectionParameters = new SectionDefinedAlphabetParameterSet(this.type);
            ar[list.size()] = arrayParameters;
            ar[list.size() + 1] = sectionParameters;
        }
        Parameter[] parameterArray = new Parameter[1];
        parameterArray[0] = new SelectionParameter("Alphabet", this.simple ? (this.type == AlphabetContainer.AlphabetContainerType.DISCRETE ? "Select a discrete alphabet" : (this.type == AlphabetContainer.AlphabetContainerType.CONTINUOUS ? "Set the continuous alphabet" : "Select an alphabet")) : (this.type == AlphabetContainer.AlphabetContainerType.DISCRETE ? "Select the discrete alphabets" : (this.type == AlphabetContainer.AlphabetContainerType.CONTINUOUS ? "Set the continuous alphabets" : "Select the alphabets")), true, ar);
        this.parameters.add(parameterArray);
    }

    @Override
    public String getInstanceName() {
        return "Alphabet";
    }

    @Override
    public String getInstanceComment() {
        return "Set an alphabet for your model or data.";
    }

    public static class AlphabetArrayParameterSet
    extends ArrayParameterSet {
        private AlphabetContainer.AlphabetContainerType type;

        public AlphabetArrayParameterSet(AlphabetContainer.AlphabetContainerType type) throws Exception {
            super(type == AlphabetContainer.AlphabetContainerType.CONTINUOUS ? new ContinuousAlphabet.ContinuousAlphabetParameterSet() : new SimpleParameterSet(new SelectionParameter("Type of alphabet", "Select the type of the alphabet", true, type.getInstanceParameterSets().toArray(new InstanceParameterSet[0]))), "Alphabet", "Set the alphabet");
        }

        public AlphabetArrayParameterSet() throws Exception {
            this(AlphabetContainer.AlphabetContainerType.BOTH);
        }

        public AlphabetArrayParameterSet(StringBuffer representation) throws NonParsableException {
            super(representation);
        }

        public AlphabetArrayParameterSet(Alphabet[] alphabets, AlphabetContainer.AlphabetContainerType type) throws Exception {
            this(type);
            this.setLength(alphabets.length);
            for (int i = 0; i < alphabets.length; ++i) {
                if (type == AlphabetContainer.AlphabetContainerType.CONTINUOUS) {
                    ((Parameter)this.parameters.get(i + 1)).setValue(alphabets[i].getCurrentParameterSet());
                    continue;
                }
                InstanceParameterSet<? extends Alphabet> ap = alphabets[i].getCurrentParameterSet();
                ((ParameterSet)((Parameter)this.parameters.get(i + 1)).getValue()).getParameterAt(0).setValue(ap);
                ((SelectionParameter)((ParameterSet)((Parameter)this.parameters.get(i + 1)).getValue()).getParameterAt(0)).getParametersInCollection().getParameterAt(((SelectionParameter)((ParameterSet)((Parameter)this.parameters.get(i + 1)).getValue()).getParameterAt(0)).getSelected()).setValue(ap);
            }
        }

        @Override
        public AlphabetArrayParameterSet clone() throws CloneNotSupportedException {
            try {
                AlphabetArrayParameterSet clone = (AlphabetArrayParameterSet)super.clone();
                return clone;
            }
            catch (Exception e) {
                throw new CloneNotSupportedException(e.getCause().getMessage());
            }
        }

        @Override
        public StringBuffer toXML() {
            StringBuffer buf = super.toXML();
            XMLParser.addTags(buf, "superParameters");
            XMLParser.appendObjectWithTags(buf, (Object)this.type, "type");
            XMLParser.addTags(buf, "alphabetArrayParameterSet");
            return buf;
        }

        @Override
        public void fromXML(StringBuffer representation) throws NonParsableException {
            representation = XMLParser.extractForTag(representation, "alphabetArrayParameterSet");
            super.fromXML(XMLParser.extractForTag(representation, "superParameters"));
            this.type = XMLParser.extractObjectForTags(representation, "type", AlphabetContainer.AlphabetContainerType.class);
        }

        public String getInstanceName() {
            return "Alphabet-array";
        }

        public String getInstanceComment() {
            return "An array of alphabets where each position can have its own alphabet.";
        }
    }

    public static class SectionDefinedAlphabetParameterSet
    extends ExpandableParameterSet {
        private AlphabetContainer.AlphabetContainerType type;

        public SectionDefinedAlphabetParameterSet(AlphabetContainer.AlphabetContainerType type) throws Exception {
            super(new SimpleParameterSet(type == AlphabetContainer.AlphabetContainerType.CONTINUOUS ? new ParameterSetContainer("Alphabet", "Set the parameters of the alphabet.", new ContinuousAlphabet.ContinuousAlphabetParameterSet()) : new SelectionParameter("Type of alphabet", "Select the type of the alphabet", true, type.getInstanceParameterSets().toArray(new InstanceParameterSet[0])), new SimpleParameter(DataType.STRING, "Section", "The section for that this alphabet is applied. Use &quot;,&quot; to separate different positions and &quot;-&quot; to indicate ranges, e.g. 1-3,5.", true)), "Alphabet", "Set the alphabet", 0);
            SimpleParameter length = new SimpleParameter(DataType.INT, "Length", "The length of the array.", true);
            length.setRangeable(false);
            this.parameters.add(0, (Parameter)length);
            this.type = type;
        }

        public SectionDefinedAlphabetParameterSet() throws Exception {
            this(AlphabetContainer.AlphabetContainerType.BOTH);
        }

        public SectionDefinedAlphabetParameterSet(Alphabet[] alphabets, int[] indexes) throws Exception {
            this(AlphabetContainer.AlphabetContainerType.determineType(alphabets));
            int i;
            ((Parameter)this.parameters.get(0)).setValue(indexes.length);
            for (i = 0; i < alphabets.length; ++i) {
                this.addParameterToSet();
            }
            for (i = 0; i < alphabets.length; ++i) {
                ParameterSet temp = (ParameterSet)((Parameter)this.parameters.get(i + 1)).getValue();
                if (this.type == AlphabetContainer.AlphabetContainerType.CONTINUOUS) {
                    temp.getParameterAt(0).setValue(alphabets[i].getCurrentParameterSet());
                } else {
                    InstanceParameterSet<? extends Alphabet> ap = alphabets[i].getCurrentParameterSet();
                    temp.getParameterAt(0).setValue(ap);
                    ((SelectionParameter)temp.getParameterAt(0)).getParametersInCollection().getParameterAt(((SelectionParameter)temp.getParameterAt(0)).getSelected()).setValue(ap);
                }
                StringBuffer sections = new StringBuffer();
                for (int j = 0; j < indexes.length; ++j) {
                    if (indexes[j] != i) continue;
                    sections.append(j + 1 + ", ");
                }
                sections.delete(sections.length() - 2, sections.length());
                temp.getParameterAt(1).setValue(sections.toString());
            }
        }

        public SectionDefinedAlphabetParameterSet(StringBuffer representation) throws NonParsableException {
            super(representation);
        }

        @Override
        public StringBuffer toXML() {
            StringBuffer buf = super.toXML();
            XMLParser.addTags(buf, "superParameters");
            XMLParser.appendObjectWithTags(buf, (Object)this.type, "type");
            XMLParser.addTags(buf, "sectionDefinedAlphabetParameterSet");
            return buf;
        }

        @Override
        public void fromXML(StringBuffer representation) throws NonParsableException {
            representation = XMLParser.extractForTag(representation, "sectionDefinedAlphabetParameterSet");
            super.fromXML(XMLParser.extractForTag(representation, "superParameters"));
            this.type = XMLParser.extractObjectForTags(representation, "type", AlphabetContainer.AlphabetContainerType.class);
        }

        @Override
        public boolean hasDefaultOrIsSet() {
            int i;
            if (!super.hasDefaultOrIsSet()) {
                return false;
            }
            boolean[] set = new boolean[((Integer)((Parameter)this.parameters.get(0)).getValue()).intValue()];
            int no = 0;
            for (i = 1; i < this.parameters.size(); ++i) {
                Parameter element = (Parameter)this.parameters.get(i);
                ++no;
                ParameterSet temp = (ParameterSet)element.getValue();
                String section = (String)temp.getParameterAt(1).getValue();
                try {
                    LinkedList<Integer> tempList = SectionDefinedAlphabetParameterSet.parseSections(section);
                    Iterator posIt = tempList.iterator();
                    while (posIt.hasNext()) {
                        int curr = (Integer)posIt.next();
                        if (curr >= set.length) {
                            this.errorMessage = "Position " + (curr + 1) + " out of range defined by length.";
                            return false;
                        }
                        if (set[curr]) {
                            this.errorMessage = "Alphabet for position " + (curr + 1) + " defined at least twice.";
                            return false;
                        }
                        set[curr] = true;
                    }
                    continue;
                }
                catch (Exception e) {
                    this.errorMessage = "Malformed section definition no. " + no;
                    e.printStackTrace();
                    return false;
                }
            }
            for (i = 0; i < set.length; ++i) {
                if (set[i]) continue;
                this.errorMessage = "No alphabet defined for position " + (i + 1) + ".";
                return false;
            }
            this.errorMessage = null;
            return true;
        }

        public static LinkedList<Integer> parseSections(String sections) throws Exception {
            String[] secs = sections.split("(\\s*,\\s*)");
            LinkedList<Integer> list = new LinkedList<Integer>();
            for (int i = 0; i < secs.length; ++i) {
                String[] temp = secs[i].split("(\\s*-\\s*)");
                if (temp.length == 2) {
                    int end;
                    int start = Integer.parseInt(temp[0]) - 1;
                    start = start <= (end = Integer.parseInt(temp[1]) - 1) ? start : end;
                    int n = end = end >= start ? end : start;
                    if (start < 0) {
                        throw new Exception("Malformed sections, no negative values allowed.");
                    }
                    for (int j = start; j <= end; ++j) {
                        list.add(j);
                    }
                    continue;
                }
                if (temp.length == 1) {
                    int pos = Integer.parseInt(temp[0]) - 1;
                    if (pos < 0) {
                        throw new Exception("Malformed sections, no negative values allowed.");
                    }
                    list.add(pos);
                    continue;
                }
                throw new Exception("Malformed sections.");
            }
            return list;
        }

        @Override
        public SectionDefinedAlphabetParameterSet clone() throws CloneNotSupportedException {
            try {
                SectionDefinedAlphabetParameterSet clone = (SectionDefinedAlphabetParameterSet)super.clone();
                return clone;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CloneNotSupportedException(e.getCause().getMessage());
            }
        }

        public String getInstanceName() {
            return "Alphabets defined by section";
        }

        public String getInstanceComment() {
            return "Set the alphabets for all positions.";
        }
    }
}

