/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.DataType;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.EnumParameter;
import de.jstacs.parameters.GalaxyConvertible;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.RangeIterator;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.tools.ui.galaxy.GalaxyAdaptor;
import java.util.StringTokenizer;

public class RangeParameter
extends Parameter
implements RangeIterator,
GalaxyConvertible {
    private SimpleParameter rangedParameter;
    private Object[] values;
    private int current;
    private RangeType shallBeRanged;
    private Scale scale;
    private boolean isSet;
    private String errorMessage;

    @Override
    public RangeParameter clone() throws CloneNotSupportedException {
        RangeParameter clone = (RangeParameter)super.clone();
        clone.values = this.values == null ? null : (Object[])this.values.clone();
        clone.rangedParameter = this.rangedParameter.clone();
        return clone;
    }

    public RangeParameter(SimpleParameter par) throws Exception {
        super(par.getName(), par.getComment(), par.getDatatype());
        if (!par.isRangeable()) {
            throw new Exception("Parameter must be rangeable");
        }
        this.rangedParameter = par.clone();
        this.shallBeRanged = RangeType.NO;
        this.scale = Scale.LINSCALE;
    }

    public RangeParameter(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public static EnumParameter getCollectionOfScales() throws ParameterException {
        return new EnumParameter(Scale.class, "The possible scales for a range of parameter values", true);
    }

    public String getList() {
        if (this.values == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.values.length - 1; ++i) {
            buf.append(this.values[i].toString() + " ");
        }
        buf.append(this.values[this.values.length - 1].toString());
        return buf.toString();
    }

    public Object getStartValue() {
        if (this.shallBeRanged != RangeType.RANGE) {
            return null;
        }
        if (this.values == null) {
            return this.rangedParameter.getValue();
        }
        return this.values[0];
    }

    public Object getEndValue() {
        if (this.shallBeRanged != RangeType.RANGE) {
            return null;
        }
        if (this.values == null) {
            return this.rangedParameter.getValue();
        }
        return this.values[this.values.length - 1];
    }

    public int getSteps() {
        if (this.shallBeRanged != RangeType.RANGE) {
            return 0;
        }
        if (this.values == null) {
            return 1;
        }
        return this.values.length - 1;
    }

    public String getScale() {
        if (this.shallBeRanged != RangeType.RANGE) {
            return null;
        }
        switch (this.scale) {
            case LINSCALE: {
                return "Linear";
            }
            case EXPSCALE: {
                return "Exponential";
            }
            case LOGSCALE: {
                return "Logarithmic";
            }
            case INVERSELOGSCALE: {
                return "Inverse logarithmic";
            }
            case LOGSCALE2: {
                return "Logarithmic (radix=2)";
            }
            case INVERSELOGSCALE2: {
                return "Inverse logarithmic (radix=2)";
            }
            case LOGSCALE10: {
                return "Logarithmic (radix=10)";
            }
            case INVERSELOGSCALE10: {
                return "Inverse logarithmic (radix=10)";
            }
        }
        return null;
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    private boolean checkSteps(Object steps) {
        if (steps instanceof String) {
            try {
                if (Integer.parseInt((String)steps) > 0) {
                    this.errorMessage = null;
                    return true;
                }
                this.errorMessage = "The number of steps must be at least 1.";
                return false;
            }
            catch (NumberFormatException e) {
                this.errorMessage = "The number of steps must be an integer.";
                return false;
            }
        }
        if (steps instanceof Integer) {
            if ((Integer)steps > 0) {
                this.errorMessage = null;
                return true;
            }
            this.errorMessage = "The number of steps must be at least 1.";
            return false;
        }
        this.errorMessage = "The number of steps is of illegal type " + steps.getClass();
        return false;
    }

    @Override
    public boolean checkValue(Object value) {
        boolean r = this.rangedParameter.checkValue(value);
        if (!r && this.rangedParameter.getErrorMessage() != null) {
            this.errorMessage = this.rangedParameter.getErrorMessage();
        }
        return r;
    }

    @Override
    public void setValue(Object value) throws SimpleParameter.IllegalValueException {
        this.rangedParameter.setValue(value);
    }

    public void setValues(String values) throws SimpleParameter.IllegalValueException {
        this.shallBeRanged = RangeType.LIST;
        StringTokenizer tok = new StringTokenizer(values);
        this.values = new Object[tok.countTokens()];
        for (int i = 0; i < this.values.length; ++i) {
            String temp = tok.nextToken();
            try {
                switch (this.getDatatype()) {
                    case BYTE: {
                        this.values[i] = new Byte(temp);
                        break;
                    }
                    case SHORT: {
                        this.values[i] = new Short(temp);
                        break;
                    }
                    case INT: {
                        this.values[i] = new Integer(temp);
                        break;
                    }
                    case LONG: {
                        this.values[i] = new Long(temp);
                        break;
                    }
                    case FLOAT: {
                        this.values[i] = new Float(temp);
                        break;
                    }
                    case DOUBLE: {
                        this.values[i] = new Double(temp);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Datatype " + (Object)((Object)this.getDatatype()) + " not supported in RangeParameter");
                    }
                }
            }
            catch (NumberFormatException e) {
                this.values = null;
                this.errorMessage = e.getMessage();
                throw new SimpleParameter.IllegalValueException(e.getMessage());
            }
            if (this.rangedParameter.checkValue(this.values[i])) continue;
            this.errorMessage = "Value " + temp + " not allowed! " + this.rangedParameter.getErrorMessage();
            throw new SimpleParameter.IllegalValueException("Value " + temp + " not allowed! " + this.rangedParameter.getErrorMessage());
        }
        this.current = 0;
        this.setValue(this.values[0]);
        this.errorMessage = "";
    }

    public void setValues(Object startValue, int steps, Object endValue, Scale scale) throws SimpleParameter.IllegalValueException {
        if (scale == Scale.LINSCALE || scale == Scale.EXPSCALE) {
            this.values = this.check(startValue, steps, endValue);
            DataType d = this.getDatatype();
            double start = ((Number)this.values[0]).doubleValue();
            double end = ((Number)this.values[steps]).doubleValue();
            if (scale == Scale.LINSCALE) {
                double stepSize = (end - start) / (double)steps;
                block25: for (int i = 1; i < steps; ++i) {
                    switch (d) {
                        case BYTE: {
                            this.values[i] = new Byte((byte)(start + (double)i * stepSize));
                            continue block25;
                        }
                        case SHORT: {
                            this.values[i] = new Short((short)(start + (double)i * stepSize));
                            continue block25;
                        }
                        case INT: {
                            this.values[i] = new Integer((int)(start + (double)i * stepSize));
                            continue block25;
                        }
                        case LONG: {
                            this.values[i] = new Long((long)(start + (double)i * stepSize));
                            continue block25;
                        }
                        case FLOAT: {
                            this.values[i] = new Float((float)(start + (double)i * stepSize));
                            continue block25;
                        }
                        case DOUBLE: {
                            this.values[i] = new Double(start + (double)i * stepSize);
                            continue block25;
                        }
                        default: {
                            throw new RuntimeException("Datatype " + (Object)((Object)d) + " not supported in RangeParameter");
                        }
                    }
                }
            } else {
                double stepSize = (StrictMath.exp(end) - StrictMath.exp(start)) / (double)steps;
                block26: for (int i = 1; i < steps; ++i) {
                    switch (d) {
                        case BYTE: {
                            this.values[i] = new Byte((byte)StrictMath.log(StrictMath.exp(start) + (double)i * stepSize));
                            continue block26;
                        }
                        case SHORT: {
                            this.values[i] = new Short((short)StrictMath.log(StrictMath.exp(start) + (double)i * stepSize));
                            continue block26;
                        }
                        case INT: {
                            this.values[i] = new Integer((int)StrictMath.log(StrictMath.exp(start) + (double)i * stepSize));
                            continue block26;
                        }
                        case LONG: {
                            this.values[i] = new Long((long)StrictMath.log(StrictMath.exp(start) + (double)i * stepSize));
                            continue block26;
                        }
                        case FLOAT: {
                            this.values[i] = new Float((float)StrictMath.log(StrictMath.exp(start) + (double)i * stepSize));
                            continue block26;
                        }
                        case DOUBLE: {
                            this.values[i] = new Double(StrictMath.log(StrictMath.exp(start) + (double)i * stepSize));
                            continue block26;
                        }
                        default: {
                            throw new RuntimeException("Datatype " + (Object)((Object)d) + " not supported in RangeParameter");
                        }
                    }
                }
            }
            this.current = 0;
            this.setValue(this.values[0]);
        } else {
            boolean log = true;
            double radix = 0.0;
            switch (scale) {
                case INVERSELOGSCALE: 
                case INVERSELOGSCALE2: 
                case INVERSELOGSCALE10: {
                    log = false;
                }
                case LOGSCALE: 
                case LOGSCALE2: 
                case LOGSCALE10: {
                    switch (scale) {
                        case LOGSCALE: 
                        case INVERSELOGSCALE: {
                            radix = Math.E;
                            break;
                        }
                        case LOGSCALE2: 
                        case INVERSELOGSCALE2: {
                            radix = 2.0;
                            break;
                        }
                        case LOGSCALE10: 
                        case INVERSELOGSCALE10: {
                            radix = 10.0;
                        }
                    }
                    this.setValuesInLogScale(log, radix, startValue, steps, endValue);
                    break;
                }
                default: {
                    this.errorMessage = "Range type not allowed!";
                    this.values = null;
                    throw new SimpleParameter.IllegalValueException("Range not allowed!");
                }
            }
        }
        this.shallBeRanged = RangeType.RANGE;
        this.scale = scale;
        this.errorMessage = "";
    }

    private Object[] check(Object startValue, int steps, Object endValue) throws SimpleParameter.IllegalValueException {
        if (steps < 1) {
            this.errorMessage = "The number of steps has to be at least 1.";
            throw new SimpleParameter.IllegalValueException("The number of steps has to be at least 1.");
        }
        if (!this.rangedParameter.checkValue(startValue)) {
            this.errorMessage = "Start value out of range!";
            throw new SimpleParameter.IllegalValueException("Start value out of range!");
        }
        if (!this.rangedParameter.checkValue(endValue)) {
            this.errorMessage = "End value out of range!";
            throw new SimpleParameter.IllegalValueException("End value out of range!");
        }
        Object[] val = new Object[steps + 1];
        this.rangedParameter.setValue(startValue);
        val[0] = this.rangedParameter.getValue();
        this.rangedParameter.setValue(endValue);
        val[steps] = this.rangedParameter.getValue();
        if (((Number)val[0]).doubleValue() > ((Number)val[steps]).doubleValue()) {
            this.errorMessage = "Start value has to be less than end value!";
            throw new SimpleParameter.IllegalValueException("Start value has to be less than end value!");
        }
        return val;
    }

    public void setValuesInLogScale(boolean log, double radix, Object startValue, int steps, Object endValue) throws SimpleParameter.IllegalValueException {
        DataType d = this.getDatatype();
        this.values = this.check(startValue, steps, endValue);
        double start = ((Number)this.values[0]).doubleValue();
        double end = ((Number)this.values[steps]).doubleValue();
        double stepSize = end - start;
        if (log) {
            block16: for (int i = 1; i < steps; ++i) {
                switch (d) {
                    case BYTE: {
                        this.values[i] = new Byte((byte)(start + Math.pow(radix, i - steps) * stepSize));
                        continue block16;
                    }
                    case SHORT: {
                        this.values[i] = new Short((short)(start + Math.pow(radix, i - steps) * stepSize));
                        continue block16;
                    }
                    case INT: {
                        this.values[i] = new Integer((int)(start + Math.pow(radix, i - steps) * stepSize));
                        continue block16;
                    }
                    case LONG: {
                        this.values[i] = new Long((long)(start + Math.pow(radix, i - steps) * stepSize));
                        continue block16;
                    }
                    case FLOAT: {
                        this.values[i] = new Float((float)(start + Math.pow(radix, i - steps) * stepSize));
                        continue block16;
                    }
                    case DOUBLE: {
                        this.values[i] = new Double(start + Math.pow(radix, i - steps) * stepSize);
                        continue block16;
                    }
                    default: {
                        throw new RuntimeException("Datatype " + (Object)((Object)d) + " not supported in RangeParameter");
                    }
                }
            }
        } else {
            block17: for (int i = 1; i < steps; ++i) {
                switch (d) {
                    case BYTE: {
                        this.values[steps - i] = new Byte((byte)(end - Math.pow(radix, i - steps) * stepSize));
                        continue block17;
                    }
                    case SHORT: {
                        this.values[steps - i] = new Short((short)(end - Math.pow(radix, i - steps) * stepSize));
                        continue block17;
                    }
                    case INT: {
                        this.values[steps - i] = new Integer((int)(end - Math.pow(radix, i - steps) * stepSize));
                        continue block17;
                    }
                    case LONG: {
                        this.values[steps - i] = new Long((long)(end - Math.pow(radix, i - steps) * stepSize));
                        continue block17;
                    }
                    case FLOAT: {
                        this.values[steps - i] = new Float((float)(end - Math.pow(radix, i - steps) * stepSize));
                        continue block17;
                    }
                    case DOUBLE: {
                        this.values[steps - i] = new Double(end - Math.pow(radix, i - steps) * stepSize);
                        continue block17;
                    }
                    default: {
                        throw new RuntimeException("Datatype " + (Object)((Object)d) + " not supported in RangeParameter");
                    }
                }
            }
        }
        this.current = 0;
        this.setValue(this.values[0]);
        this.shallBeRanged = RangeType.LIST;
    }

    @Override
    public Object getValue() {
        return this.rangedParameter.getValue();
    }

    @Override
    public boolean next() throws SimpleParameter.IllegalValueException {
        if (this.values != null && this.current + 1 < this.values.length) {
            ++this.current;
            this.setValue(this.values[this.current]);
            return true;
        }
        return false;
    }

    @Override
    public int getNumberOfValues() {
        if (this.values != null) {
            return this.values.length;
        }
        return 1;
    }

    public int getNumberOfNexts(int afterIndex) {
        if (this.values != null) {
            return this.values.length - afterIndex - 1;
        }
        return 0;
    }

    public RangeType shallBeRanged() {
        return this.shallBeRanged;
    }

    private void setShallBeRanged(RangeType shallBeRanged) throws Exception {
        if (shallBeRanged == RangeType.NO || shallBeRanged == RangeType.LIST || shallBeRanged == RangeType.RANGE) {
            this.shallBeRanged = shallBeRanged;
            if (shallBeRanged == RangeType.NO) {
                this.values = null;
            }
        } else {
            throw new Exception("None of the range parameters!");
        }
    }

    @Override
    public boolean hasDefaultOrIsSet() {
        if (this.shallBeRanged == RangeType.NO) {
            return this.rangedParameter.hasDefaultOrIsSet();
        }
        return this.values != null;
    }

    @Override
    public boolean isSet() {
        if (this.shallBeRanged == RangeType.NO) {
            return this.rangedParameter.isSet();
        }
        return this.values != null;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public String getErrorMessage() {
        if (this.errorMessage == null) {
            return this.rangedParameter.getErrorMessage();
        }
        return this.errorMessage;
    }

    @Override
    public String getXMLTag() {
        return "rangeParameter";
    }

    @Override
    protected void appendFurtherInfos(StringBuffer buf) {
        super.appendFurtherInfos(buf);
        XMLParser.appendObjectWithTags(buf, this.rangedParameter, "rangedParameter");
        XMLParser.appendObjectWithTags(buf, this.values, "values");
        XMLParser.appendObjectWithTags(buf, this.current, "current");
        XMLParser.appendObjectWithTags(buf, this.isSet, "isSet");
        XMLParser.appendObjectWithTags(buf, (Object)this.shallBeRanged, "shallBeRanged");
        XMLParser.appendObjectWithTags(buf, this.errorMessage, "errorMessage");
        XMLParser.appendObjectWithTags(buf, (Object)this.scale, "scale");
    }

    @Override
    protected void extractFurtherInfos(StringBuffer buf) throws NonParsableException {
        super.extractFurtherInfos(buf);
        this.rangedParameter = XMLParser.extractObjectForTags(buf, "rangedParameter", SimpleParameter.class);
        this.values = (Object[])XMLParser.extractObjectForTags(buf, "values");
        this.current = XMLParser.extractObjectForTags(buf, "current", Integer.TYPE);
        this.isSet = XMLParser.extractObjectForTags(buf, "isSet", Boolean.TYPE);
        this.shallBeRanged = XMLParser.extractObjectForTags(buf, "shallBeRanged", RangeType.class);
        this.errorMessage = XMLParser.parseString(XMLParser.extractObjectForTags(buf, "errorMessage", String.class));
        this.scale = XMLParser.extractObjectForTags(buf, "scale", Scale.class);
    }

    @Override
    public void reset() {
        this.rangedParameter.reset();
    }

    @Override
    public void resetToFirst() {
        this.current = 0;
        try {
            this.setValue(this.values[this.current]);
        }
        catch (Exception e) {
            this.rangedParameter.reset();
        }
    }

    @Override
    public void setDefault(Object defaultValue) throws Exception {
        this.rangedParameter.setDefault(defaultValue);
    }

    @Override
    public String valuesToString() {
        if (this.shallBeRanged == RangeType.LIST) {
            return "[List: " + this.getList() + "]";
        }
        if (this.shallBeRanged == RangeType.RANGE) {
            return "[" + this.getScale() + ": " + this.getStartValue() + " .. " + this.getSteps() + " .. " + this.getEndValue() + "]";
        }
        return "[" + this.getValue().toString() + "]";
    }

    @Override
    public boolean isRanged() {
        return this.shallBeRanged != RangeType.NO;
    }

    @Override
    public void toGalaxy(String namePrefix, String configPrefix, int depth, StringBuffer descBuffer, StringBuffer configBuffer, boolean addLine) throws Exception {
        namePrefix = namePrefix + "_" + GalaxyAdaptor.getLegalName(this.getName());
        configPrefix = configPrefix + namePrefix + ".";
        StringBuffer buf = new StringBuffer();
        EnumParameter temp = new EnumParameter(RangeType.class, "Define a single value (NO), a list of values (LIST) or a range of values (RANGE) for " + this.rangedParameter.getName(), true);
        temp.toGalaxy(namePrefix, configPrefix, depth + 1, buf, configBuffer, false);
        StringBuffer tmp = new StringBuffer();
        configBuffer.append("#if $" + configPrefix + namePrefix + "_RangeType == \"NO\"\n");
        this.rangedParameter.toGalaxy(namePrefix + "_NO", configPrefix, depth + 1, tmp, configBuffer, addLine);
        XMLParser.addTagsAndAttributes(tmp, "when", "value=\"NO\"");
        buf.append(tmp);
        tmp = new StringBuffer();
        configBuffer.append("#elif $" + configPrefix + namePrefix + "_RangeType == \"LIST\"\n");
        new SimpleParameter(DataType.STRING, this.rangedParameter.getName(), "Please enter a comma-separated list of values. " + this.rangedParameter.getComment(), true).toGalaxy(namePrefix + "_LIST", configPrefix, depth + 1, tmp, configBuffer, addLine);
        XMLParser.addTagsAndAttributes(tmp, "when", "value=\"LIST\"");
        buf.append(tmp);
        tmp = new StringBuffer();
        configBuffer.append("#elif $" + configPrefix + namePrefix + "_RangeType == \"RANGE\"\n");
        new SimpleParameter(this.rangedParameter.getDatatype(), this.rangedParameter.getName() + ": start value", "Please enter the start value. " + this.rangedParameter.getComment(), true).toGalaxy(namePrefix + "_RANGE", configPrefix, depth + 1, tmp, configBuffer, true);
        new SimpleParameter(this.rangedParameter.getDatatype(), this.rangedParameter.getName() + ": end value", "Please enter the end value. " + this.rangedParameter.getComment(), true).toGalaxy(namePrefix + "_RANGE", configPrefix, depth + 1, tmp, configBuffer, true);
        new SimpleParameter(this.rangedParameter.getDatatype(), this.rangedParameter.getName() + ": steps", "Please enter the number of steps between start and end value. " + this.rangedParameter.getComment(), true).toGalaxy(namePrefix + "_RANGE", configPrefix, depth + 1, tmp, configBuffer, true);
        temp = new EnumParameter(Scale.class, "Select a scaling between start and end value.", true);
        temp.toGalaxy(namePrefix + "_RANGE", configPrefix, depth + 1, tmp, configBuffer, false);
        XMLParser.addTagsAndAttributes(tmp, "when", "value=\"RANGE\"");
        buf.append(tmp);
        configBuffer.append("#end if\n");
        XMLParser.addTagsAndAttributes(buf, "conditional", "name=\"" + namePrefix + "\"");
        descBuffer.append(buf);
    }

    @Override
    public void fromGalaxy(String namePrefix, StringBuffer command) throws Exception {
        namePrefix = namePrefix + "_" + GalaxyAdaptor.getLegalName(this.getName());
        String type = XMLParser.extractForTag(command, namePrefix + "_RangeType").toString();
        this.setShallBeRanged(RangeType.valueOf(type));
        if (this.shallBeRanged == RangeType.NO) {
            this.setValue(XMLParser.extractForTag(command, namePrefix + "_NO_" + this.rangedParameter.getName().replaceAll("[\\s:-]+", "_")).toString());
        } else if (this.shallBeRanged == RangeType.LIST) {
            this.setValues(XMLParser.extractForTag(command, namePrefix + "_LIST_" + this.rangedParameter.getName().replaceAll("[\\s:-]+", "_")).toString());
        } else {
            this.setValues(XMLParser.extractForTag(command, namePrefix + "_RANGE_" + this.rangedParameter.getName().replaceAll("[\\s:-]+", "_") + "_start_value").toString(), XMLParser.extractObjectForTags(command, namePrefix + "_RANGE_" + this.rangedParameter.getName().replaceAll("[\\s:-]+", "_") + "_steps", Integer.TYPE), XMLParser.extractForTag(command, namePrefix + "_RANGE_" + this.rangedParameter.getName().replaceAll("[\\s:-]+", "_") + "_end_value").toString(), Scale.valueOf(XMLParser.extractForTag(command, namePrefix + "_RANGE_Scale").toString()));
        }
    }

    public static enum RangeType {
        NO,
        LIST,
        RANGE;

    }

    public static enum Scale {
        LOGSCALE,
        INVERSELOGSCALE,
        LINSCALE,
        EXPSCALE,
        LOGSCALE2,
        INVERSELOGSCALE2,
        LOGSCALE10,
        INVERSELOGSCALE10;

    }
}

