/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable.localMixture;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.Mutable;
import de.jstacs.sequenceScores.QuickScanningSequenceScore;
import de.jstacs.sequenceScores.statisticalModels.differentiable.AbstractDifferentiableStatisticalModel;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.ToolBox;
import de.jstacs.utils.random.DiMRGParams;
import de.jstacs.utils.random.DirichletMRG;
import de.jstacs.utils.random.DirichletMRGParams;
import de.jstacs.utils.random.FastDirichletMRGParams;
import de.jtem.numericalMethods.calculus.specialFunctions.Gamma;
import java.text.NumberFormat;
import java.util.Arrays;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder
extends AbstractDifferentiableStatisticalModel
implements Mutable,
QuickScanningSequenceScore {
    private int order;
    private int distance;
    private double ess;
    private double[] localMixtureScore;
    private double[][] ancestorScore;
    private double[][] depGrad;
    private double[][] componentMixtureParameters;
    private double[][][] ancestorMixtureParameters;
    private double[][][][] dependencyParameters;
    private double[] componentMixtureLogNorm;
    private double[][] ancestorMixtureLogNorm;
    private double[][][] dependencyLogNorm;
    private double[][] componentMixturePotential;
    private double[][][] ancestorMixturePotential;
    private double[][][][] dependencyPotential;
    private int[] componentMixtureIndex;
    private int[][] ancestorMixtureIndex;
    private int[][][] dependencyIndex;
    private int numParameter;
    private double q;
    private double[] e;
    private double[][] logGamma;
    private PriorType type;
    private static final String XML_TAG = "SLIM";

    public LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder(AlphabetContainer alphabets, int length, int order, int distance, double ess, double q, PriorType t) throws IllegalArgumentException {
        super(alphabets, length);
        if (!alphabets.isSimple()) {
            throw new IllegalArgumentException("Check alphabet");
        }
        if (ess < 0.0) {
            throw new IllegalArgumentException("Check ess");
        }
        this.ess = ess;
        if (order < 0) {
            throw new IllegalArgumentException("Check number of local components");
        }
        this.order = order;
        this.distance = distance;
        this.type = t;
        if (q <= 0.0 || q >= 1.0) {
            throw new IllegalArgumentException("Check q");
        }
        this.q = q;
        int a = (int)this.alphabets.getAlphabetLengthAt(0);
        this.dependencyParameters = new double[length][][][];
        this.componentMixtureParameters = new double[length][];
        this.ancestorMixtureParameters = new double[length][][];
        for (int l = 0; l < length; ++l) {
            this.componentMixtureParameters[l] = new double[Math.min(l, order) + 1];
            this.dependencyParameters[l] = new double[this.componentMixtureParameters[l].length][][];
            this.ancestorMixtureParameters[l] = new double[this.componentMixtureParameters[l].length][];
            int context = 1;
            int dist = 1;
            for (int o = 0; o < this.componentMixtureParameters[l].length; ++o) {
                this.dependencyParameters[l][o] = new double[context][a];
                if (o != 0) {
                    dist = Math.min(l - o + 1, distance);
                }
                this.ancestorMixtureParameters[l][o] = new double[dist];
                context *= a;
            }
        }
        this.init();
    }

    public LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder(StringBuffer xml) throws NonParsableException {
        super(xml);
        this.init();
    }

    public int getOrder() {
        return this.order;
    }

    public int getDistance() {
        return this.distance;
    }

    private void init() {
        int l;
        this.localMixtureScore = new double[this.order + 1];
        this.ancestorScore = new double[this.order + 1][this.length - 1];
        this.e = new double[this.order + 1];
        try {
            this.logGamma = (double[][])ArrayHandler.clone((Cloneable[])this.componentMixtureParameters);
            this.componentMixturePotential = (double[][])ArrayHandler.clone((Cloneable[])this.componentMixtureParameters);
            this.componentMixtureLogNorm = new double[this.length];
            this.componentMixtureIndex = new int[this.length];
            this.ancestorMixturePotential = (double[][][])ArrayHandler.clone((Cloneable[])this.ancestorMixtureParameters);
            this.dependencyPotential = (double[][][][])ArrayHandler.clone((Cloneable[])this.dependencyParameters);
            this.dependencyLogNorm = new double[this.length][][];
            this.dependencyIndex = new int[this.length][][];
            this.ancestorMixtureLogNorm = new double[this.length][];
            this.ancestorMixtureIndex = new int[this.length][];
            for (l = 0; l < this.length; ++l) {
                this.dependencyLogNorm[l] = new double[this.componentMixtureParameters[l].length][];
                this.dependencyIndex[l] = new int[this.componentMixtureParameters[l].length][];
                for (int o = 0; o < this.componentMixtureParameters[l].length; ++o) {
                    this.dependencyLogNorm[l][o] = new double[this.dependencyParameters[l][o].length];
                    this.dependencyIndex[l][o] = new int[this.dependencyParameters[l][o].length];
                }
                this.ancestorMixtureLogNorm[l] = new double[this.componentMixtureParameters[l].length];
                this.ancestorMixtureIndex[l] = new int[this.componentMixtureParameters[l].length];
            }
            int a = (int)this.alphabets.getAlphabetLengthAt(0);
            this.depGrad = new double[this.dependencyParameters[this.length - 1][this.dependencyParameters[this.length - 1].length - 1].length][a];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.precompute();
        this.numParameter = 0;
        for (l = 0; l < this.length; ++l) {
            this.componentMixtureIndex[l] = this.numParameter;
            this.numParameter += this.componentMixtureParameters[l].length;
            for (int c = 0; c < this.componentMixtureParameters[l].length; ++c) {
                this.ancestorMixtureIndex[l][c] = this.numParameter;
                this.numParameter += this.ancestorMixtureParameters[l][c].length;
                for (int b = 0; b < this.dependencyParameters[l][c].length; ++b) {
                    this.dependencyIndex[l][c][b] = this.numParameter;
                    this.numParameter += this.dependencyParameters[l][c][b].length;
                }
            }
        }
        if (this.type == PriorType.Complex_Mixture) {
            this.precomputeLogGamma();
        }
    }

    private void precompute() {
        for (int l = 0; l < this.length; ++l) {
            this.componentMixtureLogNorm[l] = Normalisation.logSumNormalisation(this.componentMixtureParameters[l], 0, this.componentMixtureParameters[l].length, this.componentMixturePotential[l], 0);
            for (int c = 0; c < this.componentMixtureParameters[l].length; ++c) {
                this.ancestorMixtureLogNorm[l][c] = Normalisation.logSumNormalisation(this.ancestorMixtureParameters[l][c], 0, this.ancestorMixtureParameters[l][c].length, this.ancestorMixturePotential[l][c], 0);
                for (int b = 0; b < this.dependencyParameters[l][c].length; ++b) {
                    this.dependencyLogNorm[l][c][b] = Normalisation.logSumNormalisation(this.dependencyParameters[l][c][b], 0, this.dependencyParameters[l][c][b].length, this.dependencyPotential[l][c][b], 0);
                }
            }
        }
    }

    @Override
    public LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder clone() throws CloneNotSupportedException {
        LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder clone = (LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder)super.clone();
        clone.componentMixtureParameters = (double[][])ArrayHandler.clone((Cloneable[])this.componentMixtureParameters);
        clone.ancestorMixtureParameters = (double[][][])ArrayHandler.clone((Cloneable[])this.ancestorMixtureParameters);
        clone.dependencyParameters = (double[][][][])ArrayHandler.clone((Cloneable[])this.dependencyParameters);
        clone.componentMixtureLogNorm = (double[])this.componentMixtureLogNorm.clone();
        clone.ancestorMixtureLogNorm = (double[][])ArrayHandler.clone((Cloneable[])this.ancestorMixtureLogNorm);
        clone.dependencyLogNorm = (double[][][])ArrayHandler.clone((Cloneable[])this.dependencyLogNorm);
        clone.componentMixturePotential = (double[][])ArrayHandler.clone((Cloneable[])this.componentMixturePotential);
        clone.ancestorMixturePotential = (double[][][])ArrayHandler.clone((Cloneable[])this.ancestorMixturePotential);
        clone.dependencyPotential = (double[][][][])ArrayHandler.clone((Cloneable[])this.dependencyPotential);
        clone.componentMixtureIndex = (int[])this.componentMixtureIndex.clone();
        clone.ancestorMixtureIndex = (int[][])ArrayHandler.clone((Cloneable[])this.ancestorMixtureIndex);
        clone.dependencyIndex = (int[][][])ArrayHandler.clone((Cloneable[])this.dependencyIndex);
        clone.localMixtureScore = (double[])this.localMixtureScore.clone();
        clone.ancestorScore = (double[][])ArrayHandler.clone((Cloneable[])this.ancestorScore);
        clone.depGrad = (double[][])ArrayHandler.clone((Cloneable[])this.depGrad);
        clone.e = (double[])this.e.clone();
        clone.logGamma = (double[][])ArrayHandler.clone((Cloneable[])this.logGamma);
        return clone;
    }

    @Override
    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        return 0;
    }

    @Override
    public double getLogNormalizationConstant() {
        return 0.0;
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex) throws Exception {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        int a = (int)this.alphabets.getAlphabetLengthAt(0);
        double f = this.ess == 0.0 ? (double)(a * (this.order + 1)) : this.ess;
        for (int l = 0; l < this.length; ++l) {
            if (this.type == PriorType.Complex_Mixture && this.componentMixtureParameters[l].length > 1) {
                int idx = (int)Math.floor(r.nextDouble() * (double)this.componentMixtureParameters[l].length);
                double v = (1.0 - this.q) / ((double)this.componentMixturePotential[l].length - 1.0);
                Arrays.fill(this.e, v * f);
                this.e[idx] = this.q * f;
            } else {
                Arrays.fill(this.e, f / (double)this.componentMixtureParameters[l].length);
            }
            LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.draw(this.componentMixtureParameters[l], this.componentMixtureParameters[l].length, new DirichletMRGParams(0, this.componentMixtureParameters[l].length, this.e));
            for (int c = 0; c < this.componentMixtureParameters[l].length; ++c) {
                int k = this.ancestorMixtureParameters[l][c].length;
                LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.draw(this.ancestorMixtureParameters[l][c], k, new FastDirichletMRGParams(this.e[c] / (double)k));
                FastDirichletMRGParams depPars = new FastDirichletMRGParams(this.e[c] / (double)(this.dependencyParameters[l][c].length * a));
                for (int b = 0; b < this.dependencyParameters[l][c].length; ++b) {
                    LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.draw(this.dependencyParameters[l][c][b], a, depPars);
                }
            }
        }
        this.precompute();
    }

    static void draw(double[] array, int end, DiMRGParams pars) {
        if (end > 1) {
            DirichletMRG.DEFAULT_INSTANCE.generateLog(array, 0, end, pars);
        }
    }

    @Override
    public void initializeFunction(int index, boolean freeParams, DataSet[] data, double[][] weights) throws Exception {
        for (int l = 0; l < this.length; ++l) {
            Arrays.fill(this.componentMixtureParameters[l], Math.log(this.q / ((double)this.componentMixtureParameters[l].length - 1.0)));
            this.componentMixtureParameters[l][0] = Math.log(1.0 - this.q);
            for (int c = 0; c < this.componentMixtureParameters[l].length; ++c) {
                Arrays.fill(this.ancestorMixtureParameters[l][c], 0.0);
                for (int b = 0; b < this.dependencyParameters[l][c].length; ++b) {
                    Arrays.fill(this.dependencyParameters[l][c][b], Math.exp(this.componentMixtureParameters[l][c]) / (double)this.dependencyParameters[l][c].length / (double)this.dependencyParameters[l][c][b].length);
                }
            }
        }
        double w = 1.0;
        int a = this.alphabets.getAlphabetIndexForPosition(0);
        for (int i = 0; i < data[index].getNumberOfElements(); ++i) {
            if (weights != null && weights[index] != null) {
                w = weights[index][i];
            }
            Sequence s = data[index].getElementAt(i);
            for (int l = 0; l < this.length; ++l) {
                for (int c = 0; c < this.componentMixtureParameters[l].length; ++c) {
                    int context = this.getOffset(s, l, c, this.dependencyParameters[0][0][0].length);
                    for (int k = 0; k < this.ancestorMixtureParameters[l][c].length; ++k) {
                        context = this.next(context, s, 0, l, c, k);
                        double[] dArray = this.dependencyParameters[l][c][context];
                        int n = s.discreteVal(l);
                        dArray[n] = dArray[n] + w;
                    }
                }
            }
        }
        for (int l = 0; l < this.length; ++l) {
            for (int c = 0; c < this.componentMixtureParameters[l].length; ++c) {
                for (int b = 0; b < this.dependencyParameters[l][c].length; ++b) {
                    Normalisation.sumNormalisation(this.dependencyParameters[l][c][b]);
                    for (a = 0; a < this.dependencyParameters[l][c][b].length; ++a) {
                        this.dependencyParameters[l][c][b][a] = Math.log(this.dependencyParameters[l][c][b][a]);
                    }
                }
            }
        }
        this.precompute();
    }

    private double unifGamma(double e, int anz) {
        return (double)anz * Gamma.logOfGamma((double)(e / (double)anz)) - Gamma.logOfGamma((double)e);
    }

    private double precomputePartLogGamma(int l) {
        double lg = 0.0;
        for (int i = 0; i < this.componentMixtureParameters[l].length; ++i) {
            lg += Gamma.logOfGamma((double)this.e[i]) * this.componentMixtureParameters[l][i];
        }
        lg -= Gamma.logOfGamma((double)this.ess);
        for (int c = 0; c < this.componentMixtureParameters[l].length; ++c) {
            lg += this.unifGamma(this.e[c], this.ancestorMixtureParameters[l][c].length);
            for (int b = 0; b < this.dependencyParameters[l][c].length; ++b) {
                lg += this.unifGamma(this.e[c] / (double)this.dependencyParameters[l][c].length, this.dependencyParameters[l][c][b].length);
            }
        }
        return lg;
    }

    private void precomputeLogGamma() {
        for (int l = 0; l < this.length; ++l) {
            double v;
            double w;
            if (this.componentMixtureParameters[l].length == 1) {
                w = 1.0;
                v = 0.0;
            } else {
                w = this.q;
                v = (1.0 - this.q) / ((double)this.componentMixturePotential[l].length - 1.0);
            }
            Arrays.fill(this.e, v * this.ess);
            for (int i = 0; i < this.componentMixtureParameters[l].length; ++i) {
                this.e[i] = w * this.ess;
                double[] dArray = this.logGamma[l];
                int n = i;
                dArray[n] = dArray[n] + this.precomputePartLogGamma(l);
                this.e[i] = v * this.ess;
            }
        }
    }

    private static final double logPrior(double ess, double[] parameter, double logNorm) {
        double res = 0.0;
        double e = ess / (double)parameter.length;
        for (int i = 0; i < parameter.length; ++i) {
            res += e * parameter[i];
        }
        return res - ess * logNorm;
    }

    private void setLogPriorTerm(int l, int index, double logP) {
        this.localMixtureScore[index] = logP;
        for (int i = 0; i < this.componentMixtureParameters[l].length; ++i) {
            int n = index;
            this.localMixtureScore[n] = this.localMixtureScore[n] + this.e[i] * this.componentMixtureParameters[l][i];
        }
        int n = index;
        this.localMixtureScore[n] = this.localMixtureScore[n] - this.ess * this.componentMixtureLogNorm[l];
        for (int c = 0; c < this.componentMixtureParameters[l].length; ++c) {
            int n2 = index;
            this.localMixtureScore[n2] = this.localMixtureScore[n2] + LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.logPrior(this.e[c], this.ancestorMixtureParameters[l][c], this.ancestorMixtureLogNorm[l][c]);
            for (int b = 0; b < this.dependencyParameters[l][c].length; ++b) {
                int n3 = index;
                this.localMixtureScore[n3] = this.localMixtureScore[n3] + LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.logPrior(this.e[c] / (double)this.dependencyParameters[l][c].length, this.dependencyParameters[l][c][b], this.dependencyLogNorm[l][c][b]);
            }
        }
    }

    @Override
    public double getLogPriorTerm() {
        double logPrior = 0.0;
        double logP = 0.0;
        block5: for (int l = 0; l < this.length; ++l) {
            double v;
            double w;
            if (this.componentMixtureParameters[l].length == 1) {
                w = 1.0;
                v = 0.0;
            } else {
                w = this.q;
                v = (1.0 - this.q) / ((double)this.componentMixturePotential[l].length - 1.0);
            }
            switch (this.type) {
                case BDeu: {
                    Arrays.fill(this.e, this.ess / (double)this.componentMixtureParameters[l].length);
                    this.setLogPriorTerm(l, 0, 1.0);
                    logPrior += this.localMixtureScore[0];
                    continue block5;
                }
                case Complex_Mixture: {
                    Arrays.fill(this.e, v * this.ess);
                    for (int i = 0; i < this.componentMixtureParameters[l].length; ++i) {
                        this.e[i] = w * this.ess;
                        this.setLogPriorTerm(l, i, logP);
                        int n = i;
                        this.localMixtureScore[n] = this.localMixtureScore[n] + this.logGamma[l][i];
                        this.e[i] = v * this.ess;
                    }
                    logPrior += Normalisation.getLogSum(0, this.componentMixtureParameters[l].length, this.localMixtureScore);
                    continue block5;
                }
                case Simple_Mixture: {
                    int c = 0;
                    while (c < this.componentMixtureParameters[l].length) {
                        this.localMixtureScore[c] = 0.0;
                        for (int i = 0; i < this.componentMixtureParameters[l].length; ++i) {
                            int n = c;
                            this.localMixtureScore[n] = this.localMixtureScore[n] + (i == c ? w : v) * this.ess * this.componentMixtureParameters[l][i];
                        }
                        int n = c++;
                        this.localMixtureScore[n] = this.localMixtureScore[n] - this.ess * this.componentMixtureLogNorm[l];
                    }
                    logPrior += Normalisation.getLogSum(0, this.componentMixtureParameters[l].length, this.localMixtureScore);
                    double e = this.ess / (double)this.componentMixtureParameters[l].length;
                    for (int c2 = 0; c2 < this.componentMixtureParameters[l].length; ++c2) {
                        logPrior += LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.logPrior(e, this.ancestorMixtureParameters[l][c2], this.ancestorMixtureLogNorm[l][c2]);
                        for (int b = 0; b < this.dependencyParameters[l][c2].length; ++b) {
                            logPrior += LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.logPrior(e / (double)this.dependencyParameters[l][c2].length, this.dependencyParameters[l][c2][b], this.dependencyLogNorm[l][c2][b]);
                        }
                    }
                    continue block5;
                }
            }
        }
        return logPrior;
    }

    private static final void addGrad(double ess, double[] potential, double[] grad, int start, double w) {
        double e = ess / (double)potential.length;
        for (int i = 0; i < potential.length; ++i) {
            int n = start + i;
            grad[n] = grad[n] + w * (e - ess * potential[i]);
        }
    }

    private void addGradientPartOfLogPriorTerm(double[] grad, int start, int l, double w) throws Exception {
        for (int i = 0; i < this.componentMixtureParameters[l].length; ++i) {
            int n = start + this.componentMixtureIndex[l] + i;
            grad[n] = grad[n] + w * (this.e[i] - this.ess * this.componentMixturePotential[l][i]);
        }
        for (int c = 0; c < this.componentMixtureParameters[l].length; ++c) {
            LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.addGrad(this.e[c], this.ancestorMixturePotential[l][c], grad, start + this.ancestorMixtureIndex[l][c], w);
            for (int b = 0; b < this.dependencyParameters[l][c].length; ++b) {
                LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.addGrad(this.e[c] / (double)this.dependencyParameters[l][c].length, this.dependencyPotential[l][c][b], grad, start + this.dependencyIndex[l][c][b], w);
            }
        }
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int start) throws Exception {
        double logP = 0.0;
        block5: for (int l = 0; l < this.length; ++l) {
            double v;
            double w;
            if (this.componentMixtureParameters[l].length == 1) {
                w = 1.0;
                v = 0.0;
            } else {
                w = this.q;
                v = (1.0 - this.q) / ((double)this.componentMixturePotential[l].length - 1.0);
            }
            switch (this.type) {
                case BDeu: {
                    Arrays.fill(this.e, this.ess / (double)this.componentMixtureParameters[l].length);
                    this.addGradientPartOfLogPriorTerm(grad, start, l, 1.0);
                    continue block5;
                }
                case Complex_Mixture: {
                    int i;
                    Arrays.fill(this.e, v * this.ess);
                    for (i = 0; i < this.componentMixtureParameters[l].length; ++i) {
                        this.e[i] = w * this.ess;
                        this.setLogPriorTerm(l, i, logP);
                        this.e[i] = v * this.ess;
                    }
                    Normalisation.logSumNormalisation(this.localMixtureScore, 0, this.componentMixtureParameters[l].length);
                    for (i = 0; i < this.componentMixtureParameters[l].length; ++i) {
                        this.e[i] = w * this.ess;
                        this.addGradientPartOfLogPriorTerm(grad, start, l, this.localMixtureScore[i]);
                        this.e[i] = v * this.ess;
                    }
                    continue block5;
                }
                case Simple_Mixture: {
                    int i;
                    int c = 0;
                    while (c < this.componentMixtureParameters[l].length) {
                        this.localMixtureScore[c] = 0.0;
                        for (i = 0; i < this.componentMixtureParameters[l].length; ++i) {
                            int n = c;
                            this.localMixtureScore[n] = this.localMixtureScore[n] + (i == c ? w : v) * this.ess * this.componentMixtureParameters[l][i];
                        }
                        int n = c++;
                        this.localMixtureScore[n] = this.localMixtureScore[n] - this.ess * this.componentMixtureLogNorm[l];
                    }
                    Normalisation.logSumNormalisation(this.localMixtureScore, 0, this.componentMixtureParameters[l].length);
                    for (c = 0; c < this.componentMixtureParameters[l].length; ++c) {
                        for (i = 0; i < this.componentMixtureParameters[l].length; ++i) {
                            int n = start + this.componentMixtureIndex[l] + c;
                            grad[n] = grad[n] + this.localMixtureScore[i] * (i == c ? w : v) * this.ess;
                        }
                        int n = start + this.componentMixtureIndex[l] + c;
                        grad[n] = grad[n] - this.ess * this.componentMixturePotential[l][c];
                    }
                    double e = this.ess / (double)this.componentMixtureParameters[l].length;
                    for (int c2 = 0; c2 < this.componentMixtureParameters[l].length; ++c2) {
                        LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.addGrad(e, this.ancestorMixturePotential[l][c2], grad, start + this.ancestorMixtureIndex[l][c2], 1.0);
                        for (int b = 0; b < this.dependencyParameters[l][c2].length; ++b) {
                            LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.addGrad(e / (double)this.dependencyParameters[l][c2].length, this.dependencyPotential[l][c2][b], grad, start + this.dependencyIndex[l][c2][b], 1.0);
                        }
                    }
                    continue block5;
                }
            }
        }
    }

    @Override
    public double getESS() {
        return this.ess;
    }

    private int getOffset(Sequence seq, int start, int order, int a) {
        int offset = 0;
        for (int o = 1; o < order; ++o) {
            offset = offset * a + seq.discreteVal(start - o);
        }
        return offset;
    }

    private int getOffset(int[] seq, int start, int order, int a) {
        int offset = 0;
        for (int o = 1; o < order; ++o) {
            offset = offset * a + seq[start - o];
        }
        return offset;
    }

    private int next(int context, Sequence seq, int start, int l, int c, int m) {
        return (context * this.dependencyParameters[l][c][0].length + seq.discreteVal(start + l - c - m)) % this.dependencyParameters[l][c].length;
    }

    private int next(int context, int[] seq, int start, int l, int c, int m) {
        return (context * this.dependencyParameters[l][c][0].length + seq[start + l - c - m]) % this.dependencyParameters[l][c].length;
    }

    @Override
    public boolean[][] getInfixFilter(int kmer, double thresh, int ... start) {
        if (this.order > 1) {
            throw new NotImplementedException();
        }
        double[][] val = this.getCum_Complex(kmer);
        double[] cum = val[0];
        double[] revCum = val[1];
        int a = this.dependencyParameters[0][0][0].length;
        boolean[][] use = new boolean[start.length][(int)Math.pow(a, kmer)];
        int maxSymbol = a - 1;
        int z = 0;
        int[] seq = new int[kmer + 1];
        double[][] prefixScore = new double[start.length][kmer + 1];
        int l = 0;
        double[] best = new double[start.length];
        Arrays.fill(best, Double.NEGATIVE_INFINITY);
        do {
            for (int s = 0; s < start.length; ++s) {
                this.getInfixScores(s, start[s], l, kmer, seq, prefixScore, null);
                if (prefixScore[s][kmer] > best[s]) {
                    best[s] = prefixScore[s][kmer];
                }
                use[s][z] = cum[start[s]] + prefixScore[s][kmer] + revCum[start[s] + kmer] >= thresh;
            }
            ++z;
            l = kmer - 1 - LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.next(seq, maxSymbol);
        } while (seq[kmer] == 0);
        return use;
    }

    protected double[][] getCum_Naive(int kmer) {
        int l;
        int len = this.getLength();
        double[] max = new double[len];
        double[] cum = new double[len + 1];
        double[] revCum = new double[len + 1];
        double last = 0.0;
        for (l = 0; l < max.length; ++l) {
            max[l] = Double.NEGATIVE_INFINITY;
            for (int a = 0; a < this.dependencyPotential[l][0][0].length; ++a) {
                double v = 0.0;
                for (int c = 0; c < this.componentMixtureParameters[l].length; ++c) {
                    int an = 0;
                    for (int i = 1; i < this.dependencyParameters[l][c].length; ++i) {
                        if (!(this.dependencyPotential[l][c][an][a] < this.dependencyPotential[l][c][i][a])) continue;
                        an = i;
                    }
                    this.localMixtureScore[c] = this.componentMixtureParameters[l][c] - this.componentMixtureLogNorm[l] + this.dependencyParameters[l][c][an][a] - this.dependencyLogNorm[l][c][an];
                }
                v = Normalisation.getLogSum(0, this.componentMixtureParameters[l].length, this.localMixtureScore);
                if (!(v > max[l])) continue;
                max[l] = v;
            }
            cum[l + 1] = last + max[l];
            last = cum[l + 1];
        }
        last = 0.0;
        for (l = len - 1; l >= 0; --l) {
            revCum[l] = last + max[l];
            last = revCum[l];
        }
        return new double[][]{cum, revCum};
    }

    protected double[][] getCum_Complex(int kmer) {
        int i;
        int s;
        int start = this.getLength() - kmer + 1;
        int len = this.getLength();
        double[][] max = new double[kmer][];
        for (int k = 0; k < max.length; ++k) {
            max[k] = new double[len - k];
            Arrays.fill(max[k], Double.NEGATIVE_INFINITY);
        }
        int a = this.dependencyParameters[0][0][0].length;
        double[][] prefixScore = new double[len][kmer + 1];
        int maxSymbol = a - 1;
        int[] seq = new int[kmer + 1];
        int l = 0;
        do {
            for (s = 0; s < start; ++s) {
                this.getInfixScores(s, s, l, kmer, seq, prefixScore, max);
            }
            l = kmer - 1 - LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.next(seq, maxSymbol);
        } while (seq[kmer] == 0);
        for (s = start; s < len; ++s) {
            int gmer = len - s;
            Arrays.fill(seq, 0);
            l = 0;
            do {
                this.getInfixScores(s, s, l, gmer, seq, prefixScore, max);
                l = gmer - 1 - LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.next(seq, maxSymbol);
            } while (seq[gmer] == 0);
        }
        double[] cum = new double[len + 1];
        Arrays.fill(cum, Double.POSITIVE_INFINITY);
        cum[0] = 0.0;
        for (i = 0; i < len; ++i) {
            for (int j = Math.min(i, kmer - 1); j >= 0; --j) {
                if (!(cum[i + 1] > cum[i - j] + max[j][i - j])) continue;
                cum[i + 1] = cum[i - j] + max[j][i - j];
            }
        }
        double[] revCum = new double[len + 1];
        Arrays.fill(revCum, Double.POSITIVE_INFINITY);
        revCum[len] = 0.0;
        for (i = len - 1; i >= 0; --i) {
            for (int j = Math.min(len - 1 - i, kmer - 1); j >= 0; --j) {
                if (!(revCum[i] > revCum[i + 1 + j] + max[j][i])) continue;
                revCum[i] = revCum[i + 1 + j] + max[j][i];
            }
        }
        return new double[][]{cum, revCum};
    }

    protected void getInfixScores(int s, int start, int l, int kmer, int[] seq, double[][] prefixScore, double[][] max) {
        while (l < kmer) {
            int pos = l + start;
            int ll = kmer - 1 - l;
            int current = seq[ll];
            this.localMixtureScore[0] = this.componentMixtureParameters[pos][0] - this.componentMixtureLogNorm[pos] + this.dependencyParameters[pos][0][0][current] - this.dependencyLogNorm[pos][0][0];
            for (int c = 1; c < this.componentMixtureParameters[pos].length; ++c) {
                int g = this.ancestorMixtureParameters[pos][c].length;
                for (int m = 0; m < g; ++m) {
                    int an;
                    if (ll + c + m < kmer) {
                        an = seq[ll + c + m];
                    } else {
                        an = 0;
                        for (int i = 1; i < this.dependencyParameters[pos][c].length; ++i) {
                            if (!(this.dependencyPotential[pos][c][an][current] < this.dependencyPotential[pos][c][i][current])) continue;
                            an = i;
                        }
                    }
                    this.ancestorScore[c][m] = this.ancestorMixtureParameters[pos][c][m] - this.ancestorMixtureLogNorm[pos][c] + this.dependencyParameters[pos][c][an][current] - this.dependencyLogNorm[pos][c][an];
                }
                this.localMixtureScore[c] = this.componentMixtureParameters[pos][c] - this.componentMixtureLogNorm[pos] + Normalisation.getLogSum(0, g, this.ancestorScore[c]);
            }
            double score = Normalisation.getLogSum(0, this.componentMixtureParameters[pos].length, this.localMixtureScore);
            prefixScore[s][l + 1] = prefixScore[s][l] + score;
            if (max != null && prefixScore[s][l + 1] > max[l][s]) {
                max[l][s] = prefixScore[s][l + 1];
            }
            ++l;
        }
    }

    private static int next(int[] seq, int maxSymbol) {
        int i = 0;
        while (seq[i] == maxSymbol) {
            seq[i++] = 0;
        }
        int n = i;
        seq[n] = seq[n] + 1;
        return i;
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start) {
        double score = 0.0;
        for (int l = 0; l < this.length; ++l) {
            int current = seq.discreteVal(start + l);
            this.localMixtureScore[0] = this.componentMixtureParameters[l][0] - this.componentMixtureLogNorm[l] + this.dependencyParameters[l][0][0][current] - this.dependencyLogNorm[l][0][0];
            for (int c = 1; c < this.componentMixtureParameters[l].length; ++c) {
                int k = this.ancestorMixtureParameters[l][c].length;
                int an = this.getOffset(seq, start + l, c, this.dependencyParameters[0][0][0].length);
                for (int m = 0; m < k; ++m) {
                    an = this.next(an, seq, start, l, c, m);
                    this.ancestorScore[c][m] = this.ancestorMixtureParameters[l][c][m] - this.ancestorMixtureLogNorm[l][c] + this.dependencyParameters[l][c][an][current] - this.dependencyLogNorm[l][c][an];
                }
                this.localMixtureScore[c] = this.componentMixtureParameters[l][c] - this.componentMixtureLogNorm[l] + Normalisation.getLogSum(0, k, this.ancestorScore[c]);
            }
            score += Normalisation.getLogSum(0, this.componentMixtureParameters[l].length, this.localMixtureScore);
        }
        return score;
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        double score = 0.0;
        for (int l = 0; l < this.length; ++l) {
            int m;
            int an;
            int k;
            int c;
            int current = seq.discreteVal(start + l);
            this.localMixtureScore[0] = this.componentMixtureParameters[l][0] - this.componentMixtureLogNorm[l] + this.dependencyParameters[l][0][0][current] - this.dependencyLogNorm[l][0][0];
            for (c = 1; c < this.componentMixtureParameters[l].length; ++c) {
                k = this.ancestorMixtureParameters[l][c].length;
                an = this.getOffset(seq, start + l, c, this.dependencyParameters[0][0][0].length);
                for (m = 0; m < k; ++m) {
                    an = this.next(an, seq, start, l, c, m);
                    this.ancestorScore[c][m] = this.ancestorMixtureParameters[l][c][m] - this.ancestorMixtureLogNorm[l][c] + this.dependencyParameters[l][c][an][current] - this.dependencyLogNorm[l][c][an];
                }
                this.localMixtureScore[c] = this.componentMixtureParameters[l][c] - this.componentMixtureLogNorm[l] + Normalisation.logSumNormalisation(this.ancestorScore[c], 0, k);
            }
            score += Normalisation.logSumNormalisation(this.localMixtureScore, 0, this.componentMixtureParameters[l].length);
            for (c = 0; c < this.componentMixtureParameters[l].length; ++c) {
                indices.add(this.componentMixtureIndex[l] + c);
                partialDer.add(this.localMixtureScore[c] - this.componentMixturePotential[l][c]);
            }
            for (int a = 0; a < this.dependencyParameters[l][0][0].length; ++a) {
                indices.add(this.dependencyIndex[l][0][0] + a);
                partialDer.add(this.localMixtureScore[0] * ((double)(a == current ? 1 : 0) - this.dependencyPotential[l][0][0][a]));
            }
            for (c = 1; c < this.componentMixtureParameters[l].length; ++c) {
                for (int a = 0; a < this.dependencyParameters[l][c].length; ++a) {
                    Arrays.fill(this.depGrad[a], 0.0);
                }
                k = this.ancestorMixtureParameters[l][c].length;
                an = this.getOffset(seq, start + l, c, this.dependencyParameters[0][0][0].length);
                for (m = 0; m < k; ++m) {
                    indices.add(this.ancestorMixtureIndex[l][c] + m);
                    partialDer.add(this.localMixtureScore[c] * (this.ancestorScore[c][m] - this.ancestorMixturePotential[l][c][m]));
                    an = this.next(an, seq, start, l, c, m);
                    for (int a = 0; a < this.depGrad[an].length; ++a) {
                        double[] dArray = this.depGrad[an];
                        int n = a;
                        dArray[n] = dArray[n] + this.ancestorScore[c][m] * ((double)(a == current ? 1 : 0) - this.dependencyPotential[l][c][an][a]);
                    }
                }
                for (int a = 0; a < this.dependencyParameters[l][c].length; ++a) {
                    for (int b = 0; b < this.dependencyParameters[l][c][a].length; ++b) {
                        if (this.depGrad[a][b] == 0.0) continue;
                        indices.add(this.dependencyIndex[l][c][a] + b);
                        partialDer.add(this.localMixtureScore[c] * this.depGrad[a][b]);
                    }
                }
            }
        }
        return score;
    }

    @Override
    public int getNumberOfParameters() {
        return this.numParameter;
    }

    private void get(int start, double[] parameter, double[] array) {
        for (int i = 0; i < parameter.length; ++i) {
            array[start + i] = parameter[i];
        }
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        double[] res = new double[this.numParameter];
        for (int l = 0; l < this.length; ++l) {
            this.get(this.componentMixtureIndex[l], this.componentMixtureParameters[l], res);
            for (int c = 0; c < this.componentMixtureParameters[l].length; ++c) {
                this.get(this.ancestorMixtureIndex[l][c], this.ancestorMixtureParameters[l][c], res);
                for (int b = 0; b < this.dependencyParameters[l][c].length; ++b) {
                    this.get(this.dependencyIndex[l][c][b], this.dependencyParameters[l][c][b], res);
                }
            }
        }
        return res;
    }

    private void set(int start, double[] parameter, double[] array) {
        for (int i = 0; i < parameter.length; ++i) {
            parameter[i] = array[start + i];
        }
    }

    public void set(int position, double[] pars) {
        for (int i = 0; i < this.dependencyParameters[position].length; ++i) {
            for (int j = 0; j < this.dependencyParameters[position][i].length; ++j) {
                System.arraycopy(pars, 0, this.dependencyParameters[position][i][j], 0, pars.length);
            }
        }
        Arrays.fill(this.componentMixtureParameters[position], -1000.0);
        this.componentMixtureParameters[position][0] = 0.0;
        this.precompute();
    }

    @Override
    public void setParameters(double[] params, int start) {
        for (int l = 0; l < this.length; ++l) {
            this.set(start + this.componentMixtureIndex[l], this.componentMixtureParameters[l], params);
            for (int c = 0; c < this.componentMixtureParameters[l].length; ++c) {
                this.set(start + this.ancestorMixtureIndex[l][c], this.ancestorMixtureParameters[l][c], params);
                for (int b = 0; b < this.dependencyParameters[l][c].length; ++b) {
                    this.set(start + this.dependencyIndex[l][c][b], this.dependencyParameters[l][c][b], params);
                }
            }
        }
        this.precompute();
    }

    @Override
    public String getInstanceName() {
        return "slim(" + this.order + ", " + this.distance + ", " + (Object)((Object)this.type) + " " + this.ess + " " + this.q + ")";
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.alphabets, "alphabets");
        XMLParser.appendObjectWithTags(xml, this.length, "length");
        XMLParser.appendObjectWithTags(xml, this.order, "order");
        XMLParser.appendObjectWithTags(xml, this.distance, "distance");
        XMLParser.appendObjectWithTags(xml, this.ess, "ess");
        XMLParser.appendObjectWithTags(xml, this.componentMixtureParameters, "componentMixtureParameters");
        XMLParser.appendObjectWithTags(xml, this.ancestorMixtureParameters, "ancestorMixtureParameters");
        XMLParser.appendObjectWithTags(xml, this.dependencyParameters, "dependencyParameters");
        XMLParser.appendObjectWithTags(xml, (Object)this.type, "priorType");
        XMLParser.appendObjectWithTags(xml, this.q, "q");
        XMLParser.addTags(xml, XML_TAG);
        return xml;
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, XML_TAG);
        this.alphabets = (AlphabetContainer)XMLParser.extractObjectForTags(xml, "alphabets");
        this.length = (Integer)XMLParser.extractObjectForTags(xml, "length");
        this.order = (Integer)XMLParser.extractObjectForTags(xml, "order");
        this.distance = (Integer)XMLParser.extractObjectForTags(xml, "distance");
        this.ess = (Double)XMLParser.extractObjectForTags(xml, "ess");
        this.componentMixtureParameters = (double[][])XMLParser.extractObjectForTags(xml, "componentMixtureParameters");
        this.ancestorMixtureParameters = (double[][][])XMLParser.extractObjectForTags(xml, "ancestorMixtureParameters");
        this.dependencyParameters = (double[][][][])XMLParser.extractObjectForTags(xml, "dependencyParameters");
        this.type = (PriorType)((Object)XMLParser.extractObjectForTags(xml, "priorType"));
        this.q = (Double)XMLParser.extractObjectForTags(xml, "q");
    }

    @Override
    public String toString(NumberFormat nf) {
        StringBuffer res = new StringBuffer();
        DiscreteAlphabet abc = (DiscreteAlphabet)this.alphabets.getAlphabetAt(0);
        for (int l = 0; l < this.length; ++l) {
            for (int c = 0; c < this.componentMixtureParameters[l].length; ++c) {
                res.append("P_" + l + "(c=" + c + ")=" + nf.format(this.componentMixturePotential[l][c]) + "\n");
                if (c != 0) {
                    res.append("P_" + l + "(p|c=" + c + ")=" + ToolBox.toString(this.ancestorMixturePotential[l][c], nf) + "\n");
                }
                for (int b = 0; b < this.dependencyParameters[l][c].length; ++b) {
                    res.append("P_" + l + "(x|");
                    if (c > 0) {
                        int h = b;
                        res.append("y=");
                        for (int j = 0; j < c; ++j) {
                            res.append(abc.getSymbolAt(h % this.dependencyParameters[0][0][0].length));
                            h /= this.dependencyParameters[0][0][0].length;
                        }
                        res.append(",");
                    }
                    res.append("c=" + c + ")=" + ToolBox.toString(this.dependencyPotential[l][c][b], nf) + "\n");
                }
                res.append("\n");
            }
            res.append("\n");
        }
        return res.toString() + this.getGraphviz();
    }

    public double[][][] getConditionalProbabilities(int component) throws CloneNotSupportedException {
        double[][][] condProbs = new double[this.dependencyPotential.length][][];
        for (int i = 0; i < condProbs.length; ++i) {
            condProbs[i] = this.dependencyPotential[i].length > component ? (double[][])ArrayHandler.clone((Cloneable[])this.dependencyPotential[i][component]) : new double[0][0];
        }
        return condProbs;
    }

    public double[][] getPWMParameters() throws CloneNotSupportedException {
        double[][] pwm = new double[this.length][];
        for (int l = 0; l < this.length; ++l) {
            pwm[l] = (double[])this.dependencyParameters[l][0][0].clone();
            Normalisation.logSumNormalisation(pwm[l]);
        }
        return pwm;
    }

    public double[][] getMixtureProbabilities() throws CloneNotSupportedException {
        return (double[][])ArrayHandler.clone((Cloneable[])this.componentMixturePotential);
    }

    public double[][] getAncestorProbabilities(int component) {
        double[][] ancProb = new double[this.ancestorMixturePotential.length][];
        for (int i = 0; i < ancProb.length; ++i) {
            ancProb[i] = this.ancestorMixturePotential[i].length > component ? (double[])this.ancestorMixturePotential[i][component].clone() : new double[0];
        }
        return ancProb;
    }

    public String getGraphviz() {
        StringBuffer res = new StringBuffer();
        for (int l = 0; l < this.length; ++l) {
            for (int c = 1; c < this.componentMixtureParameters[l].length; ++c) {
                for (int p = 0; p < this.ancestorMixturePotential[l][c].length; ++p) {
                    String w = Integer.toHexString((int)(256.0 * (1.0 - this.componentMixturePotential[l][c] * this.ancestorMixturePotential[l][c][p])));
                    if (w.length() == 1) {
                        w = "0" + w;
                    }
                    res.append(l - p - 1 + " -> " + l + "[color=\"#" + w + "" + w + "" + w + "\"]\n");
                }
            }
        }
        return res.toString();
    }

    @Override
    public int getNumberOfRecommendedStarts() {
        return 1;
    }

    @Override
    public boolean modify(int offsetLeft, int offsetRight) {
        if (offsetLeft != 0 || offsetRight != 0) {
            int oldLength = this.length;
            this.length = oldLength - offsetLeft + offsetRight;
            boolean modLength = oldLength != this.length;
            int a = (int)this.alphabets.getAlphabetLengthAt(0);
            double[][][][] newDependencyParameters = new double[this.length][][][];
            double[][] newComponentMixtureParameters = new double[this.length][];
            double[][][] newAncestorMixtureParameters = new double[this.length][][];
            int oldIndex = offsetLeft;
            int l = 0;
            while (l < this.length) {
                int dist;
                int o;
                int m = Math.min(l, this.order) + 1;
                newAncestorMixtureParameters[l] = new double[m][];
                if (oldIndex >= 0 && oldIndex < oldLength) {
                    int n = Math.min(m, this.componentMixtureParameters[oldIndex].length);
                    if (m == this.componentMixtureParameters[oldIndex].length) {
                        newDependencyParameters[l] = this.dependencyParameters[oldIndex];
                        newComponentMixtureParameters[l] = this.componentMixtureParameters[oldIndex];
                    } else {
                        int i;
                        newDependencyParameters[l] = new double[m][][];
                        newComponentMixtureParameters[l] = new double[m];
                        for (i = 0; i < n; ++i) {
                            double sum = ToolBox.sum(0, n, this.componentMixturePotential[oldIndex]);
                            double f = (double)n / (double)m;
                            newComponentMixtureParameters[l][i] = Math.log(this.componentMixturePotential[oldIndex][i] / sum * f);
                            newDependencyParameters[l][i] = this.dependencyParameters[oldIndex][i];
                        }
                        for (i = n; i < m; ++i) {
                            newDependencyParameters[l][i] = new double[newDependencyParameters[l][i - 1].length * 4][a];
                            int b = 0;
                            for (int j = 0; j < newDependencyParameters[l][i - 1].length; ++j) {
                                int c = 0;
                                while (c < a) {
                                    System.arraycopy(newDependencyParameters[l][i - 1][j], 0, newDependencyParameters[l][i][b], 0, newDependencyParameters[l][i - 1][j].length);
                                    ++c;
                                    ++b;
                                }
                            }
                        }
                        Arrays.fill(newComponentMixtureParameters[l], n, m, -Math.log(m));
                    }
                    newAncestorMixtureParameters[l][0] = new double[1];
                    for (o = 1; o < newAncestorMixtureParameters[l].length; ++o) {
                        dist = Math.min(l - o + 1, this.distance);
                        newAncestorMixtureParameters[l][o] = new double[dist];
                        Arrays.fill(newAncestorMixtureParameters[l][o], -Math.log(dist));
                        if (o >= this.ancestorMixtureParameters[oldIndex].length) continue;
                        int h = Math.min(dist, this.ancestorMixtureParameters[oldIndex][o].length);
                        double sum = ToolBox.sum(0, h, this.ancestorMixturePotential[oldIndex][o]);
                        double f = (double)h / (double)dist;
                        for (int j = 0; j < h; ++j) {
                            newAncestorMixtureParameters[l][o][j] = Math.log(this.ancestorMixturePotential[oldIndex][o][j] / sum * f);
                        }
                    }
                } else {
                    newComponentMixtureParameters[l] = new double[m];
                    newDependencyParameters[l] = new double[newComponentMixtureParameters[l].length][][];
                    newAncestorMixtureParameters[l] = new double[newComponentMixtureParameters[l].length][];
                    int context = 1;
                    dist = 1;
                    for (o = 0; o < newComponentMixtureParameters[l].length; ++o) {
                        newDependencyParameters[l][o] = new double[context][a];
                        if (o != 0) {
                            dist = Math.min(l - o + 1, this.distance);
                        }
                        newAncestorMixtureParameters[l][o] = new double[dist];
                        context *= a;
                    }
                }
                ++l;
                ++oldIndex;
            }
            this.dependencyParameters = newDependencyParameters;
            this.componentMixtureParameters = newComponentMixtureParameters;
            this.ancestorMixtureParameters = newAncestorMixtureParameters;
            if (modLength) {
                this.init();
            } else {
                this.precompute();
            }
        }
        return true;
    }

    @Override
    public void fillInfixScore(int[] seq, int start, int length, double[] scores) {
        for (int l = start; l < start + length; ++l) {
            int current = seq[l];
            this.localMixtureScore[0] = this.componentMixtureParameters[l][0] - this.componentMixtureLogNorm[l] + this.dependencyParameters[l][0][0][current] - this.dependencyLogNorm[l][0][0];
            for (int c = 1; c < this.componentMixtureParameters[l].length; ++c) {
                int k = this.ancestorMixtureParameters[l][c].length;
                int an = this.getOffset(seq, l, c, this.dependencyParameters[0][0][0].length);
                for (int m = 0; m < k; ++m) {
                    an = this.next(an, seq, 0, l, c, m);
                    this.ancestorScore[c][m] = this.ancestorMixtureParameters[l][c][m] - this.ancestorMixtureLogNorm[l][c] + this.dependencyParameters[l][c][an][current] - this.dependencyLogNorm[l][c][an];
                }
                this.localMixtureScore[c] = this.componentMixtureParameters[l][c] - this.componentMixtureLogNorm[l] + Normalisation.getLogSum(0, k, this.ancestorScore[c]);
            }
            scores[l] = Normalisation.getLogSum(0, this.componentMixtureParameters[l].length, this.localMixtureScore);
        }
    }

    public static enum PriorType {
        BDeu,
        Simple_Mixture,
        Complex_Mixture;

    }
}

