/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import java.util.Formatter;
import java.util.Locale;
import umontreal.iro.lecuyer.probdist.Distribution;

public class DiscreteDistribution
implements Distribution {
    protected double[] cdf = null;
    protected double[] pr = null;
    protected int xmin = 0;
    protected int xmax = 0;
    protected int xmed = 0;
    protected int nObs;
    protected int nObsTot;
    protected double[] obs;
    protected double[] sortedObs;
    protected double supportA = Double.NEGATIVE_INFINITY;
    protected double supportB = Double.POSITIVE_INFINITY;

    protected DiscreteDistribution() {
    }

    public DiscreteDistribution(double[] obs, double[] prob, int n) {
        this.init(n, obs, prob);
    }

    @Deprecated
    public DiscreteDistribution(int n, double[] obs, double[] prob) {
        this.init(n, obs, prob);
    }

    public DiscreteDistribution(double[] params) {
        if ((double)params.length != 1.0 + params[0] * 2.0) {
            throw new IllegalArgumentException("Wrong parameter size");
        }
        int n = (int)params[0];
        double[] obs = new double[n];
        double[] prob = new double[n];
        System.arraycopy(params, 1, obs, 0, n);
        System.arraycopy(params, n + 1, prob, 0, n);
        this.init(n, obs, prob);
    }

    private void init(int n, double[] obs, double[] prob) {
        int no = obs.length;
        int np = prob.length;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (no < n - 1 || np < n - 1) {
            throw new IllegalArgumentException("Size of arrays 'obs' or 'prob' less than 'n'");
        }
        this.nObs = n;
        this.obs = obs;
        this.pr = prob;
        this.sortedObs = new double[this.nObs];
        System.arraycopy(obs, 0, this.sortedObs, 0, this.nObs);
        this.cdf = new double[this.nObs];
        this.cdf[0] = this.pr[0];
        this.cdf[this.nObs - 1] = this.pr[this.nObs - 1];
        this.xmin = 0;
        this.xmax = this.nObs - 1;
        int i = 0;
        while (i < this.xmax && this.cdf[i] < 0.5) {
            this.cdf[++i] = this.pr[i] + this.cdf[i - 1];
        }
        this.xmed = i;
        for (i = this.nObs - 2; i > this.xmed; --i) {
            this.cdf[i] = this.pr[i] + this.cdf[i + 1];
        }
    }

    public double prob(int k) {
        return this.pr[k];
    }

    public double cdf(double x) {
        if (x < this.sortedObs[0]) {
            return 0.0;
        }
        if (x >= this.sortedObs[this.nObs - 1]) {
            return 1.0;
        }
        if (this.xmax == this.xmed || x < this.sortedObs[this.xmed + 1]) {
            for (int i = 0; i <= this.xmed; ++i) {
                if (!(x >= this.sortedObs[i]) || !(x < this.sortedObs[i + 1])) continue;
                return this.cdf[i];
            }
        } else {
            for (int i = this.xmed + 1; i < this.nObs - 1; ++i) {
                if (!(x >= this.sortedObs[i]) || !(x < this.sortedObs[i + 1])) continue;
                return 1.0 - this.cdf[i + 1];
            }
        }
        throw new IllegalStateException();
    }

    public double barF(double x) {
        if (x <= this.sortedObs[0]) {
            return 1.0;
        }
        if (x > this.sortedObs[this.nObs - 1]) {
            return 0.0;
        }
        if (this.xmax == this.xmed || x <= this.sortedObs[this.xmed + 1]) {
            for (int i = 0; i <= this.xmed; ++i) {
                if (!(x > this.sortedObs[i]) || !(x <= this.sortedObs[i + 1])) continue;
                return 1.0 - this.cdf[i];
            }
        } else {
            for (int i = this.xmed + 1; i < this.nObs - 1; ++i) {
                if (!(x > this.sortedObs[i]) || !(x <= this.sortedObs[i + 1])) continue;
                return this.cdf[i + 1];
            }
        }
        throw new IllegalStateException();
    }

    public double inverseF(double u) {
        int i;
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (u <= 0.0) {
            return this.supportA;
        }
        if (u >= 1.0) {
            return this.supportB;
        }
        if (u <= this.cdf[this.xmed - this.xmin]) {
            if (u <= this.cdf[0]) {
                return this.sortedObs[this.xmin];
            }
            i = 0;
            int j = this.xmed - this.xmin;
            while (i < j) {
                int k = (i + j) / 2;
                if (u > this.cdf[k]) {
                    i = k + 1;
                    continue;
                }
                j = k;
            }
        } else {
            if ((u = 1.0 - u) < this.cdf[this.xmax - this.xmin]) {
                return this.sortedObs[this.xmax];
            }
            i = this.xmed - this.xmin + 1;
            int j = this.xmax - this.xmin;
            while (i < j) {
                int k = (i + j) / 2;
                if (u < this.cdf[k]) {
                    i = k + 1;
                    continue;
                }
                j = k;
            }
            --i;
        }
        return this.sortedObs[i + this.xmin];
    }

    public double getMean() {
        double mean = 0.0;
        for (int i = 0; i < this.nObs; ++i) {
            mean += this.obs[i] * this.pr[i];
        }
        return mean;
    }

    public double getVariance() {
        double variance = 0.0;
        double mean = this.getMean();
        for (int i = 0; i < this.nObs; ++i) {
            variance += (this.obs[i] - mean) * (this.obs[i] - mean) * this.pr[i];
        }
        return variance / (double)this.nObs;
    }

    public double getStandardDeviation() {
        return Math.sqrt(this.getVariance());
    }

    public double[] getParams() {
        double[] retour = new double[1 + this.nObs * 2];
        double sum = 0.0;
        retour[0] = this.nObs;
        System.arraycopy(this.obs, 0, retour, 1, this.nObs);
        for (int i = 0; i < this.nObs - 1; ++i) {
            retour[this.nObs + 1 + i] = this.cdf[i] - sum;
            sum = this.cdf[i];
        }
        retour[2 * this.nObs] = 1.0 - sum;
        return retour;
    }

    public String toString() {
        int i;
        System.out.println(this.cdf + " : " + this.obs);
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        formatter.format("%s%n", this.getClass().getName());
        formatter.format("%s :  %s%n", "value", "cdf");
        for (i = 0; i < this.nObs - 1; ++i) {
            formatter.format("%f : %f%n", this.obs[i], this.cdf[i]);
        }
        formatter.format("%f : %f%n", this.obs[i], 1.0);
        return sb.toString();
    }
}

