/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.SeekableStream;

public class BBZoomLevelHeader {
    private static Logger log = Logger.getLogger(BBZoomLevelHeader.class);
    public static final int ZOOM_LEVEL_HEADER_SIZE = 24;
    private SeekableStream fis;
    private long zoomLevelHeaderOffset;
    int zoomLevel;
    private int reductionLevel;
    private int reserved;
    private long dataOffset;
    private long indexOffset;

    public BBZoomLevelHeader(SeekableStream seekableStream, long l, int n, boolean bl) {
        this.fis = seekableStream;
        this.zoomLevelHeaderOffset = l;
        this.zoomLevel = n;
        this.readZoomLevelHeader(this.zoomLevelHeaderOffset, this.zoomLevel, bl);
    }

    public BBZoomLevelHeader(int n, int n2, int n3, long l, long l2) {
        this.zoomLevel = n;
        this.reductionLevel = n2;
        this.reserved = n3;
        this.dataOffset = l;
        this.indexOffset = l2;
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public int getReductionLevel() {
        return this.reductionLevel;
    }

    public int getReserved() {
        return this.reserved;
    }

    public long getDataOffset() {
        return this.dataOffset;
    }

    public long getIndexOffset() {
        return this.indexOffset;
    }

    public void print() {
        System.out.println("Zoom level " + this.zoomLevel + " header Table D: ");
        System.out.println("Number of zoom level bases = " + this.reductionLevel);
        System.out.println("Reserved = " + this.reserved);
        System.out.println("Zoom data offset = " + this.dataOffset);
        System.out.println("Zoom index offset = " + this.indexOffset);
    }

    private void readZoomLevelHeader(long l, int n, boolean bl) {
        LittleEndianInputStream littleEndianInputStream = null;
        DataInputStream dataInputStream = null;
        byte[] byArray = new byte[24];
        try {
            this.fis.seek(l);
            this.fis.readFully(byArray);
            if (bl) {
                littleEndianInputStream = new LittleEndianInputStream(new ByteArrayInputStream(byArray));
            } else {
                dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            }
            if (bl) {
                this.reductionLevel = littleEndianInputStream.readInt();
                this.reserved = littleEndianInputStream.readInt();
                this.dataOffset = littleEndianInputStream.readLong();
                this.indexOffset = littleEndianInputStream.readLong();
            } else {
                this.reductionLevel = dataInputStream.readInt();
                this.reserved = dataInputStream.readInt();
                this.dataOffset = dataInputStream.readLong();
                this.indexOffset = dataInputStream.readLong();
            }
        }
        catch (IOException iOException) {
            log.error((Object)("Error reading zoom level header: " + n), (Throwable)iOException);
            throw new RuntimeException("Error reading zoom header " + n, iOException);
        }
    }
}

