/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BPTree;
import org.broad.igv.bbfile.BedFeature;
import org.broad.igv.bbfile.BigBedDataBlock;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTree;
import org.broad.igv.bbfile.RPTreeLeafNodeItem;
import org.broad.tribble.util.SeekableStream;

public class BigBedIterator
implements Iterator<BedFeature> {
    private static Logger log = Logger.getLogger(BigBedIterator.class);
    private RPChromosomeRegion selectionRegion;
    private boolean contained;
    private RPChromosomeRegion hitRegion;
    private SeekableStream fis;
    private BPTree chromIDTree;
    private RPTree chromDataTree;
    private ArrayList<RPTreeLeafNodeItem> leafHitList;
    private HashMap<Integer, String> chromosomeMap;
    private int leafItemIndex;
    RPTreeLeafNodeItem leafHitItem;
    private BigBedDataBlock bedDataBlock;
    private boolean dataBlockRead;
    private ArrayList<BedFeature> bedFeatureList;
    private int bedFeatureIndex;
    private boolean empty = false;

    public BigBedIterator(SeekableStream seekableStream, BPTree bPTree, RPTree rPTree, RPChromosomeRegion rPChromosomeRegion, boolean bl) {
        if (rPChromosomeRegion == null) {
            throw new RuntimeException("Error: BigBedIterator selection region is null\n");
        }
        this.fis = seekableStream;
        this.chromIDTree = bPTree;
        this.chromDataTree = rPTree;
        this.selectionRegion = rPChromosomeRegion;
        this.contained = bl;
        int n = this.getHitRegion(rPChromosomeRegion, bl);
        if (n == 0) {
            this.empty = true;
        }
    }

    public BigBedIterator() {
        this.empty = true;
    }

    @Override
    public boolean hasNext() {
        if (this.empty) {
            return false;
        }
        if (this.bedFeatureIndex < this.bedFeatureList.size()) {
            return true;
        }
        return this.leafItemIndex < this.leafHitList.size();
    }

    @Override
    public BedFeature next() {
        if (this.bedFeatureIndex < this.bedFeatureList.size()) {
            return this.bedFeatureList.get(this.bedFeatureIndex++);
        }
        int n = this.getHitRegion(this.selectionRegion, this.contained);
        if (n > 0) {
            return this.bedFeatureList.get(this.bedFeatureIndex++);
        }
        String string = String.format("Failed to find data for bed region (%d,%d,%d,%d)\n", this.hitRegion.getStartChromID(), this.hitRegion.getStartBase(), this.hitRegion.getEndChromID(), this.hitRegion.getEndBase());
        log.error((Object)string);
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove iterator item is not supported yet.");
    }

    public RPChromosomeRegion getSelectionRegion() {
        return this.selectionRegion;
    }

    public int setSelectionRegion(RPChromosomeRegion rPChromosomeRegion, boolean bl) {
        this.selectionRegion = rPChromosomeRegion;
        this.contained = bl;
        this.leafHitList = null;
        int n = this.getHitRegion(rPChromosomeRegion, bl);
        if (n == 0) {
            throw new RuntimeException("No wig data found in the selection region");
        }
        return n;
    }

    public boolean isContained() {
        return this.contained;
    }

    public SeekableStream getBBFis() {
        return this.fis;
    }

    public BPTree getChromosomeIDTree() {
        return this.chromIDTree;
    }

    public RPTree getChromosomeDataTree() {
        return this.chromDataTree;
    }

    public ArrayList<RPTreeLeafNodeItem> getLeafItems() {
        return this.leafHitList;
    }

    private int getHitRegion(RPChromosomeRegion rPChromosomeRegion, boolean bl) {
        int n = 0;
        if (this.leafHitList == null ? (n = this.getHitList(rPChromosomeRegion, bl)) == 0 : (n = this.leafHitList.size() - this.leafItemIndex) == 0) {
            return 0;
        }
        this.dataBlockRead = this.getDataBlock(this.leafItemIndex++);
        if (!this.dataBlockRead) {
            n = this.getHitRegion(rPChromosomeRegion, bl);
        }
        return n;
    }

    private int getHitList(RPChromosomeRegion rPChromosomeRegion, boolean bl) {
        this.leafHitList = this.chromDataTree.getChromosomeDataHits(rPChromosomeRegion, bl);
        int n = this.leafHitList.size();
        if (n == 0) {
            return 0;
        }
        this.leafItemIndex = 0;
        int n2 = this.leafHitList.get(0).getChromosomeBounds().getStartChromID();
        int n3 = this.leafHitList.get(0).getChromosomeBounds().getStartBase();
        int n4 = this.leafHitList.get(n - 1).getChromosomeBounds().getEndChromID();
        int n5 = this.leafHitList.get(n - 1).getChromosomeBounds().getEndBase();
        this.hitRegion = new RPChromosomeRegion(n2, n3, n4, n5);
        return n;
    }

    private boolean getDataBlock(int n) {
        if (n >= this.leafHitList.size()) {
            return false;
        }
        this.leafHitItem = this.leafHitList.get(n);
        int n2 = this.leafHitItem.getChromosomeBounds().getStartChromID();
        int n3 = this.leafHitItem.getChromosomeBounds().getEndChromID();
        this.chromosomeMap = this.chromIDTree.getChromosomeIDMap(n2, n3);
        boolean bl = this.chromDataTree.isIsLowToHigh();
        int n4 = this.chromDataTree.getUncompressBuffSize();
        this.bedDataBlock = new BigBedDataBlock(this.fis, this.leafHitItem, this.chromosomeMap, bl, n4);
        this.bedFeatureList = this.bedDataBlock.getBedData(this.selectionRegion, this.contained);
        this.bedFeatureIndex = 0;
        return this.bedFeatureList.size() > 0;
    }
}

