/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.SeekableStream;

public class RPTreeHeader {
    private static Logger log = Logger.getLogger(RPTreeHeader.class);
    public final int RPTREE_HEADER_SIZE = 48;
    public final int RPTREE_MAGIC_LTH = 610839776;
    public final int RPTREE_MAGIC_HTL = -525572060;
    private long rpTreeOffset;
    private boolean headerOK;
    private int magic;
    private int blockSize;
    private long itemCount;
    private int startChromID;
    private int startBase;
    private int endChromID;
    private int endBase;
    private long endFileOffset;
    private int itemsPerSlot;
    private long reserved;

    public RPTreeHeader(SeekableStream seekableStream, long l, boolean bl) {
        this.rpTreeOffset = l;
        this.headerOK = this.readHeader(seekableStream, this.rpTreeOffset, bl);
    }

    public boolean isHeaderOK() {
        return this.headerOK;
    }

    public int getHeaderSize() {
        return 48;
    }

    public long getTreeOffset() {
        return this.rpTreeOffset;
    }

    public int getMagic() {
        return this.magic;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public long getItemCount() {
        return this.itemCount;
    }

    public int getStartChromID() {
        return this.startChromID;
    }

    public int getStartBase() {
        return this.startBase;
    }

    public int getEndChromID() {
        return this.endChromID;
    }

    public int getEndBase() {
        return this.endBase;
    }

    public long getMEndFileOffset() {
        return this.endFileOffset;
    }

    public int getItemsPerSlot() {
        return this.itemsPerSlot;
    }

    public long getReserved() {
        return this.reserved;
    }

    public void print() {
        if (!this.headerOK) {
            log.debug((Object)("R+ Tree header is unrecognized type, header magic = " + this.magic));
            return;
        }
        log.debug((Object)"R+ tree header has 48 bytes.");
        log.debug((Object)("R+ tree header magic = " + this.magic));
        log.debug((Object)("R+ Tree file offset = " + this.rpTreeOffset));
        log.debug((Object)("magic = " + this.magic));
        log.debug((Object)("Block size = " + this.blockSize));
        log.debug((Object)("ItemCount = " + this.itemCount));
        log.debug((Object)("StartChromID = " + this.startChromID));
        log.debug((Object)("StartBase = " + this.startBase));
        log.debug((Object)("EndChromID = " + this.endChromID));
        log.debug((Object)("EndBase = " + this.endBase));
        log.debug((Object)("EndFileOffset = " + this.endFileOffset));
        log.debug((Object)("ItemsPerSlot = " + this.itemsPerSlot));
        log.debug((Object)("Reserved = " + this.reserved));
    }

    private boolean readHeader(SeekableStream seekableStream, long l, boolean bl) {
        byte[] byArray = new byte[48];
        try {
            seekableStream.seek(l);
            seekableStream.readFully(byArray);
            if (bl) {
                LittleEndianInputStream littleEndianInputStream = new LittleEndianInputStream(new ByteArrayInputStream(byArray));
                this.magic = littleEndianInputStream.readInt();
                if (this.magic != 610839776) {
                    return false;
                }
                this.blockSize = littleEndianInputStream.readInt();
                this.itemCount = littleEndianInputStream.readLong();
                this.startChromID = littleEndianInputStream.readInt();
                this.startBase = littleEndianInputStream.readInt();
                this.endChromID = littleEndianInputStream.readInt();
                this.endBase = littleEndianInputStream.readInt();
                this.endFileOffset = littleEndianInputStream.readLong();
                this.itemsPerSlot = littleEndianInputStream.readInt();
                this.reserved = littleEndianInputStream.readInt();
            } else {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                this.magic = dataInputStream.readInt();
                if (this.magic != -525572060) {
                    return false;
                }
                this.blockSize = dataInputStream.readInt();
                this.itemCount = dataInputStream.readLong();
                this.startChromID = dataInputStream.readInt();
                this.startBase = dataInputStream.readInt();
                this.endChromID = dataInputStream.readInt();
                this.endBase = dataInputStream.readInt();
                this.endFileOffset = dataInputStream.readLong();
                this.itemsPerSlot = dataInputStream.readInt();
                this.reserved = dataInputStream.readInt();
            }
        }
        catch (IOException iOException) {
            log.error((Object)("Error reading R+ tree header " + iOException));
            throw new RuntimeException("Error reading R+ tree header ", iOException);
        }
        return true;
    }
}

