/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTreeLeafNodeItem;
import org.broad.igv.bbfile.RPTreeNode;
import org.broad.igv.bbfile.RPTreeNodeItem;

public class RPTreeLeafNode
implements RPTreeNode {
    private static Logger log = Logger.getLogger(RPTreeLeafNode.class);
    private RPChromosomeRegion chromosomeBounds;
    private ArrayList<RPTreeLeafNodeItem> leafItems = new ArrayList();

    public RPTreeLeafNode() {
        this.chromosomeBounds = new RPChromosomeRegion();
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public RPChromosomeRegion getChromosomeBounds() {
        return this.chromosomeBounds;
    }

    @Override
    public int compareRegions(RPChromosomeRegion rPChromosomeRegion) {
        int n = this.chromosomeBounds.compareRegions(rPChromosomeRegion);
        return n;
    }

    @Override
    public int getItemCount() {
        return this.leafItems.size();
    }

    @Override
    public RPTreeNodeItem getItem(int n) {
        if (n < 0 || n >= this.leafItems.size()) {
            return null;
        }
        return this.leafItems.get(n);
    }

    @Override
    public boolean insertItem(RPTreeNodeItem rPTreeNodeItem) {
        RPTreeLeafNodeItem rPTreeLeafNodeItem = (RPTreeLeafNodeItem)rPTreeNodeItem;
        this.leafItems.add(rPTreeLeafNodeItem);
        this.chromosomeBounds = this.chromosomeBounds == null ? new RPChromosomeRegion(rPTreeLeafNodeItem.getChromosomeBounds()) : this.chromosomeBounds.getExtremes(rPTreeLeafNodeItem.getChromosomeBounds());
        return true;
    }

    @Override
    public boolean deleteItem(int n) {
        int n2 = this.getItemCount();
        if (n < 0 || n >= n2) {
            return false;
        }
        this.leafItems.remove(n);
        return true;
    }

    @Override
    public void printItems() {
        log.debug((Object)("Leaf Node contains " + this.leafItems.size() + " items:"));
        for (int i = 0; i < this.leafItems.size(); ++i) {
            this.leafItems.get(i).print();
        }
    }
}

