/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LittleEndianInputStream
extends FilterInputStream {
    public LittleEndianInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public boolean readBoolean() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n != 0;
    }

    public byte readByte() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public int readUnsignedByte() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n;
    }

    public short readShort() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        return (short)((n2 << 24 >>> 16) + (n << 24 >>> 24));
    }

    public int readUnsignedShort() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        return (n2 << 24 >> 16) + (n << 24 >> 24);
    }

    public char readChar() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        return (char)((n2 << 24 >>> 16) + (n << 24 >>> 24));
    }

    public int readInt() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        int n3 = this.in.read();
        int n4 = this.in.read();
        if (n4 == -1) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 24 >>> 8) + (n2 << 24 >>> 16) + (n << 24 >>> 24);
    }

    public long readLong() throws IOException {
        long l = this.in.read();
        long l2 = this.in.read();
        long l3 = this.in.read();
        long l4 = this.in.read();
        long l5 = this.in.read();
        long l6 = this.in.read();
        long l7 = this.in.read();
        long l8 = this.in.read();
        if (l8 == -1L) {
            throw new EOFException();
        }
        return (l8 << 56) + (l7 << 56 >>> 8) + (l6 << 56 >>> 16) + (l5 << 56 >>> 24) + (l4 << 56 >>> 32) + (l3 << 56 >>> 40) + (l2 << 56 >>> 48) + (l << 56 >>> 56);
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public String readString() throws IOException {
        byte by;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(100);
        while ((by = (byte)this.in.read()) != 0) {
            byteArrayOutputStream.write(by);
        }
        return new String(byteArrayOutputStream.toByteArray());
    }
}

