/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.reference;

import htsjdk.samtools.reference.FastaSequenceFile;
import htsjdk.samtools.reference.IndexedFastaSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;

public class ReferenceSequenceFileFactory {
    public static final Set<String> FASTA_EXTENSIONS = new HashSet<String>(){
        {
            this.add(".fasta");
            this.add(".fasta.gz");
            this.add(".fa");
            this.add(".fa.gz");
            this.add(".fna");
            this.add(".fna.gz");
            this.add(".txt");
            this.add(".txt.gz");
        }
    };

    public static ReferenceSequenceFile getReferenceSequenceFile(File file) {
        return ReferenceSequenceFileFactory.getReferenceSequenceFile(file, true);
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(File file, boolean truncateNamesAtWhitespace) {
        return ReferenceSequenceFileFactory.getReferenceSequenceFile(file, truncateNamesAtWhitespace, true);
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(File file, boolean truncateNamesAtWhitespace, boolean preferIndexed) {
        return ReferenceSequenceFileFactory.getReferenceSequenceFile(file.toPath(), truncateNamesAtWhitespace, preferIndexed);
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(Path path) {
        return ReferenceSequenceFileFactory.getReferenceSequenceFile(path, true);
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(Path path, boolean truncateNamesAtWhitespace) {
        return ReferenceSequenceFileFactory.getReferenceSequenceFile(path, truncateNamesAtWhitespace, true);
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(Path path, boolean truncateNamesAtWhitespace, boolean preferIndexed) {
        String name = path.getFileName().toString();
        for (String ext : FASTA_EXTENSIONS) {
            if (!name.endsWith(ext)) continue;
            if (truncateNamesAtWhitespace && preferIndexed && IndexedFastaSequenceFile.canCreateIndexedFastaReader(path)) {
                try {
                    return new IndexedFastaSequenceFile(path);
                }
                catch (FileNotFoundException e) {
                    throw new IllegalStateException("Should never happen, because existence of files has been checked.", e);
                }
            }
            return new FastaSequenceFile(path, truncateNamesAtWhitespace);
        }
        throw new IllegalArgumentException("File is not a supported reference file type: " + path.toAbsolutePath());
    }
}

