/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.rng.RandomStreamFactory;
import umontreal.iro.lecuyer.rng.RandomStreamInstantiationException;

public class BasicRandomStreamFactory
implements RandomStreamFactory {
    private Class rsClass;

    public BasicRandomStreamFactory(Class rsClass) {
        this.checkRandomStreamClass(rsClass);
        this.rsClass = rsClass;
    }

    public Class getRandomStreamClass() {
        return this.rsClass;
    }

    public void setRandomStreamClass(Class rsClass) {
        this.checkRandomStreamClass(rsClass);
        this.rsClass = rsClass;
    }

    private void checkRandomStreamClass(Class rsClass) {
        if (!RandomStream.class.isAssignableFrom(rsClass)) {
            throw new IllegalArgumentException("The random class must implement the RandomStream interface");
        }
        try {
            rsClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException nme) {
            throw new IllegalArgumentException("The random stream class " + rsClass.getName() + " does not have a " + "nullary public constructor.");
        }
    }

    public RandomStream newInstance() {
        try {
            return (RandomStream)this.rsClass.newInstance();
        }
        catch (IllegalAccessException iae) {
            throw new RandomStreamInstantiationException(this, "Cannot access constructor for random stream class " + this.rsClass.getName(), iae);
        }
        catch (InstantiationException ie) {
            throw new RandomStreamInstantiationException(this, "Cannot instantiate random stream class " + this.rsClass.getName(), ie);
        }
        catch (Exception e) {
            throw new RandomStreamInstantiationException(this, "Exception while calling the nullary constructor for random stream class " + this.rsClass.getName(), e);
        }
    }

    public String toString() {
        return "Basic random stream factory constructing streams of class " + this.rsClass.getName();
    }
}

