/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.db.biosql.BioSQLFeature;
import org.biojava.bio.seq.db.biosql.BioSQLFeatureAnnotation;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceDB;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.symbol.AbstractRangeLocation;
import org.biojava.bio.symbol.FuzzyLocation;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;

class FeaturesSQL {
    private BioSQLSequenceDB seqDB;
    private HashMap rankType;

    FeaturesSQL(BioSQLSequenceDB seqDB) {
        this.seqDB = seqDB;
    }

    public void retrieveFeatures(int bioentry_id, SeqIOListener listener, Location overlappingRegion, int immediateChildrenOfParent, int featureID) throws SQLException, BioException {
        Connection conn = this.seqDB.getDataSource().getConnection();
        HashMap<Integer, StrandedFeature.Template> fmap = new HashMap<Integer, StrandedFeature.Template>();
        HashMap qmap = new HashMap();
        HashMap<Integer, ArrayList<AbstractRangeLocation>> lmap = new HashMap<Integer, ArrayList<AbstractRangeLocation>>();
        PreparedStatement get_features = null;
        if (overlappingRegion == null && immediateChildrenOfParent < 0 && featureID < 0) {
            get_features = conn.prepareStatement("select seqfeature.seqfeature_id,        seqfeature.type_term_id,        seqfeature.source_term_id   from seqfeature  where seqfeature.bioentry_id = ?");
            get_features.setInt(1, bioentry_id);
        } else if (overlappingRegion != null) {
            get_features = conn.prepareStatement("select seqfeature.seqfeature_id,        seqfeature.type_term_id,        seqfeature.source_term_id   from location, seqfeature  where seqfeature.bioentry_id = ? and        location.seqfeature_id = seqfeature.seqfeature_id and        location.end_pos >= ? and        location.start_pos <= ?  group by seqfeature.seqfeature_id, seqfeature.type_term_id, seqfeature.source_term_id");
            get_features.setInt(1, bioentry_id);
            get_features.setInt(2, overlappingRegion.getMin());
            get_features.setInt(3, overlappingRegion.getMax());
        } else if (immediateChildrenOfParent >= 0) {
            get_features = conn.prepareStatement("select seqfeature.seqfeature_id,        seqfeature.type_term_id,        seqfeature.source_term_id   from seqfeature, seqfeature_relationship  where seqfeature.seqfeature_id = seqfeature_relationship.subject_seqfeature_id and        seqfeature_relationship.object_seqfeature_id = ?");
            get_features.setInt(1, immediateChildrenOfParent);
        } else if (featureID >= 0) {
            get_features = conn.prepareStatement("select seqfeature.seqfeature_id,        seqfeature.type_term_id,        seqfeature.source_term_id,        seqfeature.bioentry_id   from seqfeature  where seqfeature.seqfeature_id = ?");
            get_features.setInt(1, featureID);
        } else {
            conn.close();
            throw new BioException("I'm afraid you can't do that!");
        }
        ResultSet rs = get_features.executeQuery();
        while (rs.next()) {
            int feature_id = rs.getInt(1);
            StrandedFeature.Template templ = new StrandedFeature.Template();
            templ.type = this.seqDB.getOntologyTerm(rs.getInt(2));
            templ.source = this.seqDB.getOntologyTerm(rs.getInt(3));
            templ.annotation = new BioSQLFeatureAnnotation(this.seqDB, feature_id);
            fmap.put(new Integer(feature_id), templ);
            if (featureID < 0 || bioentry_id >= 0) continue;
            bioentry_id = rs.getInt(4);
            listener.addSequenceProperty("_biosql_internal.bioentry_id", new Integer(bioentry_id));
        }
        rs.close();
        get_features.close();
        PreparedStatement get_annotations = null;
        if (overlappingRegion == null && immediateChildrenOfParent < 0 && featureID < 0) {
            get_annotations = conn.prepareStatement("select seqfeature_qualifier_value.seqfeature_id,        seqfeature_qualifier_value.term_id,        seqfeature_qualifier_value.value   from seqfeature, seqfeature_qualifier_value  where seqfeature_qualifier_value.seqfeature_id = seqfeature.seqfeature_id and        seqfeature.bioentry_id = ?");
            get_annotations.setInt(1, bioentry_id);
        } else if (overlappingRegion != null) {
            get_annotations = conn.prepareStatement("select seqfeature_qualifier_value.seqfeature_id,        seqfeature_qualifier_value.term_id,        seqfeature_qualifier_value.value   from seqfeature, seqfeature_qualifier_value, location  where seqfeature_qualifier_value.seqfeature_id = seqfeature.seqfeature_id and        seqfeature.bioentry_id = ? and       location.seqfeature_id = seqfeature.seqfeature_id and        location.end_pos >= ? and        location.start_pos <= ?        group by seqfeature_qualifier_value.seqfeature_id,                 seqfeature_qualifier_value.term_id,                 seqfeature_qualifier_value.value");
            get_annotations.setInt(1, bioentry_id);
            get_annotations.setInt(2, overlappingRegion.getMin());
            get_annotations.setInt(3, overlappingRegion.getMax());
        } else if (immediateChildrenOfParent >= 0) {
            get_annotations = conn.prepareStatement("select seqfeature_qualifier_value.seqfeature_id,        seqfeature_qualifier_value.term_id,        seqfeature_qualifier_value.value   from seqfeature_qualifier_value, seqfeature_relationship  where seqfeature_qualifier_value.seqfeature_id = seqfeature_relationship.subject_seqfeature_id and        seqfeature_relationship.object_seqfeature_id = ?");
            get_annotations.setInt(1, immediateChildrenOfParent);
        } else if (featureID >= 0) {
            get_annotations = conn.prepareStatement("select seqfeature_qualifier_value.seqfeature_id,        seqfeature_qualifier_value.term_id,        seqfeature_qualifier_value.value   from seqfeature_qualifier_value  where seqfeature_qualifier_value.seqfeature_id = ?");
            get_annotations.setInt(1, featureID);
        }
        rs = get_annotations.executeQuery();
        while (rs.next()) {
            Integer fid = new Integer(rs.getInt(1));
            String key = this.seqDB.getOntologyTerm(rs.getInt(2));
            String value = rs.getString(3).trim();
            Feature.Template templ = (Feature.Template)fmap.get(fid);
            try {
                ((BioSQLFeatureAnnotation)templ.annotation).initProperty(key, value);
            }
            catch (ChangeVetoException ex) {
                try {
                    conn.close();
                }
                catch (SQLException ex3) {
                    // empty catch block
                }
                throw new BioError("Couldn't modify hidden FeatureHolder");
            }
        }
        rs.close();
        get_annotations.close();
        PreparedStatement get_locations = null;
        if (overlappingRegion == null && immediateChildrenOfParent < 0 && featureID < 0) {
            get_locations = conn.prepareStatement("select location.location_id,        location.seqfeature_id,        location.start_pos,        location.end_pos,        location.strand   from seqfeature, location  where location.seqfeature_id = seqfeature.seqfeature_id and        seqfeature.bioentry_id = ?");
            get_locations.setInt(1, bioentry_id);
        } else if (overlappingRegion != null) {
            get_locations = conn.prepareStatement("select location.location_id,        location.seqfeature_id,        location.start_pos,        location.end_pos,        location.strand   from location, location as sfl2, seqfeature  where location.seqfeature_id = seqfeature.seqfeature_id and        seqfeature.bioentry_id = ? and        sfl2.seqfeature_id = seqfeature.seqfeature_id and        sfl2.end_pos >= ? and        sfl2.start_pos <= ?  group by location.location_id,           location.seqfeature_id,           location.start_pos,           location.end_pos,           location.strand");
            get_locations.setInt(1, bioentry_id);
            get_locations.setInt(2, overlappingRegion.getMin());
            get_locations.setInt(3, overlappingRegion.getMax());
        } else if (immediateChildrenOfParent >= 0) {
            get_locations = conn.prepareStatement("select location.location_id,        location.seqfeature_id,        location.start_pos,        location.end_pos,        location.strand   from location, seqfeature_relationship  where location.seqfeature_id = seqfeature_relationship.subject_seqfeature_id and        seqfeature_relationship.object_seqfeature_id = ?");
            get_locations.setInt(1, immediateChildrenOfParent);
        } else if (featureID >= 0) {
            get_locations = conn.prepareStatement("select location.location_id,        location.seqfeature_id,        location.start_pos,        location.end_pos,        location.strand   from location  where location.seqfeature_id = ?");
            get_locations.setInt(1, featureID);
        }
        rs = get_locations.executeQuery();
        while (rs.next()) {
            ArrayList<AbstractRangeLocation> ll;
            Integer lid = new Integer(rs.getInt(1));
            Integer fid = new Integer(rs.getInt(2));
            int start = rs.getInt(3);
            int end = rs.getInt(4);
            int istrand = rs.getInt(5);
            StrandedFeature.Strand strand = StrandedFeature.UNKNOWN;
            if (istrand > 0) {
                strand = StrandedFeature.POSITIVE;
            } else if (istrand < 0) {
                strand = StrandedFeature.NEGATIVE;
            }
            StrandedFeature.Template templ = (StrandedFeature.Template)fmap.get(fid);
            templ.strand = templ.strand != null && templ.strand != strand ? StrandedFeature.UNKNOWN : strand;
            AbstractRangeLocation bloc = start == end ? new PointLocation(start) : new RangeLocation(start, end);
            List locationCrap = (List)qmap.get(lid);
            if (locationCrap != null) {
                int min_start = -1;
                int min_end = -1;
                int max_start = -1;
                int max_end = -1;
                boolean unknown_start = false;
                boolean unknown_end = false;
                boolean unbounded_start = false;
                boolean unbounded_end = false;
                boolean isFuzzy = false;
                for (LocationQualifierMemento lqm : locationCrap) {
                    String qname = lqm.qualifier_name;
                    if ("min_start".equals(qname)) {
                        min_start = lqm.qualifier_int;
                        isFuzzy = true;
                    } else if ("max_start".equals(qname)) {
                        max_start = lqm.qualifier_int;
                        isFuzzy = true;
                    } else if ("min_end".equals(qname)) {
                        min_end = lqm.qualifier_int;
                        isFuzzy = true;
                    } else if ("max_end".equals(qname)) {
                        max_end = lqm.qualifier_int;
                        isFuzzy = true;
                    } else if ("start_pos_type".equals(qname) && "BEFORE".equalsIgnoreCase(lqm.qualifier_value)) {
                        unbounded_start = true;
                        isFuzzy = true;
                    }
                    if (!"end_pos_type".equals(qname) || !"AFTER".equalsIgnoreCase(lqm.qualifier_value)) continue;
                    unbounded_end = true;
                    isFuzzy = true;
                }
                if (isFuzzy) {
                    if (unknown_start) {
                        min_start = Integer.MIN_VALUE;
                        max_start = Integer.MAX_VALUE;
                    }
                    if (unbounded_start) {
                        min_start = Integer.MIN_VALUE;
                    }
                    if (unknown_end) {
                        min_end = Integer.MIN_VALUE;
                        max_end = Integer.MAX_VALUE;
                    }
                    if (unbounded_end) {
                        max_end = Integer.MAX_VALUE;
                    }
                    if (min_start == -1) {
                        min_start = bloc.getMin();
                    }
                    if (max_start == -1) {
                        max_start = bloc.getMin();
                    }
                    if (min_end == -1) {
                        min_end = bloc.getMax();
                    }
                    if (max_end == -1) {
                        max_end = bloc.getMax();
                    }
                    bloc = new FuzzyLocation(min_start, max_end, max_start, min_end, FuzzyLocation.RESOLVE_INNER);
                }
            }
            if ((ll = (ArrayList<AbstractRangeLocation>)lmap.get(fid)) == null) {
                ll = new ArrayList<AbstractRangeLocation>();
                lmap.put(fid, ll);
            }
            ll.add(bloc);
        }
        rs.close();
        get_locations.close();
        for (Map.Entry me : fmap.entrySet()) {
            Integer fid = (Integer)me.getKey();
            StrandedFeature.Template templ = (StrandedFeature.Template)me.getValue();
            List ll = (List)lmap.get(fid);
            if (ll == null) {
                templ.location = Location.empty;
                continue;
            }
            Location loc = null;
            loc = ll.size() == 1 ? (Location)ll.get(0) : LocationTools.union(ll);
            templ.location = loc;
        }
        HashSet toplevelFeatures = new HashSet(fmap.keySet());
        HashMap<Integer, ArrayList<Integer>> featureHierarchy = new HashMap<Integer, ArrayList<Integer>>();
        int specifiedParent = -1;
        if (immediateChildrenOfParent < 0 && featureID < 0) {
            PreparedStatement get_hierarchy;
            if (overlappingRegion == null) {
                get_hierarchy = conn.prepareStatement("select object_seqfeature_id, subject_seqfeature_id   from seqfeature_relationship, seqfeature  where object_seqfeature_id = seqfeature.seqfeature_id and        seqfeature.bioentry_id = ?");
                get_hierarchy.setInt(1, bioentry_id);
            } else {
                get_hierarchy = conn.prepareStatement("select object_seqfeature_id, subject_seqfeature_id   from seqfeature_relationship, seqfeature, location  where object_seqfeature_id = seqfeature.seqfeature_id and        seqfeature.bioentry_id = ? and        location.seqfeature_id = object_seqfeature_id and        location.end_pos >= ? and        location.start_pos <= ?        group by object_seqfeature_id, subject_seqfeature_id");
                get_hierarchy.setInt(1, bioentry_id);
                get_hierarchy.setInt(2, overlappingRegion.getMin());
                get_hierarchy.setInt(3, overlappingRegion.getMax());
            }
            rs = get_hierarchy.executeQuery();
            while (rs.next()) {
                Integer parent = new Integer(rs.getInt(1));
                Integer child = new Integer(rs.getInt(2));
                toplevelFeatures.remove(child);
                ArrayList<Integer> cl = (ArrayList<Integer>)featureHierarchy.get(parent);
                if (cl == null) {
                    cl = new ArrayList<Integer>();
                    featureHierarchy.put(parent, cl);
                }
                cl.add(child);
            }
            rs.close();
            get_hierarchy.close();
        } else if (immediateChildrenOfParent >= 0) {
            specifiedParent = immediateChildrenOfParent;
        } else if (featureID >= 0) {
            PreparedStatement discover_parent = conn.prepareStatement("select object_seqfeature_id   from seqfeature_relationship  where object_seqfeature_id = ?");
            discover_parent.setInt(1, featureID);
            rs = discover_parent.executeQuery();
            if (rs.next()) {
                specifiedParent = rs.getInt(1);
            }
            rs.close();
            discover_parent.close();
        }
        conn.close();
        conn = null;
        for (Integer fid : toplevelFeatures) {
            boolean childrenFetched;
            Feature.Template templ = (Feature.Template)fmap.get(fid);
            boolean bl = childrenFetched = immediateChildrenOfParent < 0;
            if (overlappingRegion != null && !overlappingRegion.contains(templ.location)) {
                childrenFetched = false;
            }
            this.fireFeatureTree(listener, fid, fmap, featureHierarchy, childrenFetched, new Integer(specifiedParent));
        }
    }

    private void fireFeatureTree(SeqIOListener listener, Integer fid, Map fmap, Map featureHierarchy, boolean childrenFetched, Integer pid) throws BioException {
        Feature.Template templ = (Feature.Template)fmap.get(fid);
        listener.startFeature(templ);
        listener.addFeatureProperty("_biosql_internal.feature_id", fid);
        listener.addFeatureProperty("_biosql_internal.parent_id", pid);
        if (childrenFetched) {
            List children = (List)featureHierarchy.get(fid);
            if (children == null) {
                listener.addFeatureProperty("_biosql_internal.hint_childfree", Boolean.TRUE);
            } else {
                for (Integer childID : children) {
                    this.fireFeatureTree(listener, childID, fmap, featureHierarchy, childrenFetched, fid);
                }
            }
        }
        listener.endFeature();
    }

    void setFeatureType(int feature_id, String type) throws SQLException {
        Connection conn = null;
        try {
            conn = this.seqDB.getDataSource().getConnection();
            conn.setAutoCommit(false);
            int seqfeature_key = this.seqDB.intern_ontology_term(conn, type);
            PreparedStatement update_key = conn.prepareStatement("update seqfeature    set type_term_id = ?  where seqfeature_id = ?");
            update_key.setInt(1, seqfeature_key);
            update_key.setInt(2, feature_id);
            update_key.executeUpdate();
            update_key.close();
            conn.commit();
            conn.close();
        }
        catch (SQLException ex) {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
                try {
                    conn.close();
                }
                catch (SQLException ex3) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    void setFeatureSource(int feature_id, String source) throws SQLException {
        Connection conn = null;
        try {
            conn = this.seqDB.getDataSource().getConnection();
            conn.setAutoCommit(false);
            int seqfeature_source = this.seqDB.intern_ontology_term(conn, source);
            PreparedStatement update_source = conn.prepareStatement("update seqfeature    set source_term_id = ?  where seqfeature_id = ?");
            update_source.setInt(1, seqfeature_source);
            update_source.setInt(2, feature_id);
            update_source.executeUpdate();
            update_source.close();
            conn.commit();
            conn.close();
        }
        catch (SQLException ex) {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
                try {
                    conn.close();
                }
                catch (SQLException ex3) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    void setFeatureLocation(int feature_id, Location location, StrandedFeature.Strand s) throws SQLException {
        Connection conn = null;
        try {
            conn = this.seqDB.getDataSource().getConnection();
            conn.setAutoCommit(false);
            PreparedStatement del_oldlocation = conn.prepareStatement("delete from location  where seqfeature_id = ?");
            del_oldlocation.setInt(1, feature_id);
            del_oldlocation.executeUpdate();
            del_oldlocation.close();
            PreparedStatement add_locationspan = conn.prepareStatement("insert into location        (seqfeature_id, start_pos, end_pos, strand, rank) values (?, ?, ?, ?, ?)");
            int strandNum = s == StrandedFeature.POSITIVE ? 1 : (s == StrandedFeature.NEGATIVE ? -1 : 0);
            int rank = 0;
            Iterator i = location.blockIterator();
            while (i.hasNext()) {
                Location bloc = (Location)i.next();
                add_locationspan.setInt(1, feature_id);
                add_locationspan.setInt(2, bloc.getMin());
                add_locationspan.setInt(3, bloc.getMax());
                add_locationspan.setInt(4, strandNum);
                add_locationspan.setInt(5, ++rank);
                add_locationspan.executeUpdate();
            }
            add_locationspan.close();
            conn.commit();
            conn.close();
        }
        catch (SQLException ex) {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
                try {
                    conn.close();
                }
                catch (SQLException ex3) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    void persistFeatures(Connection conn, int bioentry_id, FeatureHolder features) throws BioException, SQLException {
        this.persistFeatures(conn, bioentry_id, features, -1);
    }

    private void persistFeatures(Connection conn, int bioentry_id, FeatureHolder features, int parent) throws BioException, SQLException {
        if (parent < 0) {
            this.rankType = new HashMap();
        }
        Iterator fi = features.features();
        while (fi.hasNext()) {
            Feature f = (Feature)fi.next();
            int rank = 0;
            String fType = f.getType();
            if (this.rankType.containsKey(fType)) {
                rank = (Integer)this.rankType.get(fType) + 1;
                this.rankType.put(fType, new Integer(rank));
            } else {
                this.rankType.put(fType, new Integer(0));
            }
            if (f instanceof ComponentFeature) continue;
            int id = this.persistFeature(conn, bioentry_id, f, parent, rank);
            if (!this.seqDB.isHierarchySupported()) continue;
            this.persistFeatures(conn, bioentry_id, f, id);
        }
    }

    int persistFeature(Connection conn, int bioentry_id, Feature f, int parent_id, int typeRank) throws BioException, SQLException {
        StrandedFeature.Strand s;
        int id = -1;
        boolean locationWritten = false;
        if (this.seqDB.isSPASupported()) {
            if (f.getLocation().isContiguous()) {
                Location loc = f.getLocation();
                PreparedStatement add_feature = conn.prepareStatement("select create_seqfeature_onespan(?, ?, ?, ?, ?, ?)");
                add_feature.setInt(1, bioentry_id);
                add_feature.setString(2, f.getType());
                add_feature.setString(3, f.getSource());
                add_feature.setInt(4, loc.getMin());
                add_feature.setInt(5, loc.getMax());
                if (f instanceof StrandedFeature) {
                    s = ((StrandedFeature)f).getStrand();
                    if (s == StrandedFeature.POSITIVE) {
                        add_feature.setInt(6, 1);
                    } else if (s == StrandedFeature.NEGATIVE) {
                        add_feature.setInt(6, -1);
                    } else {
                        add_feature.setInt(6, 0);
                    }
                } else {
                    add_feature.setInt(6, 0);
                }
                ResultSet rs = add_feature.executeQuery();
                if (rs.next()) {
                    id = rs.getInt(1);
                }
                rs.close();
                add_feature.close();
                locationWritten = true;
            } else {
                PreparedStatement add_feature = conn.prepareStatement("select create_seqfeature(?, ?, ?)");
                add_feature.setInt(1, bioentry_id);
                add_feature.setString(2, f.getType());
                add_feature.setString(3, f.getSource());
                ResultSet rs = add_feature.executeQuery();
                if (rs.next()) {
                    id = rs.getInt(1);
                }
                rs.close();
                add_feature.close();
            }
        } else {
            int seqfeature_key = this.seqDB.intern_ontology_term(conn, f.getType());
            int seqfeature_source = this.seqDB.intern_ontology_term(conn, f.getSource());
            if (typeRank < 0) {
                PreparedStatement select_rank = conn.prepareStatement("select max(rank) from seqfeature where bioentry_id=? and type_term_id=? and source_term_id=?");
                select_rank.setInt(1, bioentry_id);
                select_rank.setInt(2, seqfeature_key);
                select_rank.setInt(3, seqfeature_source);
                ResultSet rs = select_rank.executeQuery();
                if (rs.next()) {
                    typeRank = rs.getInt(1) + 1;
                }
                rs.close();
                select_rank.close();
            }
            PreparedStatement add_feature = conn.prepareStatement("insert into seqfeature        (bioentry_id, type_term_id, source_term_id, rank) values (?, ?, ?, ?)");
            add_feature.setInt(1, bioentry_id);
            add_feature.setInt(2, seqfeature_key);
            add_feature.setInt(3, seqfeature_source);
            add_feature.setInt(4, typeRank);
            add_feature.executeUpdate();
            add_feature.close();
            id = this.seqDB.getDBHelper().getInsertID(conn, "seqfeature", "seqfeature_id");
        }
        if (!locationWritten) {
            PreparedStatement add_locationspan = conn.prepareStatement("insert into location        (seqfeature_id, start_pos, end_pos, strand, rank) values (?, ?, ?, ?, ?)");
            int strandNum = f instanceof StrandedFeature ? ((s = ((StrandedFeature)f).getStrand()) == StrandedFeature.POSITIVE ? 1 : (s == StrandedFeature.NEGATIVE ? -1 : 0)) : 0;
            int rank = 0;
            Iterator i = f.getLocation().blockIterator();
            while (i.hasNext()) {
                Location bloc = (Location)i.next();
                add_locationspan.setInt(1, id);
                add_locationspan.setInt(2, bloc.getMin());
                add_locationspan.setInt(3, bloc.getMax());
                add_locationspan.setInt(4, strandNum);
                add_locationspan.setInt(5, ++rank);
                add_locationspan.executeUpdate();
            }
            add_locationspan.close();
        }
        for (Map.Entry akv : f.getAnnotation().asMap().entrySet()) {
            this.persistProperty(conn, id, akv.getKey(), akv.getValue(), false);
        }
        if (parent_id >= 0) {
            PreparedStatement add_hierarchy = conn.prepareStatement("insert into seqfeature_relationship        (object_seqfeature_id, subject_seqfeature_id, term_id) values (?, ?, ?)");
            add_hierarchy.setInt(1, parent_id);
            add_hierarchy.setInt(2, id);
            add_hierarchy.setInt(3, this.seqDB.intern_ontology_term(conn, "contains"));
            add_hierarchy.executeUpdate();
            add_hierarchy.close();
        }
        return id;
    }

    void removeFeature(BioSQLFeature f) throws ChangeVetoException {
        Connection conn = null;
        try {
            conn = this.seqDB.getDataSource().getConnection();
            conn.setAutoCommit(false);
            this.removeFeature(conn, f);
            conn.commit();
            conn.close();
        }
        catch (SQLException ex) {
            boolean rolledback = false;
            if (conn != null) {
                try {
                    conn.rollback();
                    rolledback = true;
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
            }
            throw new BioRuntimeException("Error removing from BioSQL tables" + (rolledback ? " (rolled back successfully)" : ""), ex);
        }
    }

    private void removeFeature(Connection conn, BioSQLFeature f) throws SQLException, ChangeVetoException {
        Iterator children = f.features();
        while (children.hasNext()) {
            Feature f2 = (Feature)children.next();
            if (!(f2 instanceof BioSQLFeature)) continue;
            this.removeFeature(conn, (BioSQLFeature)f2);
        }
        int feature_id = f._getInternalID();
        PreparedStatement delete_locs = conn.prepareStatement("delete from location  where location.seqfeature_id = ?");
        delete_locs.setInt(1, feature_id);
        delete_locs.executeUpdate();
        delete_locs.close();
        PreparedStatement delete_fqv = conn.prepareStatement("delete from seqfeature_qualifier_value  where seqfeature_qualifier_value.seqfeature_id = ?");
        delete_fqv.setInt(1, feature_id);
        delete_fqv.executeUpdate();
        delete_fqv.close();
        PreparedStatement delete_rel = conn.prepareStatement("delete from seqfeature_relationship  where subject_seqfeature_id = ?");
        delete_rel.setInt(1, feature_id);
        delete_rel.executeUpdate();
        delete_rel.close();
        PreparedStatement delete_feature = conn.prepareStatement("delete from seqfeature  where seqfeature_id = ?");
        delete_feature.setInt(1, feature_id);
        delete_feature.executeUpdate();
        delete_feature.close();
    }

    void persistProperty(Connection conn, int feature_id, Object key, Object value, boolean removeFirst) throws SQLException {
        String keyString = key.toString();
        if (removeFirst) {
            int id = this.seqDB.intern_ontology_term(conn, keyString);
            PreparedStatement remove_old_value = conn.prepareStatement("delete from seqfeature_qualifier_value  where seqfeature_id = ? and term_id = ?");
            remove_old_value.setInt(1, feature_id);
            remove_old_value.setInt(2, id);
            remove_old_value.executeUpdate();
            remove_old_value.close();
        }
        if (value != null) {
            if (this.seqDB.isSPASupported()) {
                PreparedStatement insert_new = conn.prepareStatement("insert into seqfeature_qualifier_value        (seqfeature_id, term_id, rank, value) values (?, intern_ontology_term( ? ), ?, ?)");
                if (value instanceof Collection) {
                    int cnt = 0;
                    Iterator i = ((Collection)value).iterator();
                    while (i.hasNext()) {
                        insert_new.setInt(1, feature_id);
                        insert_new.setString(2, keyString);
                        insert_new.setInt(3, ++cnt);
                        insert_new.setString(4, i.next().toString());
                        insert_new.executeUpdate();
                    }
                } else {
                    insert_new.setInt(1, feature_id);
                    insert_new.setString(2, keyString);
                    insert_new.setInt(3, 1);
                    insert_new.setString(4, value.toString());
                    insert_new.executeUpdate();
                }
                insert_new.close();
            } else {
                PreparedStatement insert_new = conn.prepareStatement("insert into seqfeature_qualifier_value        (seqfeature_id, term_id, rank, value) values (?, ?, ?, ?)");
                int sfq = this.seqDB.intern_ontology_term(conn, keyString);
                if (value instanceof Collection) {
                    int cnt = 0;
                    Iterator i = ((Collection)value).iterator();
                    while (i.hasNext()) {
                        insert_new.setInt(1, feature_id);
                        insert_new.setInt(2, sfq);
                        insert_new.setInt(3, ++cnt);
                        insert_new.setString(4, i.next().toString());
                        insert_new.executeUpdate();
                    }
                } else {
                    insert_new.setInt(1, feature_id);
                    insert_new.setInt(2, sfq);
                    insert_new.setInt(3, 1);
                    insert_new.setString(4, value.toString());
                    insert_new.executeUpdate();
                }
                insert_new.close();
            }
        }
    }

    void persistFeature(Feature f, int parent_id, int bioentry_id) throws BioException {
        Connection conn = null;
        try {
            conn = this.seqDB.getDataSource().getConnection();
            conn.setAutoCommit(false);
            int f_id = this.seqDB.getFeaturesSQL().persistFeature(conn, bioentry_id, f, parent_id, -1);
            if (f instanceof BioSQLFeature) {
                ((BioSQLFeature)f)._setInternalID(f_id);
                ((BioSQLFeature)f)._setAnnotation(new BioSQLFeatureAnnotation(this.seqDB, f_id));
            }
            conn.commit();
            conn.close();
        }
        catch (SQLException ex) {
            boolean rolledback = false;
            if (conn != null) {
                try {
                    conn.rollback();
                    rolledback = true;
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
                try {
                    conn.close();
                }
                catch (SQLException ex3) {
                    // empty catch block
                }
            }
            throw new BioException("Error adding to BioSQL tables" + (rolledback ? " (rolled back successfully)" : ""), ex);
        }
    }

    private static class LocationQualifierMemento {
        public String qualifier_name;
        public String qualifier_value;
        public int qualifier_int;

        private LocationQualifierMemento() {
        }
    }
}

