/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.assessment;

import de.jstacs.classifiers.AbstractClassifier;
import de.jstacs.classifiers.ClassDimensionException;
import de.jstacs.classifiers.assessment.ClassifierAssessment;
import de.jstacs.classifiers.assessment.RepeatedHoldOutAssessParameterSet;
import de.jstacs.classifiers.performanceMeasures.NumericalPerformanceMeasureParameterSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.sequenceScores.statisticalModels.trainable.TrainableStatisticalModel;
import de.jstacs.utils.Pair;
import de.jstacs.utils.ProgressUpdater;

public class RepeatedHoldOutExperiment
extends ClassifierAssessment<RepeatedHoldOutAssessParameterSet> {
    protected RepeatedHoldOutExperiment(AbstractClassifier[] aCs, TrainableStatisticalModel[][] aMs, boolean buildClassifiersByCrossProduct, boolean checkAlphabetConsistencyAndLength) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(aCs, aMs, buildClassifiersByCrossProduct, checkAlphabetConsistencyAndLength);
    }

    public RepeatedHoldOutExperiment(AbstractClassifier ... aCs) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(aCs);
    }

    public RepeatedHoldOutExperiment(boolean buildClassifiersByCrossProduct, TrainableStatisticalModel[] ... aMs) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(buildClassifiersByCrossProduct, aMs);
    }

    public RepeatedHoldOutExperiment(AbstractClassifier[] aCs, boolean buildClassifiersByCrossProduct, TrainableStatisticalModel[] ... aMs) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(aCs, buildClassifiersByCrossProduct, aMs);
    }

    @Override
    protected void evaluateClassifier(NumericalPerformanceMeasureParameterSet mp, RepeatedHoldOutAssessParameterSet assessPS, DataSet[] s, double[][] weights, ProgressUpdater pU) throws IllegalArgumentException, Exception {
        DataSet.PartitionMethod splitMethod = assessPS.getDataSplitMethod();
        int subSeqL = assessPS.getElementLength();
        boolean exceptionIfMPNotComputable = assessPS.getExceptionIfMPNotComputable();
        int repeats = assessPS.getRepeats();
        double[] percents = assessPS.getPercents();
        if (percents.length != this.myAbstractClassifier[0].getNumberOfClasses()) {
            throw new IllegalArgumentException("Given RepeatedHoldOutAssessParameterSet contains a invalid parameter percents. Percents (double[], percentage of test-data of all given class specific data) must contain as much entries as classes the local classifers are able to distinguish.");
        }
        DataSet[][] sTrainTestClassWise = new DataSet[2][s.length];
        double[][][] weightsTrainTestClassWise = new double[2][s.length][];
        pU.setMax(repeats);
        for (int iteration = 0; iteration < repeats; ++iteration) {
            for (int classes = 0; classes < s.length; ++classes) {
                Pair<DataSet[], double[][]> temp = s[classes].partition(weights[classes], splitMethod, 1.0 - percents[classes], percents[classes]);
                sTrainTestClassWise[0][classes] = temp.getFirstElement()[0];
                weightsTrainTestClassWise[0][classes] = temp.getSecondElement()[0];
                Pair<DataSet, double[]> temp2 = temp.getFirstElement()[1].resize(temp.getSecondElement()[1], subSeqL);
                sTrainTestClassWise[1][classes] = temp2.getFirstElement();
                weightsTrainTestClassWise[1][classes] = temp2.getSecondElement();
            }
            this.train(sTrainTestClassWise[0], weightsTrainTestClassWise[0]);
            this.test(mp, exceptionIfMPNotComputable, sTrainTestClassWise[1], weightsTrainTestClassWise[1]);
            pU.setValue(iteration + 1);
            if (pU.isCancelled()) break;
        }
    }

    @Override
    public RepeatedHoldOutAssessParameterSet getAssessParameterSet() throws Exception {
        return new RepeatedHoldOutAssessParameterSet();
    }
}

