/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.CyclicSequenceAdaptor;
import de.jstacs.data.sequences.IntSequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.utils.IntList;

public class DeBruijnSequenceGenerator {
    public static CyclicSequenceAdaptor[] generate(DiscreteAlphabet alphabet, int n) throws WrongAlphabetException, WrongSequenceTypeException {
        return new CyclicSequenceAdaptor[]{DeBruijnSequenceGenerator.generate(alphabet, n, 0)};
    }

    public static CyclicSequenceAdaptor generate(DiscreteAlphabet alphabet, int n, int alphabetShift) throws WrongAlphabetException, WrongSequenceTypeException {
        int k = (int)alphabet.length();
        if (alphabetShift >= k || alphabetShift < 0) {
            throw new IllegalArgumentException("alphabet shift greater than alphabet size");
        }
        IntList seq = new IntList();
        int[] a = new int[k * n];
        DeBruijnSequenceGenerator.db(1, 1, n, k, seq, a);
        int[] seqa = seq.toArray();
        if (alphabetShift != 0) {
            for (int i = 0; i < seqa.length; ++i) {
                seqa[i] = (seqa[i] + alphabetShift) % k;
            }
        }
        return new CyclicSequenceAdaptor<int[]>(new IntSequence(new AlphabetContainer((Alphabet)alphabet), seqa), seqa.length);
    }

    private static void db(int t, int p, int n, int k, IntList seq, int[] a) {
        block3: {
            block2: {
                if (t <= n) break block2;
                if (n % p != 0) break block3;
                for (int j = 1; j < p + 1; ++j) {
                    seq.add(a[j]);
                }
                break block3;
            }
            a[t] = a[t - p];
            DeBruijnSequenceGenerator.db(t + 1, p, n, k, seq, a);
            int j = a[t - p] + 1;
            while (j < k) {
                a[t] = j++;
                DeBruijnSequenceGenerator.db(t + 1, t, n, k, seq, a);
            }
        }
    }
}

