/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.DataType;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.AbstractSelectionParameter;
import de.jstacs.parameters.GalaxyConvertible;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.RangeIterator;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.tools.ui.galaxy.GalaxyAdaptor;
import de.jstacs.utils.IntList;
import java.util.Arrays;

public class MultiSelectionParameter
extends AbstractSelectionParameter
implements RangeIterator {
    private boolean[] selected;
    private boolean[] defaultSelected;
    private int current;

    public MultiSelectionParameter(DataType datatype, String[] keys, Object[] values, String name, String comment, boolean required) throws AbstractSelectionParameter.InconsistentCollectionException, SimpleParameter.IllegalValueException, SimpleParameter.DatatypeNotValidException {
        super(datatype, keys, values, name, comment, required);
    }

    public MultiSelectionParameter(DataType datatype, String[] keys, Object[] values, String[] comments, String name, String comment, boolean required) throws AbstractSelectionParameter.InconsistentCollectionException, SimpleParameter.IllegalValueException, SimpleParameter.DatatypeNotValidException {
        super(datatype, keys, values, comments, name, comment, required);
    }

    public MultiSelectionParameter(String name, String comment, boolean required, ParameterSet ... values) {
        super(name, comment, required, values);
    }

    public MultiSelectionParameter(String name, String comment, boolean required, Class<? extends ParameterSet> ... values) {
        super(name, comment, required, values);
    }

    public MultiSelectionParameter(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    @Override
    public MultiSelectionParameter clone() throws CloneNotSupportedException {
        MultiSelectionParameter clone = (MultiSelectionParameter)super.clone();
        clone.defaultSelected = (boolean[])this.defaultSelected.clone();
        clone.selected = (boolean[])this.selected.clone();
        return clone;
    }

    public boolean setSelected(String key, boolean selected) {
        for (int i = 0; i < this.parameters.getNumberOfParameters(); ++i) {
            if (!this.parameters.getParameterAt(i).getName().equals(key)) continue;
            this.selected[i] = selected;
            return true;
        }
        return false;
    }

    public boolean isSelected(String key) {
        for (int i = 0; i < this.parameters.getNumberOfParameters(); ++i) {
            if (!this.parameters.getParameterAt(i).getName().equals(key)) continue;
            return this.selected[i];
        }
        return false;
    }

    public Object getValueFor(String key) {
        for (int i = 0; i < this.parameters.getNumberOfParameters(); ++i) {
            if (!this.parameters.getParameterAt(i).getName().equals(key)) continue;
            if (this.selected[i]) {
                return this.parameters.getParameterAt(i).getValue();
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean checkValue(Object value) {
        if (value.getClass().isArray()) {
            Object[] o = (Object[])value;
            int i = 0;
            while (i < o.length && super.checkValue(o[i])) {
            }
            return i < o.length;
        }
        return super.checkValue(value);
    }

    @Override
    public void setValue(Object value) throws SimpleParameter.IllegalValueException {
        int i;
        if (!value.getClass().isArray()) {
            value = new Object[]{value};
        }
        Object[] o = value;
        int[] idx = new int[o.length];
        for (i = 0; i < o.length && (idx[i] = this.check(o[i])) >= 0; ++i) {
        }
        if (i < o.length) {
            throw new SimpleParameter.IllegalValueException("Problem with the " + i + "-th value: " + this.errorMessage);
        }
        Arrays.fill(this.selected, false);
        for (i = 0; i < idx.length; ++i) {
            this.selected[idx[i]] = true;
            if (o[i] instanceof ParameterSetContainer) {
                this.parameters.getParameterAt(idx[i]).setValue(((ParameterSetContainer)o[i]).getValue());
                continue;
            }
            if (!(o[i] instanceof ParameterSet)) continue;
            this.parameters.getParameterAt(idx[i]).setValue(o[i]);
        }
        this.userSelected = true;
    }

    public int[] getSelected() {
        IntList li = new IntList();
        for (int i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            li.add(i);
        }
        return li.toArray();
    }

    public boolean setSelected(int idx, boolean selected) {
        if (idx < this.selected.length) {
            this.selected[idx] = selected;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSelected(int idx) {
        return idx < this.selected.length && this.selected[idx];
    }

    public Object getValueFor(int idx) {
        if (idx < this.selected.length && this.selected[idx]) {
            return this.parameters.getParameterAt(idx).getValue();
        }
        return null;
    }

    public Object[] getValues() {
        int count = 0;
        for (int i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            ++count;
        }
        Object[] values = new Object[count];
        count = 0;
        for (int i = 0; i < this.parameters.getNumberOfParameters(); ++i) {
            if (!this.selected[i]) continue;
            values[count++] = this.parameters.getParameterAt(i).getValue();
        }
        return values;
    }

    @Override
    public Object getValue() {
        if (this.current > -1) {
            return this.parameters.getParameterAt(this.current).getValue();
        }
        return null;
    }

    @Override
    public boolean hasDefaultOrIsSet() {
        int numSelected = 0;
        for (int i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            ++numSelected;
            if (this.parameters.getParameterAt(i).hasDefaultOrIsSet()) continue;
            this.errorMessage = "Parameter " + this.parameters.getParameterAt(i).getName() + " not set.";
            return false;
        }
        return numSelected >= true || !this.isRequired();
    }

    @Override
    public void reset() {
        this.selected = (boolean[])this.defaultSelected.clone();
    }

    @Override
    public void setDefault(Object defaultValue) throws SimpleParameter.IllegalValueException {
        if (this.selected == null) {
            this.selected = new boolean[this.parameters.getNumberOfParameters()];
            this.defaultSelected = (boolean[])this.selected.clone();
        }
        this.setValue(defaultValue);
        System.arraycopy(this.selected, 0, this.defaultSelected, 0, this.selected.length);
        this.userSelected = false;
    }

    public void setDefaultSelected(int[] defaultSelection) {
        Arrays.fill(this.defaultSelected, false);
        for (int i = 0; i < defaultSelection.length; ++i) {
            this.defaultSelected[defaultSelection[i]] = true;
        }
        System.arraycopy(this.defaultSelected, 0, this.selected, 0, this.selected.length);
        this.userSelected = false;
    }

    @Override
    public String getXMLTag() {
        return "MultiSelectionParameter";
    }

    @Override
    protected void appendFurtherInfos(StringBuffer sup) {
        super.appendFurtherInfos(sup);
        XMLParser.appendObjectWithTags(sup, this.selected, "selected");
        XMLParser.appendObjectWithTags(sup, this.defaultSelected, "defaultSelected");
        XMLParser.appendObjectWithTags(sup, this.current, "current");
    }

    @Override
    protected void extractFurtherInfos(StringBuffer representation) throws NonParsableException {
        super.extractFurtherInfos(representation);
        this.selected = XMLParser.extractObjectForTags(representation, "selected", boolean[].class);
        this.defaultSelected = XMLParser.extractObjectForTags(representation, "defaultSelected", boolean[].class);
        this.current = XMLParser.extractObjectForTags(representation, "current", Integer.TYPE);
    }

    @Override
    public boolean next() throws ParameterException {
        int next = -1;
        for (int i = this.current + 1; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            next = i;
            break;
        }
        if (next != -1) {
            this.current = next;
            return true;
        }
        return false;
    }

    @Override
    public void resetToFirst() {
        for (int i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            this.current = i;
            break;
        }
    }

    @Override
    public int getNumberOfValues() {
        int count = 0;
        for (int i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            ++count;
        }
        return count;
    }

    public int getNumberOfNexts(int afterIdx) {
        int count = 0;
        for (int i = afterIdx + 1; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            ++count;
        }
        return count;
    }

    @Override
    public String valuesToString() {
        StringBuffer tmp = new StringBuffer();
        for (int i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            tmp.append(this.parameters.getParameterAt(i).getName() + ", ");
        }
        tmp.delete(tmp.length() - 2, tmp.length());
        return "[" + tmp.toString() + "]";
    }

    @Override
    public boolean isRanged() {
        return this.getNumberOfValues() > 1;
    }

    @Override
    public boolean hasDefault() {
        int i;
        for (i = 0; i < this.defaultSelected.length && !this.defaultSelected[i]; ++i) {
        }
        return i < this.defaultSelected.length;
    }

    @Override
    public void fromGalaxy(String namePrefix, StringBuffer command) throws Exception {
        namePrefix = namePrefix + "_" + GalaxyAdaptor.getLegalName(this.getName());
        String selected = XMLParser.extractForTag(command, namePrefix).toString();
        this.setValue(selected);
        if (this.getValue() instanceof GalaxyConvertible) {
            ((GalaxyConvertible)this.getValue()).fromGalaxy(namePrefix + "_opt" + this.getSelected()[0], command);
        }
    }
}

