/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.results;

import de.jstacs.AnnotatedEntity;
import de.jstacs.DataType;
import de.jstacs.Storable;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.ImageResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.StorableResult;
import java.awt.image.BufferedImage;

public abstract class Result
extends AnnotatedEntity {
    private String originalName;

    protected Result(String name, String comment, DataType datatype) {
        super(name, comment, datatype);
    }

    protected Result(StringBuffer rep) throws NonParsableException {
        super(rep);
    }

    public boolean isComparableResult(Result test) {
        return this.datatype == test.datatype && this.name.equals(test.name) && this.comment.equals(test.comment);
    }

    public boolean isCastableResult(Result test) {
        return DataType.canBeCastedFromTo(test.datatype, this.datatype) && this.name.equals(test.name) && this.comment.equals(test.comment);
    }

    public static boolean checkDatatype(DataType datatype, Object value) {
        if (value instanceof String) {
            String val = (String)value;
            try {
                switch (datatype) {
                    case DOUBLE: {
                        Double.parseDouble(val);
                        break;
                    }
                    case LONG: {
                        Long.parseLong(val);
                        break;
                    }
                    case INT: {
                        Integer.parseInt(val);
                        break;
                    }
                    case STRING: {
                        break;
                    }
                    case BOOLEAN: {
                        Boolean.parseBoolean(val);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        switch (datatype) {
            case DOUBLE: {
                return value instanceof Double || value instanceof Float;
            }
            case LONG: {
                return value instanceof Long;
            }
            case INT: {
                return value instanceof Integer || value instanceof Byte || value instanceof Short;
            }
            case BOOLEAN: {
                return value instanceof Boolean;
            }
            case PNG: {
                return value instanceof BufferedImage;
            }
            case STORABLE: {
                return value instanceof Storable;
            }
        }
        return false;
    }

    public static Result createResult(String name, String comment, DataType datatype, Object value) throws SimpleParameter.IllegalValueException {
        switch (datatype) {
            case DOUBLE: 
            case LONG: 
            case INT: {
                return new NumericalResult(datatype, name, comment, (Comparable)value);
            }
            case STRING: 
            case BOOLEAN: {
                return new CategoricalResult(datatype, name, comment, (Comparable)value);
            }
            case PNG: {
                return new ImageResult(name, comment, (BufferedImage)value);
            }
            case STORABLE: {
                return new StorableResult(name, comment, (Storable)value);
            }
        }
        throw new SimpleParameter.IllegalValueException("wrong datatype");
    }

    public void rename(String newName) {
        if (this.originalName == null) {
            this.originalName = this.name;
        }
        this.name = newName;
    }

    public String getOriginalName() {
        if (this.originalName == null) {
            return this.name;
        }
        return this.originalName;
    }

    @Override
    protected void appendFurtherInfos(StringBuffer buf) {
        XMLParser.appendObjectWithTags(buf, this.originalName, "originalName");
    }

    @Override
    protected void extractFurtherInfos(StringBuffer buf) throws NonParsableException {
        this.originalName = (String)XMLParser.extractObjectForTags(buf, "originalName");
    }
}

