/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.differentiable;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.differentiable.AbstractDifferentiableSequenceScore;
import de.jstacs.sequenceScores.differentiable.DifferentiableSequenceScore;
import de.jstacs.sequenceScores.statisticalModels.differentiable.VariableLengthDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousDiffSM;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import java.text.NumberFormat;
import java.util.Arrays;

public class IndependentProductDiffSS
extends AbstractDifferentiableSequenceScore {
    protected DifferentiableSequenceScore[] score;
    protected int[] index;
    protected int[] start;
    protected int[] partialLength;
    protected boolean[] reverse;
    protected boolean[] isVariable;
    protected int[] startIndexOfParams;
    private IntList partIList;
    private boolean plugIn;

    private static final AlphabetContainer getAlphabetContainer(DifferentiableSequenceScore[] functions, int[] index, int[] length, boolean[] reverse) throws IllegalArgumentException, WrongAlphabetException {
        boolean direct = index == null;
        int len = direct ? functions.length : index.length;
        AlphabetContainer[] cons = new AlphabetContainer[len];
        int[] lengths = new int[len];
        for (int i = 0; i < len; ++i) {
            int j = direct ? i : index[i];
            cons[i] = functions[j].getAlphabetContainer();
            lengths[i] = length[i];
            if (reverse == null || !reverse[i] || cons[i].isReverseComplementable()) continue;
            throw new WrongAlphabetException("The AlpabetContainer is not reverse complementable.");
        }
        return new AlphabetContainer(cons, lengths);
    }

    private static final int sum(int[] length) throws IllegalArgumentException {
        int res = 0;
        int i = 0;
        while (i < length.length && length[i] > 0) {
            res += length[i++];
        }
        if (i != length.length) {
            throw new IllegalArgumentException("The length with index " + i + " is 0.");
        }
        return res;
    }

    protected static final int[] getLengthArray(DifferentiableSequenceScore ... function) throws IllegalArgumentException {
        int i;
        int[] res = new int[function.length];
        for (i = 0; i < function.length && function[i].getLength() > 0; ++i) {
            res[i] = function[i].getLength();
        }
        if (i != function.length) {
            throw new IllegalArgumentException("The DifferentiableSequenceScore with index " + i + " has a length 0.");
        }
        return res;
    }

    public IndependentProductDiffSS(boolean plugIn, DifferentiableSequenceScore ... functions) throws CloneNotSupportedException, WrongAlphabetException {
        this(plugIn, functions, IndependentProductDiffSS.getLengthArray(functions));
    }

    public IndependentProductDiffSS(boolean plugIn, DifferentiableSequenceScore[] functions, int[] length) throws CloneNotSupportedException, WrongAlphabetException {
        this(plugIn, functions, null, length, null);
    }

    public IndependentProductDiffSS(boolean plugIn, DifferentiableSequenceScore[] functions, int[] index, int[] length, boolean[] reverse) throws CloneNotSupportedException, WrongAlphabetException {
        super(IndependentProductDiffSS.getAlphabetContainer(functions, index, length, reverse), IndependentProductDiffSS.sum(length));
        this.plugIn = plugIn;
        this.score = (DifferentiableSequenceScore[])ArrayHandler.clone((Cloneable[])functions);
        this.set(index, length, reverse);
        this.setParamsStarts();
    }

    public IndependentProductDiffSS(StringBuffer source) throws NonParsableException {
        super(source);
    }

    private void set(int[] index, int[] length, boolean[] reverse) throws IllegalArgumentException {
        int i;
        int[] used = new int[this.score.length];
        boolean direct = index == null;
        int oldStart = 0;
        int len = direct ? this.score.length : index.length;
        this.start = new int[len];
        this.partialLength = new int[len];
        this.isVariable = new boolean[this.score.length];
        this.index = new int[len];
        this.reverse = new boolean[len];
        for (i = 0; i < len; ++i) {
            if (direct) {
                this.index[i] = i;
            } else if (0 <= index[i] && index[i] < this.score.length) {
                this.index[i] = index[i];
            } else {
                throw new IndexOutOfBoundsException("index " + index[i]);
            }
            int n = this.index[i];
            used[n] = used[n] + 1;
            this.reverse[i] = reverse == null ? false : reverse[i];
            this.start[i] = oldStart;
            this.partialLength[i] = length[i];
            this.isVariable[this.index[i]] = this.score[this.index[i]] instanceof VariableLengthDiffSM;
            if (!this.isVariable[this.index[i]] && this.score[this.index[i]].getLength() != this.partialLength[i]) {
                throw new IllegalArgumentException("Could not use length " + this.partialLength[i] + " at part " + i + " for DifferentiableSequenceScore with index " + this.index[i] + ".");
            }
            oldStart += this.partialLength[i];
        }
        for (i = 0; i < used.length; ++i) {
            if (used[i] != 0) continue;
            throw new IllegalArgumentException("The DifferentiableSequenceScore with index " + i + " is never used.");
        }
        this.partIList = new IntList();
    }

    protected void setParamsStarts() {
        if (this.startIndexOfParams == null) {
            this.startIndexOfParams = new int[this.score.length + 1];
        }
        for (int i = 0; i < this.score.length; ++i) {
            int n = this.score[i].getNumberOfParameters();
            if (n == -1) {
                this.startIndexOfParams = null;
                break;
            }
            this.startIndexOfParams[i + 1] = this.startIndexOfParams[i] + n;
        }
    }

    @Override
    public IndependentProductDiffSS clone() throws CloneNotSupportedException {
        IndependentProductDiffSS clone = (IndependentProductDiffSS)super.clone();
        clone.score = (DifferentiableSequenceScore[])ArrayHandler.clone((Cloneable[])this.score);
        clone.set(this.index, this.partialLength, this.reverse);
        clone.startIndexOfParams = null;
        clone.setParamsStarts();
        return clone;
    }

    @Override
    public void initializeFunction(int index, boolean freeParams, DataSet[] data, double[][] weights) throws Exception {
        DataSet[] part = new DataSet[data.length];
        for (int i = 0; i < this.score.length; ++i) {
            if (!this.plugIn && this.score[i] instanceof HomogeneousDiffSM) continue;
            int a = this.extractSequenceParts(i, data, part);
            double[][] help = a == 1 ? weights : this.extractWeights(a, weights);
            this.score[i].initializeFunction(index, freeParams, part, help);
        }
        this.setParamsStarts();
    }

    public int extractSequenceParts(int scoringFunctionIndex, DataSet[] data, DataSet[] result) throws Exception {
        Arrays.fill(result, null);
        int used = 0;
        for (int k = 0; k < this.index.length; ++k) {
            if (this.index[k] != scoringFunctionIndex) continue;
            ++used;
            for (int j = 0; j < data.length; ++j) {
                if (data[j] == null) continue;
                DataSet current = data[j].getInfixDataSet(this.start[k], this.partialLength[k]);
                if (this.reverse[k]) {
                    Sequence[] seq = new Sequence[current.getNumberOfElements()];
                    for (int n = 0; n < seq.length; ++n) {
                        seq[n] = current.getElementAt(n).reverseComplement();
                    }
                    current = new DataSet("reverse complement of \"" + current.getAnnotation() + "\"", seq);
                }
                result[j] = result[j] == null ? current : DataSet.union(result[j], current);
            }
        }
        return used;
    }

    public double[][] extractWeights(int number, double[][] weights) {
        Object res;
        if (number == 1 || weights == null) {
            res = weights;
        } else {
            res = new double[weights.length][];
            for (int k = 0; k < ((double[][])res).length; ++k) {
                int n = weights[k].length;
                res[k] = new double[number * n];
                for (int j = 0; j < number; ++j) {
                    System.arraycopy(weights[k], 0, res[k], j * n, n);
                }
            }
        }
        return res;
    }

    @Override
    protected void fromXML(StringBuffer rep) throws NonParsableException {
        StringBuffer xml = XMLParser.extractForTag(rep, this.getInstanceName());
        this.alphabets = (AlphabetContainer)XMLParser.extractObjectForTags(xml, "AlphabetContainer");
        this.length = XMLParser.extractObjectForTags(xml, "length", Integer.TYPE);
        this.score = XMLParser.extractObjectForTags(xml, "DifferentiableSequenceScores", DifferentiableSequenceScore[].class);
        this.set(XMLParser.extractObjectForTags(xml, "index", int[].class), XMLParser.extractObjectForTags(xml, "partialLength", int[].class), XMLParser.extractObjectForTags(xml, "reverse", boolean[].class));
        try {
            this.plugIn = XMLParser.extractObjectForTags(xml, "plugIn", Boolean.TYPE);
        }
        catch (Exception e) {
            this.plugIn = true;
        }
        this.extractFurtherInformation(xml);
        this.setParamsStarts();
    }

    protected StringBuffer getFurtherInformation() {
        return new StringBuffer(1);
    }

    protected void extractFurtherInformation(StringBuffer xml) throws NonParsableException {
    }

    @Override
    public String getInstanceName() {
        return this.getClass().getSimpleName();
    }

    public DifferentiableSequenceScore[] getFunctions() throws Exception {
        return (DifferentiableSequenceScore[])ArrayHandler.clone((Cloneable[])this.score);
    }

    public int[] getIndices() {
        return (int[])this.index.clone();
    }

    public int[] getPartialLengths() {
        return (int[])this.partialLength.clone();
    }

    public boolean[] getReverseSwitches() {
        return (boolean[])this.reverse.clone();
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        int numPars = this.getNumberOfParameters();
        double[] pars = new double[numPars];
        int k = 0;
        for (int i = 0; i < this.score.length; ++i) {
            double[] help = this.score[i].getCurrentParameterValues();
            System.arraycopy(help, 0, pars, k, help.length);
            k += help.length;
        }
        return pars;
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start) {
        double s = 0.0;
        for (int i = 0; i < this.index.length; ++i) {
            Sequence help;
            int myStart;
            if (this.reverse[i]) {
                try {
                    myStart = seq.getLength() - start - this.start[i] - this.partialLength[i];
                    help = seq.reverseComplement();
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            } else {
                help = seq;
                myStart = start + this.start[i];
            }
            if (this.isVariable[this.index[i]]) {
                s += ((VariableLengthDiffSM)this.score[this.index[i]]).getLogScoreFor(seq, myStart, myStart + this.partialLength[i] - 1);
                continue;
            }
            s += this.score[this.index[i]].getLogScoreFor(seq, myStart);
        }
        return s;
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        double s = 0.0;
        for (int i = 0; i < this.index.length; ++i) {
            Sequence help;
            int myStart;
            this.partIList.clear();
            if (this.reverse[i]) {
                try {
                    myStart = seq.getLength() - start - this.start[i] - this.partialLength[i];
                    help = seq.reverseComplement();
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            } else {
                help = seq;
                myStart = start + this.start[i];
            }
            s = this.isVariable[this.index[i]] ? (s += ((VariableLengthDiffSM)this.score[this.index[i]]).getLogScoreAndPartialDerivation(help, myStart, myStart + this.partialLength[i] - 1, this.partIList, partialDer)) : (s += this.score[this.index[i]].getLogScoreAndPartialDerivation(help, myStart, this.partIList, partialDer));
            for (int j = 0; j < this.partIList.length(); ++j) {
                indices.add(this.partIList.get(j) + this.startIndexOfParams[this.index[i]]);
            }
        }
        return s;
    }

    @Override
    public int getNumberOfParameters() {
        if (this.startIndexOfParams == null) {
            return -1;
        }
        return this.startIndexOfParams[this.score.length];
    }

    @Override
    public int getNumberOfRecommendedStarts() {
        int max = this.score[0].getNumberOfRecommendedStarts();
        for (int i = 1; i < this.score.length; ++i) {
            max = Math.max(max, this.score[i].getNumberOfRecommendedStarts());
        }
        return max;
    }

    @Override
    public void setParameters(double[] params, int start) {
        for (int i = 0; i < this.score.length; ++i) {
            this.score[i].setParameters(params, start + this.startIndexOfParams[i]);
        }
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer(10000);
        XMLParser.appendObjectWithTags(xml, this.alphabets, "AlphabetContainer");
        XMLParser.appendObjectWithTags(xml, this.length, "length");
        XMLParser.appendObjectWithTags(xml, this.score, "DifferentiableSequenceScores");
        XMLParser.appendObjectWithTags(xml, this.index, "index");
        XMLParser.appendObjectWithTags(xml, this.partialLength, "partialLength");
        XMLParser.appendObjectWithTags(xml, this.reverse, "reverse");
        XMLParser.appendObjectWithTags(xml, this.plugIn, "plugIn");
        xml.append(this.getFurtherInformation());
        XMLParser.addTags(xml, this.getInstanceName());
        return xml;
    }

    @Override
    public String toString(NumberFormat nf) {
        int i;
        StringBuffer sb = new StringBuffer(100000);
        for (i = 0; i < this.score.length; ++i) {
            sb.append("DifferentiableSequenceScore " + i + ": " + this.score[i].getInstanceName() + "\n");
            sb.append(this.score[i].toString(nf) + "\n");
        }
        sb.append("digraph {\n\trankdir=LR\n");
        sb.append("\tn0[shape=house, orientation=" + (this.reverse[0] ? 90 : -90) + ", label=\"emission: " + this.index[0] + "\\nduration: " + this.partialLength[0] + "\"]\n");
        for (i = 1; i < this.index.length; ++i) {
            sb.append("\tn" + i + "[shape=house, orientation=" + (this.reverse[i] ? 90 : -90) + ", label=\"emission: " + this.index[i] + "\\nduration: " + this.partialLength[i] + "\"]\n");
            sb.append("\tn" + (i - 1) + "->n" + i + "\n");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean isInitialized() {
        int i;
        for (i = 0; i < this.score.length && this.score[i].isInitialized(); ++i) {
        }
        return i == this.score.length;
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        for (int i = 0; i < this.score.length; ++i) {
            this.score[i].initializeFunctionRandomly(freeParams);
        }
        this.setParamsStarts();
    }
}

