/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.gff;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Comparator;
import org.biojava.bio.program.gff.GFFRecord;
import org.biojava.bio.program.gff.GFFWriter;

class GFFComparator
implements Comparator {
    GFFComparator() {
    }

    public int compare(Object o1, Object o2) {
        GFFRecord r1 = (GFFRecord)o1;
        GFFRecord r2 = (GFFRecord)o2;
        int dif = r1.getSeqName().compareTo(r2.getSeqName());
        if (dif != 0) {
            return dif;
        }
        dif = r1.getStart() - r2.getStart();
        if (dif != 0) {
            return dif;
        }
        dif = r1.getEnd() - r2.getEnd();
        if (dif != 0) {
            return dif;
        }
        dif = r1.getFeature().compareTo(r2.getFeature());
        if (dif != 0) {
            return dif;
        }
        dif = r1.getSource().compareTo(r2.getSource());
        if (dif != 0) {
            return dif;
        }
        return this.stringify(r1).compareTo(this.stringify(r2));
    }

    private String stringify(GFFRecord r) {
        StringWriter sw = new StringWriter();
        GFFWriter gffw = new GFFWriter(new PrintWriter(sw));
        gffw.recordLine(r);
        gffw.endDocument();
        return sw.toString();
    }
}

