/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.differentiableSequenceScoreBased.sampling;

import de.jstacs.DataType;
import de.jstacs.classifiers.differentiableSequenceScoreBased.sampling.SamplingScoreBasedClassifier;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.parameters.EnumParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SequenceScoringParameterSet;
import de.jstacs.parameters.SimpleParameter;

public abstract class SamplingScoreBasedClassifierParameterSet
extends SequenceScoringParameterSet {
    public SamplingScoreBasedClassifierParameterSet(Class<? extends SamplingScoreBasedClassifier> instanceClass, AlphabetContainer alphabet, int length, int numStarts, SamplingScoreBasedClassifier.SamplingScheme scheme, int testSamplings, int stationarySamplings, boolean freeParameters, boolean adaptVariance, String outfilePrefix) throws Exception {
        this(instanceClass, alphabet, length, numStarts, testSamplings, stationarySamplings, outfilePrefix);
        this.getParameterAt(1).setValue((Object)scheme);
        this.getParameterAt(4).setValue(freeParameters);
        this.getParameterAt(5).setValue(adaptVariance);
    }

    public SamplingScoreBasedClassifierParameterSet(Class<? extends SamplingScoreBasedClassifier> instanceClass, AlphabetContainer alphabet, int length, int numStarts, int testSamplings, int stationarySamplings, String outfilePrefix) throws Exception {
        super(instanceClass, alphabet, length, length == 0);
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.INT, "Number of starts", "Number of parallel sampling starts", true)});
        this.parameters.add(new Parameter[]{new EnumParameter(SamplingScoreBasedClassifier.SamplingScheme.class, "The sampling scheme", true, SamplingScoreBasedClassifier.SamplingScheme.GROUPED.name())});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.INT, "Test samplings", "The number of sampling steps between to burn-in tests", true, 100)});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.INT, "Stationary samplings", "The number of sampling steps in the stationary phase", true, 1000)});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.BOOLEAN, "Free parameters", "Use only free parameters", true, false)});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.BOOLEAN, "Adapt variance", "Adapt the variance to the size of event spaces for each random variable", true, true)});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.STRING, "Outfile prefix", "The prefix of the outfiles where the parameters are stored", true)});
        this.getParameterAt(0).setValue(numStarts);
        this.getParameterAt(2).setValue(testSamplings);
        this.getParameterAt(3).setValue(stationarySamplings);
        this.getParameterAt(6).setValue(outfilePrefix);
    }

    @Override
    public SamplingScoreBasedClassifierParameterSet clone() throws CloneNotSupportedException {
        return (SamplingScoreBasedClassifierParameterSet)super.clone();
    }

    public int getNumberOfStarts() {
        return (Integer)this.getParameterAt(0).getValue();
    }

    public SamplingScoreBasedClassifier.SamplingScheme getSamplingScheme() {
        return (SamplingScoreBasedClassifier.SamplingScheme)((Object)this.getParameterAt(1).getValue());
    }

    public int getNumberOfTestSamplings() {
        return (Integer)this.getParameterAt(2).getValue();
    }

    public int getNumberOfStationarySamplings() {
        return (Integer)this.getParameterAt(3).getValue();
    }

    public boolean getFreeParameters() {
        return (Boolean)this.getParameterAt(4).getValue();
    }

    public boolean getAdaptVariance() {
        return (Boolean)this.getParameterAt(5).getValue();
    }

    public String getOutfilePrefix() {
        return (String)this.getParameterAt(6).getValue();
    }

    public void setNumberOfStarts(int i) throws SimpleParameter.IllegalValueException {
        this.getParameterAt(0).setValue(i);
    }
}

