/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.Mutable;
import de.jstacs.sequenceScores.statisticalModels.differentiable.SamplingDifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.BNDiffSMParameterTree;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.BayesianNetworkDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.InhomogeneousMarkov;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.motif.DurationDiffSM;
import java.util.ArrayList;

public class MarkovModelDiffSM
extends BayesianNetworkDiffSM
implements Mutable,
SamplingDifferentiableStatisticalModel {
    private DurationDiffSM lengthPenalty;
    private static final String XML_TAG = "MarkovModelDiffSM";

    public MarkovModelDiffSM(AlphabetContainer alphabet, int length, double ess, boolean plugInParameters, int order, DurationDiffSM lengthPenalty) throws Exception {
        this(alphabet, length, ess, plugInParameters, new InhomogeneousMarkov(order), lengthPenalty);
    }

    public MarkovModelDiffSM(AlphabetContainer alphabet, int length, double ess, boolean plugInParameters, InhomogeneousMarkov structureMeasure) throws Exception {
        super(alphabet, length, ess, plugInParameters, structureMeasure);
    }

    public MarkovModelDiffSM(AlphabetContainer alphabet, int length, double ess, boolean plugInParameters, InhomogeneousMarkov structureMeasure, DurationDiffSM lengthPenalty) throws Exception {
        this(alphabet, length, ess, plugInParameters, structureMeasure);
        this.lengthPenalty = lengthPenalty;
        if (lengthPenalty != null && !lengthPenalty.isPossible(length)) {
            throw new IllegalArgumentException("This motif length is not possible: " + length);
        }
    }

    public MarkovModelDiffSM(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    protected void fromXML(StringBuffer source) throws NonParsableException {
        StringBuffer sb = XMLParser.extractForTag(source, XML_TAG);
        this.lengthPenalty = XMLParser.extractObjectForTags(sb, "lengthPenalty", DurationDiffSM.class);
        super.fromXML(sb);
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer sb = super.toXML();
        XMLParser.appendObjectWithTags(sb, this.lengthPenalty, "lengthPenalty");
        XMLParser.addTags(sb, XML_TAG);
        return sb;
    }

    @Override
    public double getLogPriorTerm() {
        if (this.lengthPenalty != null) {
            return super.getLogPriorTerm() + this.lengthPenalty.getLogScore(this.length);
        }
        return super.getLogPriorTerm();
    }

    public int getOrder() {
        return ((InhomogeneousMarkov)this.structureMeasure).getOrder();
    }

    @Override
    public boolean modify(int offsetLeft, int offsetRight) {
        if (!this.getAlphabetContainer().isSimple()) {
            return false;
        }
        if (offsetLeft == 0 && offsetRight == 0) {
            return true;
        }
        this.precomputeNormalization();
        this.normalizeParameters();
        this.precomputeNormalization();
        BNDiffSMParameterTree[] backTrees = this.trees;
        int backLength = this.length;
        try {
            this.length = this.length - offsetLeft + offsetRight;
            if (this.lengthPenalty != null && !this.lengthPenalty.isPossible(this.length)) {
                throw new IllegalArgumentException("This motif length is not possible: " + this.length);
            }
            this.createTrees(new DataSet[]{null, null}, new double[][]{null, null});
            int indexNew = 0;
            int indexOld = 0;
            if (offsetLeft >= 0) {
                indexOld = offsetLeft;
            } else {
                indexNew = -offsetLeft;
            }
            while (indexOld < backTrees.length && indexNew < this.trees.length) {
                this.trees[indexNew].copy(backTrees[indexOld]);
                ++indexNew;
                ++indexOld;
            }
            if (indexNew < this.trees.length) {
                indexNew = this.trees.length;
            }
            this.logNormalizationConstant = null;
            return true;
        }
        catch (Exception e) {
            this.length = backLength;
            this.trees = backTrees;
            this.logNormalizationConstant = null;
            return false;
        }
    }

    public void normalizeParameters() {
        for (int i = 0; i < this.trees.length; ++i) {
            this.trees[i].normalizeParameters();
        }
        this.precomputeNormalization();
    }

    @Override
    public int[][] getSamplingGroups(int parameterOffset) {
        ArrayList<int[]> list = new ArrayList<int[]>();
        for (int i = 0; i < this.trees.length; ++i) {
            for (int j = 0; j < this.trees[i].getNumberOfSamplingSteps(); ++j) {
                list.add(this.trees[i].getParameterIndexesForSamplingStep(j, parameterOffset));
            }
            parameterOffset += this.trees[i].getNumberOfParameters();
        }
        return (int[][])list.toArray((T[])new int[0][0]);
    }
}

