/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.tools.ui.cli;

import de.jstacs.DataType;
import de.jstacs.io.FileManager;
import de.jstacs.parameters.AbstractSelectionParameter;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.MultiSelectionParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.results.savers.ResultSaver;
import de.jstacs.results.savers.ResultSaverLibrary;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolResult;
import de.jstacs.utils.Pair;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CLI {
    private String opt;
    private JstacsTool[] tools;
    private boolean[] configureThreads;
    private ParameterSet[] toolParameters;
    private HashMap<String, String>[] keyMap;
    private String description;

    public CLI(JstacsTool ... tools) {
        this((boolean[])null, tools);
    }

    public CLI(boolean[] configureThreads, JstacsTool ... tools) {
        this("", configureThreads, tools);
    }

    public CLI(String opt, boolean[] configureThreads, JstacsTool ... tools) {
        this(null, opt, configureThreads, tools);
    }

    public CLI(String description, String opt, boolean[] configureThreads, JstacsTool ... tools) {
        this.configureThreads = configureThreads == null ? new boolean[tools.length] : configureThreads;
        this.tools = tools;
        this.toolParameters = new ParameterSet[tools.length];
        this.keyMap = new HashMap[tools.length];
        for (int i = 0; i < tools.length; ++i) {
            this.toolParameters[i] = tools[i].getToolParameters();
            this.keyMap[i] = new HashMap();
            CLI.addToKeyMap("", this.keyMap[i], this.toolParameters[i]);
        }
        this.opt = opt.trim();
        if (this.opt.indexOf(32) >= 0) {
            throw new IllegalArgumentException(opt);
        }
        if (this.opt.length() > 0) {
            this.opt = " " + this.opt;
        }
        this.description = description;
    }

    private static void addToKeyMap(String pathPrefix, HashMap<String, String> hashMap, ParameterSet parameterSet) {
        boolean isExp = parameterSet instanceof ExpandableParameterSet;
        for (int i = 0; i < parameterSet.getNumberOfParameters(); ++i) {
            String key;
            String add;
            Parameter par = parameterSet.getParameterAt(i);
            String parKey = pathPrefix + ":" + par.getName();
            String string = add = isExp ? "?" : i + "";
            if (par.getDatatype() != DataType.PARAMETERSET) {
                key = hashMap.get(parKey);
                if (key != null) continue;
                key = CLI.getKey(hashMap, par);
                hashMap.put(parKey, key);
                continue;
            }
            if (par instanceof AbstractSelectionParameter) {
                if (par instanceof MultiSelectionParameter) {
                    throw new RuntimeException("Not implemented for " + par.getClass());
                }
                key = hashMap.get(parKey);
                if (key == null) {
                    key = CLI.getKey(hashMap, par);
                    hashMap.put(parKey, key);
                }
                ParameterSet incoll = ((AbstractSelectionParameter)par).getParametersInCollection();
                HashMap copyTemp = (HashMap)hashMap.clone();
                for (int j = 0; j < incoll.getNumberOfParameters(); ++j) {
                    HashMap copy = (HashMap)copyTemp.clone();
                    ParameterSetContainer cont = (ParameterSetContainer)incoll.getParameterAt(j);
                    CLI.addToKeyMap(pathPrefix + ":" + add + "-" + j, copy, cont.getValue());
                    hashMap.putAll(copy);
                }
                continue;
            }
            ParameterSet ps = (ParameterSet)par.getValue();
            CLI.addToKeyMap(pathPrefix + ":" + add, hashMap, ps);
        }
    }

    private static String getKey(HashMap<String, String> hashMap, Parameter par) {
        Collection<String> valueSet2 = hashMap.values();
        LinkedList<String> valueSet = new LinkedList<String>(valueSet2);
        valueSet.add("outdir");
        valueSet.add("info");
        valueSet.add("threads");
        String parName = par.getName();
        String key = (parName.charAt(0) + "").toLowerCase();
        if (!valueSet.contains(key)) {
            return key;
        }
        String[] temp = parName.split("\\s");
        key = "";
        for (int i = 0; i < temp.length; ++i) {
            key = key + temp[i].charAt(0);
        }
        if (!valueSet.contains(key = key.toLowerCase())) {
            return key;
        }
        key = parName.replaceAll("[\\s=]", "");
        int k = 1;
        String temp2 = key;
        while (valueSet.contains(temp2)) {
            temp2 = key + k;
            ++k;
        }
        return key;
    }

    private int getToolIndex(String shortName) {
        for (int i = 0; i < this.tools.length; ++i) {
            if (!shortName.equals(this.tools[i].getShortName())) continue;
            return i;
        }
        return -1;
    }

    public void run(String[] args) throws Exception {
        int toolIndex;
        SysProtocol protocol = new SysProtocol();
        String outdir = ".";
        int n = this.tools.length == 1 ? 0 : (toolIndex = args.length > 0 ? this.getToolIndex(args[0]) : -1);
        if (toolIndex < 0) {
            String jar = "<name>.jar";
            try {
                File jarfile = new File(CLI.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
                jar = jarfile.getName();
            }
            catch (Exception jarfile) {
                // empty catch block
            }
            if (this.description != null && this.description.length() > 0) {
                System.err.println(this.description + "\n");
            }
            System.err.println("Available tools:\n");
            for (int i = 0; i < this.tools.length; ++i) {
                System.err.println("\t" + this.tools[i].getShortName() + " - " + this.tools[i].getToolName());
            }
            System.err.println();
            System.err.println("Syntax: java -jar " + jar + this.opt + " <toolname> [<parameter=value> ...]\n");
            System.err.println("Further info about the tools is given with\n\tjava -jar " + jar + this.opt + " <toolname> info\n");
            System.err.println("Tool parameters are listed with\n\tjava -jar " + jar + this.opt + " <toolname>\n");
        } else if (args.length > 1 && args[1].equals("info") || this.tools.length == 1 && args.length > 0 && args[0].equals("info")) {
            System.err.println("\n" + CLI.parse(this.tools[toolIndex].getHelpText()));
        } else {
            Pair<String, Integer> pair = null;
            int threads = 1;
            try {
                pair = this.setToolParameters(this.configureThreads[toolIndex], this.tools.length == 1 ? 0 : 1, this.toolParameters[toolIndex], this.keyMap[toolIndex], args, protocol);
                outdir = pair.getFirstElement();
                threads = pair.getSecondElement();
            }
            catch (IllegalArgumentException e) {
                this.printToolParameters(toolIndex, protocol, outdir, 1);
                System.err.println("\n" + e.getMessage());
                return;
            }
            if (!this.toolParameters[toolIndex].hasDefaultOrIsSet()) {
                this.printToolParameters(toolIndex, protocol, outdir, threads);
                System.err.println("\nAt least one parameter has not been set (correctly).");
                return;
            }
            this.printToolParameters(toolIndex, protocol, outdir, threads);
            protocol.flush();
            ToolResult results = this.tools[toolIndex].run(this.toolParameters[toolIndex], protocol, new ProgressUpdater(), threads);
            ResultSet[] rs = results.getRawResult();
            Result[] r = new Result[rs[0].getNumberOfResults() + 1];
            int i = 0;
            while (i + 1 < r.length) {
                r[i] = rs[0].getResultAt(i);
                ++i;
            }
            String n2 = File.createTempFile("CLI-potocol-", ".txt").getAbsolutePath();
            FileManager.writeFile(n2, (CharSequence)protocol.getLog());
            r[r.length - 1] = new TextResult("protocol " + this.tools[toolIndex].getShortName(), "Result", new FileParameter.FileRepresentation(n2), "txt", this.tools[toolIndex].getToolName(), null, true);
            results = new ToolResult(results.getName(), results.getComment(), results.getAnnotation(), new ResultSet(new Result[][]{r}), this.toolParameters[toolIndex], results.getToolName(), results.getFinishedDate());
            ResultSaver<?> saver = ResultSaverLibrary.getSaver(results.getClass());
            saver.writeOutput(results, new File(outdir));
        }
    }

    private Pair<String, Integer> setToolParameters(boolean configureThreads, int off, ParameterSet parameterSet, HashMap<String, String> hashMap, String[] args, Protocol protocol) throws SimpleParameter.IllegalValueException {
        HashMap<String, LinkedList<String>> valueMap = new HashMap<String, LinkedList<String>>();
        String outdir = ".";
        int threads = 1;
        boolean newLine = false;
        for (int i = off; i < args.length; ++i) {
            int idx = args[i].indexOf("=");
            if (idx < 0) {
                throw new SimpleParameter.IllegalValueException("Parameter mis-specified in: " + args[i]);
            }
            String[] temp = new String[]{args[i].substring(0, idx), args[i].substring(idx + 1)};
            if ("outdir".equals(temp[0])) {
                outdir = temp[1];
                continue;
            }
            if (configureThreads && "threads".equals(temp[0])) {
                threads = Integer.parseInt(temp[1]);
                continue;
            }
            LinkedList<String> v = valueMap.get(temp[0]);
            if (v == null) {
                valueMap.put(temp[0], new LinkedList());
            }
            valueMap.get(temp[0]).add(temp[1]);
        }
        if (newLine) {
            protocol.append("\n");
        }
        this.set("", parameterSet, hashMap, valueMap, protocol, 0);
        if (valueMap.size() > 0) {
            Iterator<String> it = valueMap.keySet().iterator();
            HashSet<String> h = new HashSet<String>();
            h.addAll(hashMap.values());
            while (it.hasNext()) {
                String k = it.next();
                if (!h.contains(k)) continue;
                throw new IllegalArgumentException("Parameter " + k + " specified multiple times or not applicable for current selection(s). Could not use value(s): " + valueMap.get(k));
            }
            throw new IllegalArgumentException("Unknown parameters: " + valueMap);
        }
        return new Pair<String, Integer>(outdir, threads);
    }

    private void set(String pathPrefix, ParameterSet parameters, HashMap<String, String> hashMap, HashMap<String, LinkedList<String>> valueMap, Protocol protocol, int exp) throws SimpleParameter.IllegalValueException {
        boolean isExp = parameters instanceof ExpandableParameterSet;
        ParameterSet template = null;
        if (isExp) {
            template = (ParameterSet)parameters.getParameterAt(0).getValue();
            if (++exp > 1) {
                throw new RuntimeException("Nested ExpandableParameterSets not implemented.");
            }
            pathPrefix = pathPrefix + ":?";
        }
        int n = (isExp ? template : parameters).getNumberOfParameters();
        for (int i = 0; i < n; ++i) {
            Parameter par = (isExp ? template : parameters).getParameterAt(i);
            String parKey = pathPrefix + ":" + par.getName();
            if (par.getDatatype() != DataType.PARAMETERSET || par instanceof AbstractSelectionParameter) {
                String key = hashMap.get(parKey);
                if (key == null) {
                    throw new IllegalArgumentException("Could not find a key for parameter: " + par.getName() + "\t" + parKey);
                }
                LinkedList<String> value = valueMap.get(key);
                if (value != null) {
                    if (isExp) {
                        int k = 0;
                        while (value.size() > 0) {
                            if (k >= parameters.getNumberOfParameters()) {
                                try {
                                    ((ExpandableParameterSet)parameters).addParameterToSet();
                                }
                                catch (CloneNotSupportedException doesnothappen) {
                                    doesnothappen.printStackTrace();
                                }
                            }
                            Parameter par2 = ((ParameterSet)parameters.getParameterAt(k).getValue()).getParameterAt(i);
                            par2.setValue(value.removeFirst());
                            if (par2.getDatatype() == DataType.PARAMETERSET) {
                                this.set(pathPrefix + ":" + i + (par2 instanceof SelectionParameter ? "-" + ((SelectionParameter)par2).getSelected() : ""), (ParameterSet)par2.getValue(), hashMap, valueMap, protocol, exp);
                            }
                            ++k;
                        }
                    } else {
                        par.setValue(value.removeFirst());
                        if (par.getDatatype() == DataType.PARAMETERSET) {
                            this.set(pathPrefix + ":" + i + (par instanceof SelectionParameter ? "-" + ((SelectionParameter)par).getSelected() : ""), (ParameterSet)par.getValue(), hashMap, valueMap, protocol, exp);
                        }
                    }
                } else if (par.getDatatype() == DataType.PARAMETERSET) {
                    this.set(pathPrefix + ":" + i + (par instanceof SelectionParameter ? "-" + ((SelectionParameter)par).getSelected() : ""), (ParameterSet)par.getValue(), hashMap, valueMap, protocol, exp);
                }
                if (value == null || value.size() != 0) continue;
                valueMap.remove(key);
                continue;
            }
            this.set(pathPrefix + ":" + i, (ParameterSet)par.getValue(), hashMap, valueMap, protocol, exp);
        }
    }

    private static void print(String pathPrefix, HashMap<String, String> keyMap, ParameterSet parameters, String tabPrefix, Protocol protocol, String add) {
        boolean isExp = parameters instanceof ExpandableParameterSet;
        ExpandableParameterSet exp = null;
        if (isExp) {
            exp = (ExpandableParameterSet)parameters;
            parameters = (ParameterSet)parameters.getParameterAt(0).getValue();
            protocol.appendWarning(tabPrefix + "This parameter can be used multiple times:\n");
            int n = exp.getNumberOfParameters();
            for (int k = 0; k < n; ++k) {
                ParameterSet ps2 = (ParameterSet)exp.getParameterAt(k).getValue();
                CLI.print(pathPrefix + ":?", keyMap, ps2, tabPrefix, protocol, n > 1 ? " (" + (k + 1) + ")" : "");
            }
        } else {
            for (int i = 0; i < parameters.getNumberOfParameters(); ++i) {
                Parameter par = parameters.getParameterAt(i);
                String parKey = pathPrefix + ":" + par.getName();
                if (par.getDatatype() != DataType.PARAMETERSET) {
                    protocol.appendWarning(tabPrefix + keyMap.get(parKey) + add + " - " + par.toString() + "\n");
                    continue;
                }
                if (par instanceof AbstractSelectionParameter) {
                    String k = keyMap.get(parKey);
                    if (k == null) {
                        throw new IllegalArgumentException("Could not find a key for parameter: " + par.getName() + "\t" + parKey);
                    }
                    protocol.appendWarning(tabPrefix + k + add + " - " + par.toString() + "\n");
                    ParameterSet incoll = ((AbstractSelectionParameter)par).getParametersInCollection();
                    char[] array = new char[k.length() + 3];
                    Arrays.fill(array, ' ');
                    String off = tabPrefix + new String(array);
                    for (int j = 0; j < incoll.getNumberOfParameters(); ++j) {
                        ParameterSetContainer cont = (ParameterSetContainer)incoll.getParameterAt(j);
                        if (cont.getValue().getNumberOfParameters() > 0) {
                            protocol.appendWarning(off + "Parameters for selection \"" + cont.getName() + "\":\n");
                            CLI.print(pathPrefix + ":" + i + "-" + j, keyMap, cont.getValue(), off + "\t", protocol, add);
                            continue;
                        }
                        protocol.appendWarning(off + "No parameters for selection \"" + cont.getName() + "\"\n");
                    }
                    continue;
                }
                ParameterSet ps = (ParameterSet)par.getValue();
                CLI.print(pathPrefix + ":" + i, keyMap, ps, tabPrefix + "\t", protocol, add);
            }
        }
    }

    private static void printTable(String prefix, HashMap<String, String> keyMap, ParameterSet parameters, PrintStream out) {
        boolean isExp = parameters instanceof ExpandableParameterSet;
        for (int i = 0; i < parameters.getNumberOfParameters(); ++i) {
            String add;
            Parameter par = parameters.getParameterAt(i);
            String parKey = prefix + ":" + par.getName();
            String string = add = isExp ? "?" : i + "";
            if (par.getDatatype() == DataType.PARAMETERSET && !(par instanceof AbstractSelectionParameter)) {
                ParameterSet ps = (ParameterSet)par.getValue();
                CLI.printTable(prefix + ":" + add, keyMap, ps, out);
                continue;
            }
            out.append("<tr style=\"vertical-align:top\">\n<td><font color=\"green\">" + keyMap.get(parKey) + "</font></td>\n");
            String s = par.toString();
            out.append("<td>" + s.substring(0, s.lastIndexOf(")\t= ") + 1));
            if (par.getDatatype() != DataType.PARAMETERSET) {
                out.append("</td>\n<td>" + (Object)((Object)par.getDatatype()) + "</td>\n</tr>\n");
                continue;
            }
            out.append("<table border=0 cellpadding=10 align=\"center\">\n");
            ParameterSet incoll = ((AbstractSelectionParameter)par).getParametersInCollection();
            for (int j = 0; j < incoll.getNumberOfParameters(); ++j) {
                ParameterSetContainer cont = (ParameterSetContainer)incoll.getParameterAt(j);
                if (cont.getValue().getNumberOfParameters() > 0) {
                    out.append("<tr><td colspan=3>Parameters for selection &quot;" + cont.getName() + "&quot;:</td></tr>\n");
                    CLI.printTable(prefix + ":" + add + "-" + j, keyMap, cont.getValue(), out);
                    continue;
                }
                out.append("<tr><td colspan=3>No parameters for selection &quot;" + cont.getName() + "&quot;</td></tr>\n");
            }
            out.append("</table></td><td></td>\n</tr>\n");
        }
    }

    private void printToolParameters(int toolIndex, Protocol protocol, String outdir, int threads) {
        ParameterSet ps = this.toolParameters[toolIndex];
        protocol.appendWarning("Parameters of tool \"" + this.tools[toolIndex].getToolName() + "\" (" + this.tools[toolIndex].getShortName() + ", version: " + this.tools[toolIndex].getToolVersion() + "):\n");
        CLI.print("", this.keyMap[toolIndex], ps, "", protocol, "");
        protocol.appendWarning("outdir - The output directory, defaults to the current working directory (.)\t= " + outdir + "\n");
        if (this.configureThreads[toolIndex]) {
            protocol.appendWarning("threads - The number of threads used for the tool, defaults to 1\t= " + threads + "\n");
        }
    }

    public void wiki() {
        for (int toolIndex = 0; toolIndex < this.keyMap.length; ++toolIndex) {
            ParameterSet ps = this.toolParameters[toolIndex];
            try {
                PrintStream fos = new PrintStream(new FileOutputStream(this.tools[toolIndex].getShortName() + ".txt"));
                fos.append("<table border=0 cellpadding=10 align=\"center\">\n<tr>\n<td>name</td>\n<td>comment</td>\n<td>type</td>\n</tr>\n<tr><td colspan=3><hr></td></tr>\n");
                CLI.printTable("", this.keyMap[toolIndex], ps, fos);
                fos.append("<tr style=\"vertical-align:top\">\n<td><font color=\"green\">outdir</font></td>\n");
                fos.append("<td>The output directory, defaults to the current working directory (.)</td>\n");
                fos.append("<td>STRING</td>\n</tr>\n");
                fos.append("</table>");
                fos.close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String parse(String restruct) {
        int i;
        String[] lines = restruct.split("\n");
        Pattern bold = Pattern.compile("\\*\\*(.+?)\\*\\*");
        Pattern italics = Pattern.compile("\\*(.+?)\\*");
        Pattern tt = Pattern.compile("\\`\\`(.+?)\\`\\`");
        Pattern link = Pattern.compile("^\\.\\.\\s+\\_(.*?)\\s*\\:\\s*(.*)$");
        HashMap<Pattern, String> linkTargets = new HashMap<Pattern, String>();
        for (i = 0; i < lines.length; ++i) {
            Matcher m = bold.matcher(lines[i]);
            lines[i] = m.replaceAll("\u00a7$1\u00a7");
            m = italics.matcher(lines[i]);
            lines[i] = m.replaceAll("'$1'");
            lines[i] = lines[i].replaceAll("\u00a7", "*");
            m = tt.matcher(lines[i]);
            lines[i] = m.replaceAll("$1");
            m = link.matcher(lines[i]);
            if (!m.matches()) continue;
            String key = m.group(1);
            String target = m.group(2);
            linkTargets.put(Pattern.compile("\\`?(" + key + ")\\`?\\_"), target);
            lines[i] = "";
        }
        for (i = 0; i < lines.length; ++i) {
            Set pats = linkTargets.keySet();
            for (Pattern pat : pats) {
                Matcher m = pat.matcher(lines[i]);
                lines[i] = m.replaceAll("$1 (" + (String)linkTargets.get(pat) + ")");
            }
        }
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < lines.length; ++i2) {
            sb.append(lines[i2]);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static class SysProtocol
    implements Protocol {
        private StringBuffer log = new StringBuffer();

        @Override
        public void append(String str) {
            System.out.print(str);
            this.log.append(str);
        }

        @Override
        public void appendHeading(String heading) {
            System.out.print("* " + heading);
            this.log.append("* " + heading);
        }

        @Override
        public void appendWarning(String warning) {
            System.err.print(warning);
            this.log.append(warning);
        }

        public StringBuffer getLog() {
            return this.log;
        }

        @Override
        public void appendThrowable(Throwable th) {
            StringWriter str = new StringWriter();
            th.printStackTrace(new PrintWriter(str));
            String strstr = str.toString();
            System.err.println(strstr);
            this.log.append(strstr);
        }

        @Override
        public void appendVerbatim(String verbatim) {
            this.append(verbatim);
        }

        @Override
        public void flush() {
            System.err.flush();
            System.out.flush();
        }
    }
}

