/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils;

import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.results.Result;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LargeSequenceReader {
    public static Pair<IntList, ArrayList<Sequence>> readNextSequences(BufferedReader read, StringBuffer lastHeader, int minimumLength) throws IOException {
        String str = null;
        StringBuffer line = new StringBuffer();
        IntList starts = new IntList();
        ArrayList<Sequence> seqs = new ArrayList<Sequence>();
        Pattern acgt = Pattern.compile("[ACGT]+", 2);
        DNAAlphabetContainer con = DNAAlphabetContainer.SINGLETON;
        int size = 0;
        while ((str = read.readLine()) != null || line.length() > 0) {
            if (str != null) {
                str = str.trim();
            }
            if (str == null || str.startsWith(">")) {
                String header = lastHeader.toString();
                if (str != null) {
                    lastHeader.delete(0, lastHeader.length());
                    lastHeader.append(str.substring(1).trim());
                }
                if (line.length() <= 0) continue;
                int idx = header.indexOf(" ");
                if (idx > 0) {
                    header = header.substring(0, idx);
                }
                SequenceAnnotation annotation = new SequenceAnnotation("id", header, (Result[][])new Result[0][]);
                String seqStr = line.toString();
                line.delete(0, line.length());
                Matcher match = acgt.matcher(seqStr);
                while (match.find()) {
                    int start = match.start();
                    int end = match.end();
                    int l = end - start;
                    if (l < minimumLength) continue;
                    try {
                        Sequence seq = Sequence.create(con, seqStr.substring(start, end));
                        seq = seq.annotate(false, annotation);
                        seqs.add(seq);
                    }
                    catch (WrongAlphabetException ex) {
                        throw new RuntimeException(ex);
                    }
                    size += l;
                    starts.add(start);
                }
                if (!((double)size > 1.0E7) && str != null) continue;
                return new Pair<IntList, ArrayList<Sequence>>(starts, seqs);
            }
            line.append(str);
        }
        return null;
    }
}

