/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils.graphics;

import de.jstacs.utils.graphics.EPSAdaptor;
import de.jstacs.utils.graphics.GraphicsAdaptor;
import de.jstacs.utils.graphics.PDFAdaptor;
import de.jstacs.utils.graphics.RasterizedAdaptor;
import de.jstacs.utils.graphics.SVGAdaptor;

public class GraphicsAdaptorFactory {
    public static GraphicsAdaptor getAdaptor(OutputFormat key) {
        switch (key) {
            case SVG: {
                return new SVGAdaptor();
            }
            case PDF: {
                return new PDFAdaptor();
            }
            case EPS: {
                return new EPSAdaptor();
            }
            case PNG: {
                return new RasterizedAdaptor("png");
            }
            case JPEG: {
                return new RasterizedAdaptor("jpg");
            }
        }
        throw new IllegalArgumentException();
    }

    public static enum OutputFormat {
        SVG,
        PDF,
        EPS,
        PNG,
        JPEG;

    }
}

