/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine.Rserve;

import java.io.Serializable;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RserveException;
import org.rosuda.REngine.Rserve.protocol.RPacket;
import org.rosuda.REngine.Rserve.protocol.RTalk;

public class RSession
implements Serializable {
    private static final long serialVersionUID = -7048099825974875604L;
    String host;
    int port;
    byte[] key;
    transient RPacket attachPacket = null;
    int rsrvVersion;

    protected RSession() {
    }

    RSession(RConnection c, RPacket p) throws RserveException {
        this.host = c.host;
        this.rsrvVersion = c.rsrvVersion;
        byte[] ct = p.getCont();
        if (ct == null || ct.length != 44) {
            throw new RserveException(c, "Invalid response to session detach request.");
        }
        this.port = RTalk.getInt(ct, 4);
        this.key = new byte[32];
        System.arraycopy(ct, 12, this.key, 0, 32);
    }

    public RConnection attach() throws RserveException {
        RConnection c = new RConnection(this);
        this.attachPacket = c.rt.request(-1);
        return c;
    }
}

