/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.KolmogorovSmirnovDist;
import umontreal.iro.lecuyer.probdist.KolmogorovSmirnovPlusDist;
import umontreal.iro.lecuyer.util.Num;
import umontreal.iro.lecuyer.util.RootFinder;

public class KolmogorovSmirnovDistQuick
extends KolmogorovSmirnovDist {
    protected static final int NSEP = 50;

    public KolmogorovSmirnovDistQuick(int n) {
        super(n);
    }

    public double density(double x) {
        return KolmogorovSmirnovDistQuick.density(this.n, x);
    }

    public double cdf(double x) {
        return KolmogorovSmirnovDistQuick.cdf(this.n, x);
    }

    public double barF(double x) {
        return KolmogorovSmirnovDistQuick.barF(this.n, x);
    }

    public double inverseF(double u) {
        return KolmogorovSmirnovDistQuick.inverseF(this.n, u);
    }

    public static double density(int n, double x) {
        double Res = KolmogorovSmirnovDistQuick.densConnue(n, x);
        if (Res != -1.0) {
            return Res;
        }
        double EPS = 1.0 / Num.TWOEXP[6];
        Res = (KolmogorovSmirnovDistQuick.cdf(n, x + EPS) - KolmogorovSmirnovDistQuick.cdf(n, x - EPS)) / (2.0 * EPS);
        if (Res <= 0.0) {
            return 0.0;
        }
        return Res;
    }

    public static double cdf(int n, double x) {
        double E9;
        double E4;
        double Res = KolmogorovSmirnovDistQuick.cdfConnu(n, x);
        if (Res >= 0.0) {
            return Res;
        }
        if (n <= 50) {
            return KolmogorovSmirnovDist.cdf(n, x);
        }
        double T = 2.0 * (double)n * x * x;
        if (T <= 1.5) {
            double calcul;
            double RACN = Math.sqrt(n);
            double PI = Math.PI;
            double EPS = 1.0E-10;
            double TERME = Math.PI * Math.PI / (4.0 * T);
            double phi = 0.0;
            double phiprime = 0.0;
            for (int j = 1; j < 20; ++j) {
                double deuxJcarre = (2.0 * (double)j - 1.0) * (2.0 * (double)j - 1.0);
                calcul = Math.exp(-deuxJcarre * TERME);
                phiprime += calcul * deuxJcarre * TERME / (RACN * x * 0.5);
                if (calcul <= 1.0E-10 * (phi += calcul)) break;
            }
            calcul = Math.sqrt(Math.PI * 2 / (double)n) / x;
            phiprime *= calcul;
            return phi + 1.0 / (6.0 * RACN) * (phiprime -= (phi *= calcul) / (RACN * x));
        }
        double E2 = Math.exp(-T);
        Res = 1.0 + (x * 4.0 / 3.0 - 2.0) * E2 + (2.0 - x * 16.0 / 3.0) * (E4 = Math.exp(-4.0 * T)) + (x * 12.0 - 2.0) * (E9 = Math.exp(-9.0 * T));
        if (Res <= 0.0) {
            return 0.0;
        }
        return Res;
    }

    public static double barF(int n, double x) {
        double Res = KolmogorovSmirnovDistQuick.barFConnu(n, x);
        if (Res >= 0.0) {
            return Res;
        }
        double t = (double)n * x * x;
        if (t > 2.0) {
            if (n <= 200000) {
                return 2.0 * KolmogorovSmirnovPlusDist.KSPlusbarUpper(n, x);
            }
            return 2.0 * KolmogorovSmirnovPlusDist.KSPlusbarAsymp(n, x);
        }
        if (n <= 50) {
            return KolmogorovSmirnovDist.barF(n, x);
        }
        return 1.0 - KolmogorovSmirnovDistQuick.cdf(n, x);
    }

    public static double inverseF(int n, double u) {
        double Res = KolmogorovSmirnovDistQuick.inverseConnue(n, u);
        if (Res != -1.0) {
            return Res;
        }
        Function f = new Function(n, u);
        return RootFinder.brentDekker(0.5 / (double)n, 1.0, f, 1.0E-5);
    }

    private static class Function
    implements MathFunction {
        protected int n;
        protected double u;

        public Function(int n, double u) {
            this.n = n;
            this.u = u;
        }

        public double evaluate(double x) {
            return this.u - KolmogorovSmirnovDistQuick.cdf(this.n, x);
        }
    }
}

