/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.JohnsonSBDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class JohnsonSBGen
extends RandomVariateGen {
    private double gamma;
    private double delta;
    private double xi;
    private double lambda;

    public JohnsonSBGen(RandomStream s, double gamma, double delta, double xi, double lambda) {
        super(s, new JohnsonSBDist(gamma, delta, xi, lambda));
        this.setParams(gamma, delta, xi, lambda);
    }

    public JohnsonSBGen(RandomStream s, JohnsonSBDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getGamma(), dist.getDelta(), dist.getXi(), dist.getLambda());
        }
    }

    public static double nextDouble(RandomStream s, double gamma, double delta, double xi, double lambda) {
        return JohnsonSBDist.inverseF(gamma, delta, xi, lambda, s.nextDouble());
    }

    public double getGamma() {
        return this.gamma;
    }

    public double getDelta() {
        return this.delta;
    }

    public double getXi() {
        return this.xi;
    }

    public double getLambda() {
        return this.lambda;
    }

    protected void setParams(double gamma, double delta, double xi, double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        this.gamma = gamma;
        this.delta = delta;
        this.xi = xi;
        this.lambda = lambda;
    }
}

