/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.alignment.cost;

import de.jstacs.algorithms.alignment.cost.Costs;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;

public class AffineCosts
implements Costs {
    private double startInsert;
    private double startDelete;
    private double elongInsert;
    private double elongDelete;
    private boolean equal;
    private Costs c;

    public AffineCosts(double start, Costs c) {
        this(start, start, c);
    }

    public AffineCosts(double startInsert, double startDelete, Costs c) {
        this.c = c;
        this.elongInsert = c.getInsertCosts();
        this.elongDelete = c.getDeleteCosts();
        if (startInsert < 0.0 && -startInsert > this.elongInsert || startDelete < 0.0 && -startDelete > this.elongDelete) {
            throw new IllegalArgumentException("Problem: start < 0 && -start > elong");
        }
        this.startInsert = startInsert;
        this.startDelete = startDelete;
        this.equal = this.elongInsert == this.elongDelete && startInsert == startDelete;
    }

    public AffineCosts(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, "AffineCosts");
        this.c = (Costs)XMLParser.extractObjectForTags(xml, "c");
        try {
            this.elongInsert = (Double)XMLParser.extractObjectForTags(xml, "elongInsert");
            this.startInsert = (Double)XMLParser.extractObjectForTags(xml, "startInsert");
            this.elongDelete = (Double)XMLParser.extractObjectForTags(xml, "elongDelete");
            this.startDelete = (Double)XMLParser.extractObjectForTags(xml, "startDelete");
        }
        catch (NonParsableException ex) {
            this.elongInsert = this.elongDelete = ((Double)XMLParser.extractObjectForTags(xml, "elong")).doubleValue();
            this.startInsert = this.startDelete = ((Double)XMLParser.extractObjectForTags(xml, "start")).doubleValue();
        }
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.c, "c");
        XMLParser.appendObjectWithTags(xml, this.elongInsert, "elongInsert");
        XMLParser.appendObjectWithTags(xml, this.startInsert, "startInsert");
        XMLParser.appendObjectWithTags(xml, this.elongDelete, "elongDelete");
        XMLParser.appendObjectWithTags(xml, this.startDelete, "startDelete");
        XMLParser.addTags(xml, "AffineCosts");
        return xml;
    }

    public Costs getInternalCosts() {
        return this.c;
    }

    public double getElongateInsertCosts() {
        return this.elongInsert;
    }

    public double getElongateDeleteCosts() {
        return this.elongDelete;
    }

    public double getInsertCostsFor(int length) {
        return this.startInsert + (double)length * this.elongInsert;
    }

    public double getDeleteCostsFor(int length) {
        return this.startDelete + (double)length * this.elongDelete;
    }

    public double getGapCostsFor(int length) {
        if (this.equal) {
            return this.startDelete + (double)length * this.elongDelete;
        }
        throw new IllegalArgumentException("Costs for delete and insert not equal.");
    }

    @Override
    public double getCostFor(Sequence s1, Sequence s2, int i, int j) {
        return this.c.getCostFor(s1, s2, i, j);
    }

    @Override
    public double getInsertCosts() {
        return this.c.getInsertCosts();
    }

    @Override
    public double getDeleteCosts() {
        return this.c.getDeleteCosts();
    }
}

