/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.assessment;

import de.jstacs.DataType;
import de.jstacs.classifiers.assessment.ClassifierAssessmentAssessParameterSet;
import de.jstacs.data.DataSet;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.EnumParameter;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.Result;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class RepeatedHoldOutAssessParameterSet
extends ClassifierAssessmentAssessParameterSet {
    public RepeatedHoldOutAssessParameterSet() throws ParameterException, CloneNotSupportedException {
        this.addParameters();
    }

    public RepeatedHoldOutAssessParameterSet(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public RepeatedHoldOutAssessParameterSet(DataSet.PartitionMethod dataSplitMethod, int elementLength, boolean exceptionIfMPNotComputable, int repeats, double[] percents) throws ParameterException, CloneNotSupportedException {
        super(elementLength, exceptionIfMPNotComputable);
        this.addParameters();
        ((Parameter)this.parameters.get("repeats")).setValue(new Integer(repeats));
        ParameterSet[] tempPSA = new ParameterSet[percents.length];
        int i = 0;
        while (i < tempPSA.length) {
            tempPSA[i] = this.getParameterSetContainingASingleDoubleValue(percents[i++]);
        }
        ((ExpandableParameterSet)((ParameterSetContainer)this.parameters.get("testDataPercentage")).getValue()).replaceContentWith(tempPSA);
        ((Parameter)this.parameters.get(DataSet.PartitionMethod.class.getSimpleName())).setValue((Object)dataSplitMethod);
    }

    protected SimpleParameterSet getParameterSetContainingASingleDoubleValue(double percent) throws SimpleParameter.IllegalValueException {
        try {
            SimpleParameterSet ret = new SimpleParameterSet(new SimpleParameter(DataType.DOUBLE, "percent", "Defines the percentage of the entire given data (for a specific class) should be used as test-data in a RepeatedHoldOutExperiment.", true, new NumberValidator<Double>(0.0, 1.0)));
            if (!Double.isNaN(percent)) {
                ret.getParameterAt(0).setValue(percent);
            }
            return ret;
        }
        catch (SimpleParameter.DatatypeNotValidException doesnothappen) {
            return null;
        }
    }

    private void addParameters() throws ParameterException, CloneNotSupportedException {
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.INT, "repeats", "Determines how often the procedure of train/test classifers using random created train- and test-data should be repeated.", true, new NumberValidator<Integer>(1, Integer.MAX_VALUE))});
        this.parameters.add(new Parameter[]{new ParameterSetContainer("testDataPercentage", "A RepeatedHoldOutExperiment splits the given data (for each class) in each iteration into a test-part and a train-part. This ParameterSetcontainer contains an ExpandableParameterSet that contains for each class the percent of the entire data (for each class), that should be used as test-data. (1-percent) defines the percent of train-data.", new ExpandableParameterSet(this.getParameterSetContainingASingleDoubleValue(Double.NaN), "percent", "At pos i in this Expandable ParameterSet defines the percent of all given data, that should be used as test-data for class i in a RepeatedHoldOutExperiment."))});
        this.parameters.add(new Parameter[]{new EnumParameter(DataSet.PartitionMethod.class, "The method used to compute the percentages of the partitions", true)});
    }

    public int getRepeats() {
        return (Integer)this.getParameterForName("repeats").getValue();
    }

    public double[] getPercents() {
        ExpandableParameterSet tempEPS = (ExpandableParameterSet)this.getParameterForName("testDataPercentage").getValue();
        double[] ret = new double[tempEPS.getNumberOfParameters()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Double)((ParameterSet)tempEPS.getParameterAt(i).getValue()).getParameterAt(0).getValue();
        }
        return ret;
    }

    public DataSet.PartitionMethod getDataSplitMethod() {
        return (DataSet.PartitionMethod)((EnumParameter)this.getParameterForName(DataSet.PartitionMethod.class.getSimpleName())).getValue();
    }

    @Override
    public Collection<Result> getAnnotation() {
        ArrayList<Result> l = new ArrayList<Result>(3);
        l.add(new NumericalResult("repeats", "The number of iterations", this.getRepeats()));
        l.add(new CategoricalResult("percentage", "The percentage of the entire data (for each class), that was used in an assessment", Arrays.toString(this.getPercents())));
        l.add(new CategoricalResult("dataSplitMethod", "Describes how data should be splitted in ClassiefierAssessment.evaluateClassifier())", this.getDataSplitMethod().name()));
        return l;
    }
}

