/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.differentiableSequenceScoreBased;

import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.algorithms.optimization.EvaluationException;
import de.jstacs.algorithms.optimization.MultiThreadedFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.AbstractOptimizableFunction;
import de.jstacs.data.DataSet;

public abstract class AbstractMultiThreadedOptimizableFunction
extends AbstractOptimizableFunction
implements MultiThreadedFunction {
    protected Worker[] worker;
    protected double[] params;

    public static final int getNumberOfAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public AbstractMultiThreadedOptimizableFunction(int threads, DataSet[] data, double[][] weights, boolean norm, boolean freeParams) throws IllegalArgumentException {
        super(data, weights, norm, freeParams);
        if (threads < 1) {
            throw new IllegalArgumentException("The number of threads has to be positive.");
        }
        this.worker = new Worker[threads];
        this.prepareThreads();
    }

    @Override
    public void setDataAndWeights(DataSet[] data, double[][] weights) throws IllegalArgumentException {
        super.setDataAndWeights(data, weights);
        if (this.worker != null) {
            this.prepareThreads();
        }
    }

    protected void prepareThreads() {
        int i;
        int anz = 0;
        for (i = 0; i < this.data.length; ++i) {
            anz += this.data[i].getNumberOfElements();
        }
        int all = anz;
        int endClass = 0;
        int endSeq = 0;
        boolean out = true;
        for (i = 0; i < this.worker.length; ++i) {
            int c;
            int part = (int)Math.ceil((double)all / (double)(this.worker.length - i));
            int startSeq = endSeq;
            int startClass = endClass;
            for (c = part; endClass < this.data.length && this.data[endClass].getNumberOfElements() - endSeq < c; c -= this.data[endClass].getNumberOfElements() - endSeq, ++endClass) {
                endSeq = 0;
            }
            int current = part;
            endSeq += c;
            if (endClass >= this.data.length) {
                endClass = this.data.length - 1;
                current -= endSeq - this.data[endClass].getNumberOfElements();
                endSeq = this.data[endClass].getNumberOfElements();
                if (out && startClass == endClass && startSeq == endSeq) {
                    System.out.println("Warning: Splitting and assigning the data (" + anz + " sequences) to threads (" + this.worker.length + "), yields at least one empty thread.");
                    out = false;
                }
            }
            all -= current;
            if (this.worker[i] != null) {
                if (this.worker[i].isWaiting()) {
                    this.worker[i].setIndices(startClass, startSeq, endClass, endSeq);
                    continue;
                }
                this.stopThreads();
                throw new RuntimeException();
            }
            this.worker[i] = new Worker(i, startClass, startSeq, endClass, endSeq);
            this.worker[i].start();
        }
    }

    @Override
    public double[] evaluateGradientOfFunction(double[] x) throws DimensionException, EvaluationException {
        this.setParams(x);
        this.waitUntilWorkersFinished(WorkerTask.EVALUATE_GRADIENT);
        return this.joinGradients();
    }

    protected abstract void evaluateGradientOfFunction(int var1, int var2, int var3, int var4, int var5);

    protected abstract double[] joinGradients() throws EvaluationException;

    @Override
    public double evaluateFunction(double[] x) throws DimensionException, EvaluationException {
        this.setParams(x);
        this.waitUntilWorkersFinished(WorkerTask.EVALUATE);
        return this.joinFunction();
    }

    protected abstract void evaluateFunction(int var1, int var2, int var3, int var4, int var5) throws EvaluationException;

    protected abstract double joinFunction() throws EvaluationException, DimensionException;

    @Override
    public final void setParams(double[] params) throws DimensionException {
        if (this.params == null || this.params.length != params.length) {
            this.params = (double[])params.clone();
        } else {
            System.arraycopy(params, 0, this.params, 0, params.length);
        }
        this.setThreadIndependentParameters();
        this.waitUntilWorkersFinished(WorkerTask.SET_PARAMETERS);
    }

    protected abstract void setThreadIndependentParameters() throws DimensionException;

    protected abstract void setParams(int var1) throws DimensionException;

    private synchronized void waitUntilWorkersFinished(WorkerTask wt) {
        for (int t = 0; t < this.worker.length; ++t) {
            this.worker[t].setTask(wt);
        }
        boolean exception = false;
        int t = -1;
        while (true) {
            int i;
            for (i = 0; i < this.worker.length && this.worker[i].isWaiting(); ++i) {
                if (!this.worker[i].exception) continue;
                exception = true;
                t = i;
            }
            if (i == this.worker.length) {
                if (!exception) break;
                for (i = 0; i < this.worker.length; ++i) {
                    this.worker[i].interrupt();
                }
                this.stopThreads();
                throw new RuntimeException("Terminate program, since at least thread " + t + " throws an exception.");
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public final void stopThreads() {
        if (this.worker.length > 1) {
            for (int i = 0; i < this.worker.length; ++i) {
                this.worker[i].setTask(WorkerTask.STOP);
            }
            this.worker = null;
        }
    }

    @Override
    public final int getNumberOfThreads() {
        return this.worker.length;
    }

    private class Worker
    extends Thread {
        private WorkerTask task;
        private int index;
        private int startClass;
        private int startSeq;
        private int endClass;
        private int endSeq;
        private boolean exception;

        public Worker(int index, int startClass, int startSeq, int endClass, int endSeq) {
            super("worker thread " + index);
            this.setDaemon(true);
            this.index = index;
            this.setIndices(startClass, startSeq, endClass, endSeq);
        }

        private void setIndices(int startClass, int startSeq, int endClass, int endSeq) {
            this.startClass = startClass;
            this.startSeq = startSeq;
            this.endClass = endClass;
            this.endSeq = endSeq;
            this.task = WorkerTask.WAIT;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            this.exception = false;
            while (this.task != WorkerTask.STOP) {
                if (this.task != WorkerTask.WAIT) {
                    try {
                        switch (this.task) {
                            case SET_PARAMETERS: {
                                AbstractMultiThreadedOptimizableFunction.this.setParams(this.index);
                                break;
                            }
                            case EVALUATE: {
                                AbstractMultiThreadedOptimizableFunction.this.evaluateFunction(this.index, this.startClass, this.startSeq, this.endClass, this.endSeq);
                                break;
                            }
                            case EVALUATE_GRADIENT: {
                                AbstractMultiThreadedOptimizableFunction.this.evaluateGradientOfFunction(this.index, this.startClass, this.startSeq, this.endClass, this.endSeq);
                            }
                        }
                    }
                    catch (Exception e) {
                        this.exception = true;
                        e.printStackTrace();
                    }
                    AbstractMultiThreadedOptimizableFunction abstractMultiThreadedOptimizableFunction = AbstractMultiThreadedOptimizableFunction.this;
                    synchronized (abstractMultiThreadedOptimizableFunction) {
                        this.task = WorkerTask.WAIT;
                        AbstractMultiThreadedOptimizableFunction.this.notify();
                        continue;
                    }
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public synchronized void setTask(WorkerTask task) {
            this.task = task;
            this.notify();
        }

        public boolean isWaiting() {
            return this.task == WorkerTask.WAIT;
        }
    }

    private static enum WorkerTask {
        STOP,
        WAIT,
        SET_PARAMETERS,
        EVALUATE,
        EVALUATE_GRADIENT;

    }
}

