/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.performanceMeasures;

import de.jstacs.classifiers.performanceMeasures.AbstractNumericalTwoClassPerformanceMeasure;
import de.jstacs.io.NonParsableException;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.utils.ToolBox;

public abstract class MaximumNumericalTwoClassMeasure
extends AbstractNumericalTwoClassPerformanceMeasure {
    protected MaximumNumericalTwoClassMeasure() {
    }

    protected MaximumNumericalTwoClassMeasure(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public final String getName() {
        return "Maximum " + this.getMeasureName();
    }

    protected abstract String getMeasureName();

    protected abstract String getSpecificName();

    protected abstract double getMeasure(double var1, double var3, double var5, double var7);

    @Override
    public NumericalResultSet compute(double[] sortedScoresClass0, double[] weightsClass0, double[] sortedScoresClass1, double[] weightsClass1) {
        int i = 0;
        int j = 0;
        int d = sortedScoresClass1.length;
        int m = sortedScoresClass0.length;
        double tn = 0.0;
        double fn = 0.0;
        double pos = weightsClass0 == null ? (double)m : ToolBox.sum(0, m, weightsClass0);
        double neg = weightsClass1 == null ? (double)d : ToolBox.sum(0, d, weightsClass1);
        double tp = pos;
        double fp = neg;
        double[] current = new double[2];
        current[0] = Math.min(sortedScoresClass0[i], sortedScoresClass1[j]);
        double[] erg = new double[]{Double.NaN, Double.NaN};
        while (i < m || j < d) {
            double w;
            current[1] = this.getMeasure(tp, fp, fn, tn);
            if (Double.isNaN(erg[1]) || current[1] > erg[1]) {
                erg[0] = current[0];
                erg[1] = current[1];
            }
            while (j < d && sortedScoresClass1[j] == current[0]) {
                w = MaximumNumericalTwoClassMeasure.getWeight(weightsClass1, j);
                tn += w;
                fp -= w;
                ++j;
            }
            while (i < m && sortedScoresClass0[i] == current[0]) {
                w = MaximumNumericalTwoClassMeasure.getWeight(weightsClass0, i);
                tp -= w;
                fn += w;
                ++i;
            }
            if (i < m && j < d) {
                if (sortedScoresClass0[i] <= sortedScoresClass1[j]) {
                    current[0] = sortedScoresClass0[i];
                    continue;
                }
                current[0] = sortedScoresClass1[j];
                continue;
            }
            if (i < m) {
                current[0] = sortedScoresClass0[i];
                continue;
            }
            if (j >= d) continue;
            current[0] = sortedScoresClass1[j];
        }
        if (Double.isNaN(erg[1])) {
            throw new IllegalArgumentException("The measure could not be properly computed as it return always NaN. The arrays looked like: [" + sortedScoresClass0[0] + " .. " + sortedScoresClass0[sortedScoresClass0.length - 1] + "] and [" + sortedScoresClass1[0] + " .. " + sortedScoresClass1[sortedScoresClass1.length - 1] + "].");
        }
        return new NumericalResultSet(new NumericalResult[][]{{new NumericalResult("Maximum " + this.getSpecificName(), "The maximal value of the " + this.getSpecificName().toLowerCase(), erg[1]), new NumericalResult("Threshold for the maximum " + this.getSpecificName().toLowerCase(), "", erg[0])}});
    }
}

