/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.performanceMeasures;

import de.jstacs.classifiers.AbstractScoreBasedClassifier;
import de.jstacs.classifiers.performanceMeasures.AbstractTwoClassPerformanceMeasure;
import de.jstacs.classifiers.performanceMeasures.NumericalPerformanceMeasure;
import de.jstacs.io.NonParsableException;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.utils.ToolBox;
import java.util.ArrayList;

public class PRCurve
extends AbstractTwoClassPerformanceMeasure {
    public static final String NAME = "Precision-Recall curve";
    public static double minStepSize = 1.0;

    public PRCurve() {
    }

    public PRCurve(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ResultSet compute(double[] sortedScoresClass0, double[] weightClass0, double[] sortedScoresClass1, double[] weightClass1) {
        boolean unique;
        int j;
        boolean goadrichAndDavis = PRCurve.simpleWeights(weightClass0) && PRCurve.simpleWeights(weightClass1);
        ArrayList<double[]> list = null;
        if (!(this instanceof NumericalPerformanceMeasure)) {
            list = new ArrayList<double[]>();
        }
        int i_old = 0;
        int j_old = 0;
        int i = 0;
        int d = sortedScoresClass1.length;
        int m = sortedScoresClass0.length;
        double help1 = 0.0;
        double help2 = 0.0;
        double aucGD = 0.0;
        double aucIntegral = 0.0;
        double fn = 0.0;
        double tn = 0.0;
        double pos = weightClass0 == null ? (double)m : ToolBox.sum(weightClass0);
        double neg = weightClass1 == null ? (double)d : ToolBox.sum(weightClass1);
        for (j = 0; j < d && sortedScoresClass0[i] > sortedScoresClass1[j]; ++j) {
            tn += PRCurve.getWeight(weightClass1, j);
        }
        double[] p = new double[]{(pos - fn) / pos, (pos - fn) / (pos - fn + neg - tn)};
        if (list != null) {
            list.add((double[])p.clone());
        }
        boolean fromMotif = unique = j >= d || sortedScoresClass0[i] != sortedScoresClass1[j];
        while (i < m && j < d) {
            double helpJ;
            double propTerm;
            i_old = i;
            j_old = j;
            double tn_old = tn;
            double fn_old = fn;
            if (!unique || fromMotif) {
                while (i + 1 < m && sortedScoresClass0[i] == sortedScoresClass0[i + 1]) {
                    fn += PRCurve.getWeight(weightClass0, i);
                    ++i;
                }
                fn += PRCurve.getWeight(weightClass0, i);
                ++i;
            }
            if (!unique || !fromMotif) {
                while (j + 1 < d && sortedScoresClass1[j] == sortedScoresClass1[j + 1]) {
                    tn += PRCurve.getWeight(weightClass1, j);
                    ++j;
                }
                tn += PRCurve.getWeight(weightClass1, j);
                ++j;
            }
            if (i < m && j < d) {
                if (sortedScoresClass0[i] == sortedScoresClass1[j]) {
                    unique = false;
                } else {
                    unique = true;
                    fromMotif = sortedScoresClass0[i] < sortedScoresClass1[j];
                }
            }
            if (fn == fn_old) {
                p[1] = (pos - fn) / (pos - fn + neg - tn);
                if (list == null) continue;
                list.add((double[])p.clone());
                continue;
            }
            double pB = p[0];
            double pA = (pos - fn) / pos;
            if (goadrichAndDavis) {
                if (i < m || j < d) {
                    propTerm = (double)(j - j_old) / (double)(i - i_old);
                    double h1 = p[0];
                    double h2 = p[1];
                    helpJ = (double)j_old + propTerm;
                    for (int c = i_old + 1; c <= i; ++c) {
                        help1 = (double)(m - c) / (double)m;
                        help2 = (double)(m - c) / ((double)(m - c + d) - helpJ);
                        helpJ += propTerm;
                        aucGD += (h2 + help2) / 2.0 * (h1 - help1);
                        h1 = help1;
                        h2 = help2;
                    }
                } else {
                    aucGD += p[1] * p[0];
                }
            }
            double h = (tn - tn_old) / (fn - fn_old);
            double a = 1.0 + h;
            double b = (neg - tn - h * (pos - fn)) / pos;
            aucIntegral = b != 0.0 ? (aucIntegral += (pB - pA - b / a * (Math.log(a * pB + b) - Math.log(a * pA + b))) / a) : (aucIntegral += (pB - pA) / a);
            if (list != null) {
                propTerm = Math.min((fn - fn_old) / (double)(i - i_old), minStepSize);
                double helpI = fn_old + propTerm;
                helpJ = tn_old + (h *= propTerm);
                int k = 1;
                while (helpI < fn) {
                    p[0] = (pos - helpI) / pos;
                    p[1] = (pos - helpI) / (pos - helpI + neg - helpJ);
                    list.add((double[])p.clone());
                    helpJ = tn_old + (double)(++k) * h;
                    helpI = fn_old + (double)k * propTerm;
                }
            }
            if (pA == p[0]) continue;
            p[0] = pA;
            double temp = (pos - fn) / (pos - fn + neg - tn);
            if (!Double.isNaN(temp)) {
                p[1] = temp;
            }
            if (list == null) continue;
            list.add((double[])p.clone());
        }
        if (i < m) {
            help1 = 0.0;
            if (goadrichAndDavis) {
                aucGD += p[1] * (p[0] - help1);
            }
            aucIntegral += p[1] * (p[0] - help1);
            p[0] = help1;
            if (list != null) {
                list.add((double[])p.clone());
            }
        }
        NumericalResult auc1 = new NumericalResult("AUC-PR (Davis and Goadrich)", this.getName(), aucGD);
        NumericalResult auc2 = new NumericalResult("AUC-PR (Integral)", this.getName(), aucIntegral);
        if (list == null) {
            if (goadrichAndDavis) {
                return new NumericalResultSet(new NumericalResult[][]{{auc1, auc2}});
            }
            return new NumericalResultSet(auc2);
        }
        AbstractScoreBasedClassifier.DoubleTableResult curve = new AbstractScoreBasedClassifier.DoubleTableResult(this.getName(), this.getName(), list);
        if (goadrichAndDavis) {
            return new ResultSet(new Result[][]{{auc1, auc2, curve}});
        }
        return new ResultSet(new Result[][]{{auc2, curve}});
    }

    private void out(double[] array, int index) {
        System.out.print(index + " (" + (index < array.length ? Double.valueOf(array[index]) : "###") + ")\t");
    }
}

