/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.alphabets;

import de.jstacs.Singleton;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.ComplementableDiscreteAlphabet;
import de.jstacs.data.alphabets.DoubleSymbolException;

public final class IUPACDNAAlphabet
extends ComplementableDiscreteAlphabet
implements Singleton {
    public static final IUPACDNAAlphabet SINGLETON = IUPACDNAAlphabet.get();

    private static IUPACDNAAlphabet get() {
        IUPACDNAAlphabet res = null;
        try {
            res = new IUPACDNAAlphabet();
        }
        catch (Exception doesNotHappen) {
            throw new RuntimeException(doesNotHappen.getMessage());
        }
        return res;
    }

    private IUPACDNAAlphabet() throws DoubleSymbolException, IllegalArgumentException {
        super(true, IUPACDNAAlphabetParameterSet.DNA);
        this.parameters = IUPACDNAAlphabetParameterSet.SINGLETON;
    }

    @Override
    public int getComplementaryCode(int code) {
        if (code < 12) {
            return 11 - code;
        }
        return code;
    }

    public boolean isPart(String query, String code) throws WrongAlphabetException {
        return this.isPart(this.getCode(query), this.getCode(code));
    }

    public boolean isPart(int query, int code) {
        return IUPACDNAAlphabetParameterSet.subset[query][code];
    }

    public static final class IUPACDNAAlphabetParameterSet
    extends Alphabet.AlphabetParameterSet<IUPACDNAAlphabet>
    implements Singleton {
        public static final IUPACDNAAlphabetParameterSet SINGLETON = IUPACDNAAlphabetParameterSet.get();
        private static final String[] DNA = new String[]{"A", "C", "R", "K", "B", "D", "H", "V", "M", "Y", "G", "T", "S", "W", "N"};
        private static final boolean[][] subset = new boolean[DNA.length][DNA.length];

        private static IUPACDNAAlphabetParameterSet get() {
            IUPACDNAAlphabetParameterSet res = null;
            try {
                res = new IUPACDNAAlphabetParameterSet();
            }
            catch (Exception doesNotHappen) {
                throw new RuntimeException(doesNotHappen.getMessage());
            }
            return res;
        }

        private static void set(int ambigious, int ... subsets) throws WrongAlphabetException {
            for (int i = 0; i < subsets.length; ++i) {
                IUPACDNAAlphabetParameterSet.subset[subsets[i]][ambigious] = true;
            }
        }

        private IUPACDNAAlphabetParameterSet() throws Exception {
            super(IUPACDNAAlphabet.class);
        }

        @Override
        public String getInstanceComment() {
            return "A IUPAC alphabet for DNA.";
        }

        static {
            for (int i = 0; i < DNA.length; ++i) {
                IUPACDNAAlphabetParameterSet.subset[i][i] = true;
            }
            try {
                IUPACDNAAlphabetParameterSet.set(2, 0, 10);
                IUPACDNAAlphabetParameterSet.set(3, 10, 11);
                IUPACDNAAlphabetParameterSet.set(4, 1, 10, 11, 3, 9, 12);
                IUPACDNAAlphabetParameterSet.set(5, 0, 10, 11, 3, 13, 2);
                IUPACDNAAlphabetParameterSet.set(6, 0, 1, 11, 9, 13, 8);
                IUPACDNAAlphabetParameterSet.set(7, 0, 1, 10, 12, 2, 8);
                IUPACDNAAlphabetParameterSet.set(8, 0, 1);
                IUPACDNAAlphabetParameterSet.set(9, 1, 11);
                IUPACDNAAlphabetParameterSet.set(12, 1, 10);
                IUPACDNAAlphabetParameterSet.set(13, 0, 11);
                IUPACDNAAlphabetParameterSet.set(14, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13);
            }
            catch (WrongAlphabetException doesNotHappen) {
                throw new RuntimeException(doesNotHappen.getCause());
            }
        }
    }
}

