/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous;

import de.jstacs.Storable;
import de.jstacs.algorithms.optimization.termination.TerminationCondition;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.ConstraintManager;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.MEMConstraint;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.MEMTools;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.SequenceIterator;
import de.jstacs.utils.SafeOutputStream;
import java.text.NumberFormat;
import java.util.AbstractList;
import java.util.Arrays;

public final class MEM
implements Storable,
Cloneable {
    private static final String XML_TAG = "MEM";
    protected MEMConstraint[] constraints;
    private double lnZ;
    private double Z;
    private int[] indices;
    private int[] alphLen;
    private int[][] cond;

    private MEM(int[] indices, int[] allAlphLen) {
        this.indices = (int[])indices.clone();
        this.alphLen = new int[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            this.alphLen[i] = allAlphLen[indices[i]];
        }
    }

    public MEM(AbstractList<int[]> constr, int[] allAlphLen, int[] indices) {
        this(indices, allAlphLen);
        this.constraints = ConstraintManager.createConstraints(constr, allAlphLen, indices);
    }

    public MEM(int[] constraint, int[] allAlphLen, int[][] cond) {
        this(constraint, allAlphLen);
        int i = 0;
        int[] corrected = new int[constraint.length];
        while (i < constraint.length) {
            corrected[i] = i++;
        }
        this.constraints = new MEMConstraint[]{new MEMConstraint(constraint, allAlphLen, corrected)};
        if (cond != null) {
            i = 0;
            corrected = new int[allAlphLen.length];
            while (i < this.indices.length) {
                corrected[this.indices[i]] = i++;
            }
            this.cond = new int[cond.length][];
            for (i = 0; i < cond.length; ++i) {
                this.cond[i] = new int[cond[i].length];
                for (int j = 0; j < cond[i].length; ++j) {
                    this.cond[i][j] = corrected[cond[i][j]];
                }
            }
        }
    }

    public MEM(StringBuffer representation) throws NonParsableException {
        StringBuffer xml = XMLParser.extractForTag(representation, XML_TAG);
        this.indices = XMLParser.extractObjectForTags(xml, "used position", int[].class);
        this.alphLen = XMLParser.extractObjectForTags(xml, "alphLen", int[].class);
        this.Z = XMLParser.extractObjectForTags(xml, "normalization constant", Double.TYPE);
        this.lnZ = Math.log(this.Z);
        this.constraints = XMLParser.extractObjectForTags(xml, "constraints", MEMConstraint[].class);
        xml = XMLParser.extractForTag(xml, "conditions");
        this.cond = xml == null ? (int[][])null : XMLParser.extractObjectForTags(xml, "cond", int[][].class);
    }

    public MEM clone() throws CloneNotSupportedException {
        MEM clone = (MEM)super.clone();
        int i = 0;
        clone.constraints = (MEMConstraint[])ArrayHandler.clone((Cloneable[])this.constraints);
        clone.indices = (int[])this.indices.clone();
        clone.alphLen = (int[])this.alphLen.clone();
        if (this.cond != null) {
            clone.cond = new int[this.cond.length][];
            for (i = 0; i < this.constraints.length; ++i) {
                clone.cond[i] = (int[])this.cond[i].clone();
            }
        }
        return clone;
    }

    public double getScoreFor(Sequence seq, int start) {
        double erg = this.constraints[0].getExpLambda(this.constraints[0].satisfiesSpecificConstraint(seq, start));
        for (int i = 1; i < this.constraints.length; ++i) {
            erg *= this.constraints[i].getExpLambda(this.constraints[i].satisfiesSpecificConstraint(seq, start));
        }
        return erg / this.Z;
    }

    public double getLogScoreFor(Sequence seq, int start) {
        double erg = this.constraints[0].getLambda(this.constraints[0].satisfiesSpecificConstraint(seq, start));
        for (int i = 1; i < this.constraints.length; ++i) {
            erg += this.constraints[i].getLambda(this.constraints[i].satisfiesSpecificConstraint(seq, start));
        }
        return erg - this.lnZ;
    }

    public double getLogPriorPart(double ess) {
        double res = 0.0;
        for (int i = 0; i < this.constraints.length; ++i) {
            int k = this.constraints[i].getNumberOfSpecificConstraints();
            double hyper = ess / (double)k;
            for (int j = 0; j < k; ++j) {
                res += hyper * this.constraints[i].getLambda(j);
            }
        }
        return res - ess * Math.log(this.Z);
    }

    public String toString(NumberFormat nf) {
        return Arrays.toString(this.indices);
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer erg = new StringBuffer(500 * this.constraints.length);
        XMLParser.appendObjectWithTags(erg, this.indices, "used position");
        XMLParser.appendObjectWithTags(erg, this.alphLen, "alphLen");
        XMLParser.appendObjectWithTags(erg, this.Z, "normalization constant");
        XMLParser.appendObjectWithTags(erg, this.constraints, "constraints");
        if (this.cond != null) {
            StringBuffer b = new StringBuffer(500);
            XMLParser.appendObjectWithTags(b, this.cond, "cond");
            XMLParser.addTags(b, "conditions");
            erg.append(b);
        }
        XMLParser.addTags(erg, XML_TAG);
        return erg;
    }

    public void train(SequenceIterator s, byte algo, TerminationCondition condition, SafeOutputStream sostream) throws Exception {
        this.Z = MEMTools.train(this.constraints, this.cond, s, algo, condition, sostream, this.alphLen);
        this.lnZ = Math.log(this.Z);
    }
}

