/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.discrete;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.sequences.MultiDimensionalDiscreteSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.SamplingEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.discrete.DiscreteEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.phylo.PhyloNode;
import de.jstacs.sequenceScores.statisticalModels.trainable.phylo.PhyloTree;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.naming.OperationNotSupportedException;

public class PhyloDiscreteEmission
extends DiscreteEmission
implements SamplingEmission {
    private PhyloTree tree;
    private double[][] pruningMatrix;
    private HashMap<Integer, ArrayList<PhyloNode>> treeLayers;
    private double logProbFromStatistic;
    private static final String XML_TAG = "PhyloDiscreteEmission";

    public PhyloDiscreteEmission(AlphabetContainer con, double ess, PhyloTree t) {
        this(con, PhyloDiscreteEmission.getHyperParams(ess, (int)con.getAlphabetLengthAt(0)), t);
    }

    public PhyloDiscreteEmission(AlphabetContainer con, double[] hyperParams, PhyloTree t) {
        super(con, hyperParams);
        this.tree = t;
        this.setTreeLayers();
    }

    @Override
    public PhyloDiscreteEmission clone() throws CloneNotSupportedException {
        PhyloDiscreteEmission clone = (PhyloDiscreteEmission)super.clone();
        clone.tree = this.tree.clone();
        if (this.pruningMatrix != null) {
            clone.pruningMatrix = (double[][])ArrayHandler.clone((Cloneable[])this.pruningMatrix);
        }
        clone.logProbFromStatistic = this.logProbFromStatistic;
        clone.treeLayers = (HashMap)this.treeLayers.clone();
        return clone;
    }

    private static double[] getHyperParams(double ess, int number) {
        double[] res = new double[number];
        Arrays.fill(res, ess / (double)number);
        return res;
    }

    @Override
    public double getLogProbFor(boolean forward, int startPos, int endPos, Sequence seq) throws OperationNotSupportedException {
        for (int pos = startPos; pos <= endPos; ++pos) {
            this.fillPruningMatrix(pos, seq);
        }
        return Normalisation.getLogSum(this.pruningMatrix[0]);
    }

    @Override
    public double getLogProbAndPartialDerivationFor(boolean forward, int startPos, int endPos, IntList indices, DoubleList partDer, Sequence seq) throws OperationNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] gradient, int offset) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void estimateFromStatistic() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void appendFurtherInformation(StringBuffer xml) {
        XMLParser.appendObjectWithTags(xml, this.pruningMatrix, "pruningMatrix");
        XMLParser.appendObjectWithTags(xml, this.logProbFromStatistic, "logProbFromStatistic");
        XMLParser.appendObjectWithTags(xml, this.tree, "PhyloTree");
    }

    @Override
    protected void extractFurtherInformation(StringBuffer xml) throws NonParsableException {
        this.pruningMatrix = (double[][])XMLParser.extractObjectForTags(xml, "pruningMatrix");
        this.logProbFromStatistic = (Double)XMLParser.extractObjectForTags(xml, "logProbFromStatistic");
        this.tree = (PhyloTree)XMLParser.extractObjectForTags(xml, "PhyloTree");
        this.setTreeLayers();
    }

    private void fillPruningMatrix(int pos, Sequence seq) {
        HashMap hm = new HashMap();
        int alphabetSize = (int)this.con.getMaximalAlphabetLength();
        this.pruningMatrix = new double[this.tree.getNumberOfNodes()][alphabetSize];
        int[] alignment = (int[])seq.getEmptyContainer();
        seq.fillContainer(alignment, pos);
        SequenceAnnotation[][] annot = ((MultiDimensionalDiscreteSequence)seq).getAnnotations();
        double[] tmp = new double[alphabetSize];
        for (int l = this.treeLayers.size() - 1; l >= 0; --l) {
            ArrayList<PhyloNode> tmpNodes = this.treeLayers.get(l);
            for (PhyloNode n : tmpNodes) {
                ArrayList<PhyloNode> children = n.getChildrenNodes();
                if (children.size() > 0) {
                    int a = 0;
                    while (a < alphabetSize) {
                        for (int b = 0; b < alphabetSize; ++b) {
                            tmp[b] = a == b ? Math.log(1.0 - n.getWeight() + n.getWeight() * this.probs[0][a]) : Math.log(n.getWeight() * this.probs[0][a]);
                            for (int c = 0; c < children.size(); ++c) {
                                int n2 = b;
                                tmp[n2] = tmp[n2] + this.pruningMatrix[children.get(c).getId()][b];
                            }
                        }
                        double[] dArray = this.pruningMatrix[n.getId()];
                        int n3 = a++;
                        dArray[n3] = dArray[n3] + Normalisation.getLogSum(tmp);
                    }
                    continue;
                }
                for (int s = 0; s < alignment.length; ++s) {
                    if (!annot[s][0].getIdentifier().equals(n.getName())) continue;
                    for (int a = 0; a < alphabetSize; ++a) {
                        this.pruningMatrix[n.getId()][a] = alignment[s] == a ? Math.log(1.0 - n.getWeight() + n.getWeight() * this.probs[0][a]) : Math.log(n.getWeight() * this.probs[0][a]);
                    }
                }
            }
        }
    }

    public double getLogProposalPosteriorFromStatistic() {
        return super.getLogPosteriorFromStatistic();
    }

    @Override
    public double getLogPosteriorFromStatistic() {
        return this.logProbFromStatistic + this.getLogPriorTerm();
    }

    @Override
    public void resetStatistic() {
        super.resetStatistic();
        this.logProbFromStatistic = 0.0;
    }

    @Override
    public void addToStatistic(boolean forward, int startPos, int endPos, double weight, Sequence seq) throws OperationNotSupportedException {
        int e;
        int s;
        Sequence current;
        int[] alignment = (int[])seq.getEmptyContainer();
        if (forward) {
            current = seq;
            s = startPos;
            e = endPos;
        } else {
            current = seq.reverseComplement();
            int len = current.getLength();
            s = len - endPos - 1;
            e = len - startPos - 1;
        }
        while (s <= e) {
            current.fillContainer(alignment, s);
            for (int i = 0; i < alignment.length; ++i) {
                double[] dArray = this.statistic[0];
                int n = alignment[i];
                dArray[n] = dArray[n] + weight;
            }
            ++s;
        }
        this.logProbFromStatistic += this.getLogProbFor(forward, startPos, endPos, seq);
    }

    private void setTreeLayers() {
        this.treeLayers = new HashMap();
        ArrayList<PhyloNode> nodeList = new ArrayList<PhyloNode>();
        PhyloNode root = this.tree.getRoot();
        root.setWeight(1.0);
        nodeList.add(root);
        int layer = 0;
        while (nodeList.size() > 0) {
            this.treeLayers.put(layer, nodeList);
            nodeList = new ArrayList();
            for (PhyloNode n : this.treeLayers.get(layer)) {
                nodeList.addAll(n.getChildrenNodes());
            }
            ++layer;
        }
    }

    @Override
    public double getLogGammaScoreFromStatistic() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

