/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BPTreeChildNodeItem;
import org.broad.igv.bbfile.BPTreeNode;
import org.broad.igv.bbfile.BPTreeNodeItem;

public class BPTreeChildNode
implements BPTreeNode {
    private static Logger log = Logger.getLogger(BPTreeChildNode.class);
    private final boolean isLeafNode = false;
    private long nodeIndex;
    String lowestChromKey;
    String highestChromKey;
    int lowestChromID;
    int highestChromID;
    private ArrayList<BPTreeChildNodeItem> childItems;

    public BPTreeChildNode(long l) {
        this.nodeIndex = l;
        this.childItems = new ArrayList();
    }

    @Override
    public long getNodeIndex() {
        return this.nodeIndex;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean insertItem(BPTreeNodeItem bPTreeNodeItem) {
        this.childItems.add((BPTreeChildNodeItem)bPTreeNodeItem);
        BPTreeNode bPTreeNode = ((BPTreeChildNodeItem)bPTreeNodeItem).getChildNode();
        if (this.childItems.size() == 1) {
            this.lowestChromKey = bPTreeNode.getLowestChromKey();
            this.lowestChromID = bPTreeNode.getLowestChromID();
        } else {
            this.highestChromKey = bPTreeNode.getHighestChromKey();
            this.highestChromID = bPTreeNode.getHighestChromID();
        }
        return true;
    }

    @Override
    public boolean deleteItem(int n) {
        if (n < 0 || n >= this.getItemCount()) {
            return false;
        }
        this.childItems.remove(n);
        return true;
    }

    @Override
    public int getItemCount() {
        return this.childItems.size();
    }

    @Override
    public BPTreeNodeItem getItem(int n) {
        int n2 = this.getItemCount();
        if (n >= n2) {
            return null;
        }
        return this.childItems.get(n);
    }

    @Override
    public String getLowestChromKey() {
        if (this.childItems.size() > 0) {
            return this.lowestChromKey;
        }
        return null;
    }

    @Override
    public String getHighestChromKey() {
        if (this.childItems.size() > 0) {
            return this.highestChromKey;
        }
        return null;
    }

    @Override
    public int getLowestChromID() {
        if (this.childItems.size() > 0) {
            return this.lowestChromID;
        }
        return -1;
    }

    @Override
    public int getHighestChromID() {
        if (this.childItems.size() > 0) {
            return this.highestChromID;
        }
        return -1;
    }

    @Override
    public void printItems() {
        int n = this.getItemCount();
        log.debug((Object)("Child node " + this.nodeIndex + " contains " + n + " child items:"));
        for (int i = 0; i < n; ++i) {
            this.childItems.get(i).print();
        }
    }

    public ArrayList<BPTreeChildNodeItem> getChildItems() {
        return this.childItems;
    }
}

