/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BBCompressionUtils;
import org.broad.igv.bbfile.BedFeature;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTreeLeafNodeItem;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.SeekableStream;

public class BigBedDataBlock {
    private static Logger log = Logger.getLogger(BigBedDataBlock.class);
    private SeekableStream fis;
    private long fileOffset;
    private long dataBlockSize;
    private boolean isLowToHigh;
    private HashMap<Integer, String> chromosomeMap;
    private RPTreeLeafNodeItem leafHitItem;
    private byte[] bedBuffer;
    private int remDataSize;
    private long dataSizeRead;
    private LittleEndianInputStream lbdis;
    private DataInputStream dis;
    private ArrayList<BedFeature> bedFeatureList;
    private int nItemsSelected;

    public BigBedDataBlock(SeekableStream seekableStream, RPTreeLeafNodeItem rPTreeLeafNodeItem, HashMap<Integer, String> hashMap, boolean bl, int n) {
        this.fis = seekableStream;
        this.leafHitItem = rPTreeLeafNodeItem;
        this.chromosomeMap = hashMap;
        this.isLowToHigh = bl;
        this.dataBlockSize = this.leafHitItem.geDataSize();
        byte[] byArray = new byte[(int)this.dataBlockSize];
        this.fileOffset = this.leafHitItem.getDataOffset();
        try {
            seekableStream.seek(this.fileOffset);
            seekableStream.readFully(byArray);
            this.bedBuffer = n > 0 ? BBCompressionUtils.decompress(byArray, n) : byArray;
        }
        catch (IOException iOException) {
            String string = String.format("Error reading Bed data for leaf item %d \n", new Object[0]);
            log.error((Object)string, (Throwable)iOException);
            throw new RuntimeException(string, iOException);
        }
        if (this.isLowToHigh) {
            this.lbdis = new LittleEndianInputStream(new ByteArrayInputStream(this.bedBuffer));
        } else {
            this.dis = new DataInputStream(new ByteArrayInputStream(this.bedBuffer));
        }
        this.remDataSize = this.bedBuffer.length;
    }

    public ArrayList<BedFeature> getBedData(RPChromosomeRegion rPChromosomeRegion, boolean bl) {
        block8: {
            int n = 0;
            int n2 = 13;
            this.bedFeatureList = new ArrayList();
            RPChromosomeRegion rPChromosomeRegion2 = new RPChromosomeRegion(this.leafHitItem.getChromosomeBounds());
            int n3 = rPChromosomeRegion2.compareRegions(rPChromosomeRegion);
            try {
                int n4 = 0;
                while (this.remDataSize > 0) {
                    BedFeature bedFeature;
                    String string;
                    String string2;
                    int n5;
                    int n6;
                    int n7;
                    n = n4 + 1;
                    if (this.isLowToHigh) {
                        n7 = this.lbdis.readInt();
                        n6 = this.lbdis.readInt();
                        n5 = this.lbdis.readInt();
                        string2 = this.lbdis.readString();
                    } else {
                        n7 = this.dis.readInt();
                        n6 = this.dis.readInt();
                        n5 = this.dis.readInt();
                        string2 = this.dis.readUTF();
                    }
                    if (n3 == 0) {
                        string = this.chromosomeMap.get(n7);
                        bedFeature = new BedFeature(n, string, n6, n5, string2);
                        this.bedFeatureList.add(bedFeature);
                    } else {
                        rPChromosomeRegion2 = new RPChromosomeRegion(n7, n6, n7, n5);
                        int n8 = rPChromosomeRegion2.compareRegions(rPChromosomeRegion);
                        if (!bl && Math.abs(n8) < 2 || n8 == 0) {
                            string = this.chromosomeMap.get(n7);
                            bedFeature = new BedFeature(n, string, n6, n5, string2);
                            this.bedFeatureList.add(bedFeature);
                        }
                    }
                    this.remDataSize -= n2 + string2.length();
                    ++n4;
                }
            }
            catch (IOException iOException) {
                log.error((Object)("Read error for Bed data item " + n));
                if (n != 1) break block8;
                throw new RuntimeException("Read error for Bed data item " + n);
            }
        }
        return this.bedFeatureList;
    }

    public void print() {
        log.debug((Object)("BigBed data for " + this.bedFeatureList.size() + " items"));
        for (int i = 0; i <= this.bedFeatureList.size(); ++i) {
            this.bedFeatureList.get(i).print();
        }
    }
}

