/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BPTree;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTree;
import org.broad.igv.bbfile.RPTreeLeafNodeItem;
import org.broad.igv.bbfile.ZoomDataBlock;
import org.broad.igv.bbfile.ZoomDataRecord;
import org.broad.tribble.util.SeekableStream;

public class ZoomLevelIterator {
    private static Logger log = Logger.getLogger(ZoomDataBlock.class);
    private boolean empty = false;
    private int zoomLevel;
    private RPChromosomeRegion selectionRegion;
    private boolean isContained;
    private RPChromosomeRegion hitRegion;
    private SeekableStream fis;
    private BPTree chromIDTree;
    private RPTree zoomDataTree;
    private ArrayList<RPTreeLeafNodeItem> leafHitList;
    private HashMap<Integer, String> chromosomeMap;
    private int leafItemIndex;
    RPTreeLeafNodeItem leafHitItem;
    ZoomDataBlock zoomDataBlock;
    private boolean dataBlockRead;
    ArrayList<ZoomDataRecord> zoomRecordList;
    private int zoomRecordIndex;

    public ZoomLevelIterator() {
    }

    public ZoomLevelIterator(SeekableStream seekableStream, BPTree bPTree, RPTree rPTree, int n, RPChromosomeRegion rPChromosomeRegion, boolean bl) {
        if (rPChromosomeRegion == null) {
            throw new RuntimeException("Error: ZoomLevelIterator selection region is null\n");
        }
        this.fis = seekableStream;
        this.chromIDTree = bPTree;
        this.zoomDataTree = rPTree;
        this.zoomLevel = n;
        this.selectionRegion = rPChromosomeRegion;
        this.isContained = bl;
        int n2 = this.getHitRegion(rPChromosomeRegion, bl);
        if (n2 == 0) {
            this.empty = true;
        }
    }

    public boolean hasNext() {
        if (this.empty) {
            return false;
        }
        if (this.zoomRecordIndex < this.zoomRecordList.size()) {
            return true;
        }
        return this.leafItemIndex < this.leafHitList.size();
    }

    public ZoomDataRecord next() {
        if (this.zoomRecordIndex < this.zoomRecordList.size()) {
            return this.zoomRecordList.get(this.zoomRecordIndex++);
        }
        int n = this.getHitRegion(this.selectionRegion, this.isContained);
        if (n > 0) {
            return this.zoomRecordList.get(this.zoomRecordIndex++);
        }
        String string = String.format("Failed to find data for zoom region (%d,%d,%d,%d)\n", this.hitRegion.getStartChromID(), this.hitRegion.getStartBase(), this.hitRegion.getEndChromID(), this.hitRegion.getEndBase());
        log.error((Object)string);
        return null;
    }

    public void remove() {
        throw new UnsupportedOperationException("Remove iterator item is not supported yet.");
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public RPChromosomeRegion getSelectionRegion() {
        return this.selectionRegion;
    }

    public int setSelectionRegion(RPChromosomeRegion rPChromosomeRegion, boolean bl) {
        this.selectionRegion = rPChromosomeRegion;
        this.isContained = bl;
        this.leafHitList = null;
        int n = this.getHitRegion(rPChromosomeRegion, bl);
        if (n == 0) {
            throw new RuntimeException("No wig data found in the selection region");
        }
        return n;
    }

    public boolean isContained() {
        return this.isContained;
    }

    public SeekableStream getBBFis() {
        return this.fis;
    }

    public BPTree getChromosomeIDTree() {
        return this.chromIDTree;
    }

    public RPTree getZoomDataTree() {
        return this.zoomDataTree;
    }

    private int getHitRegion(RPChromosomeRegion rPChromosomeRegion, boolean bl) {
        int n = 0;
        if (this.leafHitList == null ? (n = this.getHitList(rPChromosomeRegion, bl)) == 0 : (n = this.leafHitList.size() - this.leafItemIndex) == 0) {
            return 0;
        }
        this.dataBlockRead = this.getDataBlock(this.leafItemIndex++);
        if (!this.dataBlockRead) {
            n = this.getHitRegion(rPChromosomeRegion, bl);
        }
        return n;
    }

    private int getHitList(RPChromosomeRegion rPChromosomeRegion, boolean bl) {
        this.leafHitList = this.zoomDataTree.getChromosomeDataHits(rPChromosomeRegion, bl);
        int n = this.leafHitList.size();
        if (n == 0) {
            return 0;
        }
        this.leafItemIndex = 0;
        int n2 = this.leafHitList.get(0).getChromosomeBounds().getStartChromID();
        int n3 = this.leafHitList.get(0).getChromosomeBounds().getStartBase();
        int n4 = this.leafHitList.get(n - 1).getChromosomeBounds().getEndChromID();
        int n5 = this.leafHitList.get(n - 1).getChromosomeBounds().getEndBase();
        this.hitRegion = new RPChromosomeRegion(n2, n3, n4, n5);
        return n;
    }

    private boolean getDataBlock(int n) {
        if (this.leafHitList == null || n >= this.leafHitList.size()) {
            return false;
        }
        this.leafHitItem = this.leafHitList.get(n);
        int n2 = this.leafHitItem.getChromosomeBounds().getStartChromID();
        int n3 = this.leafHitItem.getChromosomeBounds().getEndChromID();
        this.chromosomeMap = this.chromIDTree.getChromosomeIDMap(n2, n3);
        boolean bl = this.zoomDataTree.isIsLowToHigh();
        int n4 = this.zoomDataTree.getUncompressBuffSize();
        this.zoomDataBlock = new ZoomDataBlock(this.zoomLevel, this.fis, this.leafHitItem, this.chromosomeMap, bl, n4);
        this.zoomRecordList = this.zoomDataBlock.getZoomData(this.selectionRegion, this.isContained);
        this.zoomRecordIndex = 0;
        return this.zoomRecordList.size() > 0;
    }

    public static class EmptyIterator
    extends ZoomLevelIterator {
        static EmptyIterator theInstance = new EmptyIterator();

        @Override
        public boolean hasNext() {
            return false;
        }
    }
}

