/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.SeekableStream;

public class BBFileHeader {
    private static Logger log = Logger.getLogger(BBFileHeader.class);
    public static final int BBFILE_HEADER_SIZE = 64;
    public static final int BIGWIG_MAGIC_LTH = -2003829722;
    public static final int BIGWIG_MAGIC_HTL = 654085990;
    public static final int BIGBED_MAGIC_LTH = -2021002517;
    public static final int BIGBED_MAGIC_HTL = -336426617;
    private String path;
    private SeekableStream fis;
    private long fileHeaderOffset;
    private boolean isHeaderOK;
    private boolean isLowToHigh;
    private boolean isBigBed;
    private boolean isBigWig;
    private int magic;
    private short version;
    private short nZoomLevels;
    private long chromTreeOffset;
    private long fullDataOffset;
    private long fullIndexOffset;
    private short fieldCount;
    private short definedFieldCount;
    private long autoSqlOffset;
    private long totalSummaryOffset;
    private int uncompressBuffSize;
    private long reserved;

    public BBFileHeader(String string, SeekableStream seekableStream, long l) {
        this.path = string;
        this.fis = seekableStream;
        this.fileHeaderOffset = l;
        this.isHeaderOK = this.readBBFileHeader(this.fileHeaderOffset);
    }

    public BBFileHeader(int n, short s, short s2, long l, long l2, long l3, short s3, short s4, long l4, long l5, int n2, long l6) {
        this.magic = n;
        if (this.isBigWig() || this.isBigBed()) {
            this.isHeaderOK = true;
        }
        this.version = s;
        this.nZoomLevels = s2;
        this.chromTreeOffset = l;
        this.fullDataOffset = l2;
        this.fullIndexOffset = l3;
        this.fieldCount = s3;
        this.definedFieldCount = s4;
        this.autoSqlOffset = l4;
        this.totalSummaryOffset = l5;
        this.uncompressBuffSize = n2;
        this.uncompressBuffSize = n2;
        this.reserved = l6;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isHeaderOK() {
        return this.isHeaderOK;
    }

    public boolean isLowToHigh() {
        return this.isLowToHigh;
    }

    public boolean isBigBed() {
        return this.isBigBed;
    }

    public boolean isBigWig() {
        return this.isBigWig;
    }

    public int getFileHeaderSize() {
        return 64;
    }

    public int getMagic() {
        return this.magic;
    }

    public short getVersion() {
        return this.version;
    }

    public short getZoomLevels() {
        return this.nZoomLevels;
    }

    public long getChromosomeTreeOffset() {
        return this.chromTreeOffset;
    }

    public long getFullDataOffset() {
        return this.fullDataOffset;
    }

    public long getFullIndexOffset() {
        return this.fullIndexOffset;
    }

    public short getFieldCount() {
        return this.fieldCount;
    }

    public short getDefinedFieldCount() {
        return this.definedFieldCount;
    }

    public long getAutoSqlOffset() {
        return this.autoSqlOffset;
    }

    public long getTotalSummaryOffset() {
        return this.totalSummaryOffset;
    }

    public int getUncompressBuffSize() {
        return this.uncompressBuffSize;
    }

    public void print() {
        if (this.isHeaderOK) {
            if (this.isBigWig()) {
                System.out.println("BigWig file " + this.path + ", file header at location " + this.fileHeaderOffset);
            } else if (this.isBigBed()) {
                System.out.println("BigBed file " + this.path + ", file header at location " + this.fileHeaderOffset);
            }
        } else {
            System.out.println("BBFile " + this.path + "  with bad magic = " + this.magic + " from file header location " + this.fileHeaderOffset);
            return;
        }
        System.out.println("BBFile header magic = " + this.magic);
        System.out.println("Version = " + this.version);
        System.out.println("Zoom Levels = " + this.nZoomLevels);
        System.out.println("Chromosome Info B+ tree offset = " + this.chromTreeOffset);
        System.out.println("Data Block offset = " + this.fullDataOffset);
        System.out.println("Chromosome Data R+ tree offset = " + this.fullIndexOffset);
        System.out.println("Bed fields count = " + this.fieldCount);
        System.out.println("Bed defined fields count = " + this.definedFieldCount);
        System.out.println("AutoSql Offset = " + this.autoSqlOffset);
        System.out.println("Total Summary offset = " + this.totalSummaryOffset);
        System.out.println("Maximum uncompressed buffer size = " + this.uncompressBuffSize);
        System.out.println("m_reserved = " + this.reserved);
    }

    private boolean readBBFileHeader(long l) {
        Object var3_2 = null;
        LittleEndianInputStream littleEndianInputStream = null;
        DataInputStream dataInputStream = null;
        byte[] byArray = new byte[64];
        try {
            this.fis.seek(l);
            this.fis.readFully(byArray);
            this.isLowToHigh = true;
            littleEndianInputStream = new LittleEndianInputStream(new ByteArrayInputStream(byArray));
            this.magic = littleEndianInputStream.readInt();
            if (this.magic == -2003829722) {
                this.isBigWig = true;
            } else if (this.magic == -2021002517) {
                this.isBigBed = true;
            } else {
                dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                this.magic = dataInputStream.readInt();
                if (this.magic == 654085990) {
                    this.isBigWig = true;
                } else if (this.magic == -336426617) {
                    this.isBigBed = true;
                } else {
                    return false;
                }
                this.isLowToHigh = false;
            }
            if (this.isLowToHigh) {
                this.version = littleEndianInputStream.readShort();
                this.nZoomLevels = littleEndianInputStream.readShort();
                this.chromTreeOffset = littleEndianInputStream.readLong();
                this.fullDataOffset = littleEndianInputStream.readLong();
                this.fullIndexOffset = littleEndianInputStream.readLong();
                this.fieldCount = littleEndianInputStream.readShort();
                this.definedFieldCount = littleEndianInputStream.readShort();
                this.autoSqlOffset = littleEndianInputStream.readLong();
                this.totalSummaryOffset = littleEndianInputStream.readLong();
                this.uncompressBuffSize = littleEndianInputStream.readInt();
                this.reserved = littleEndianInputStream.readLong();
            } else {
                this.version = dataInputStream.readShort();
                this.nZoomLevels = dataInputStream.readShort();
                this.chromTreeOffset = dataInputStream.readLong();
                this.fullDataOffset = dataInputStream.readLong();
                this.fullIndexOffset = dataInputStream.readLong();
                this.fieldCount = dataInputStream.readShort();
                this.definedFieldCount = dataInputStream.readShort();
                this.autoSqlOffset = dataInputStream.readLong();
                this.totalSummaryOffset = dataInputStream.readLong();
                this.uncompressBuffSize = dataInputStream.readInt();
                this.reserved = dataInputStream.readLong();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error reading file header for " + this.path, iOException);
        }
        return true;
    }
}

