/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BBZoomLevelFormat;
import org.broad.igv.bbfile.BBZoomLevelHeader;
import org.broad.igv.bbfile.RPTree;
import org.broad.tribble.util.SeekableStream;

public class BBZoomLevels {
    private static Logger log = Logger.getLogger(BBZoomLevels.class);
    private long zoomHeadersOffset;
    private int zoomLevelsCount;
    private ArrayList<BBZoomLevelHeader> zoomLevelHeaders;
    private ArrayList<BBZoomLevelFormat> zoomLevelFormatList;
    private ArrayList<RPTree> zoomLevelRPTree;

    public BBZoomLevels(SeekableStream seekableStream, long l, int n, boolean bl, int n2) {
        this.zoomHeadersOffset = l;
        this.zoomLevelsCount = n;
        int n3 = this.readZoomHeaders(seekableStream, this.zoomHeadersOffset, n, bl);
        if (n3 > 0) {
            int n4;
            this.zoomLevelFormatList = new ArrayList();
            for (n4 = 0; n4 < n3; ++n4) {
                int n5 = n4 + 1;
                long l2 = this.zoomLevelHeaders.get(n4).getDataOffset();
                long l3 = this.zoomLevelHeaders.get(n4).getIndexOffset() - l2 - 4L;
                BBZoomLevelFormat bBZoomLevelFormat = new BBZoomLevelFormat(n5, seekableStream, l2, l3, bl, n2);
                this.zoomLevelFormatList.add(bBZoomLevelFormat);
            }
            this.zoomLevelRPTree = new ArrayList();
            for (n4 = 0; n4 < n3; ++n4) {
                long l4 = this.zoomLevelHeaders.get(n4).getIndexOffset();
                RPTree rPTree = new RPTree(seekableStream, l4, bl, n2, true);
                this.zoomLevelRPTree.add(rPTree);
            }
        }
    }

    public long getZoomHeadersOffset() {
        return this.zoomHeadersOffset;
    }

    public int getZoomHeaderCount() {
        return this.zoomLevelHeaders.size();
    }

    public ArrayList<BBZoomLevelHeader> getZoomLevelHeaders() {
        return this.zoomLevelHeaders;
    }

    public BBZoomLevelHeader getZoomLevelHeader(int n) {
        if (n < 1 || n > this.zoomLevelsCount) {
            return null;
        }
        return this.zoomLevelHeaders.get(n - 1);
    }

    public ArrayList<BBZoomLevelFormat> getZoomLevelFormats() {
        return this.zoomLevelFormatList;
    }

    public RPTree getZoomLevelRPTree(int n) {
        if (n < 1 || n > this.zoomLevelsCount) {
            return null;
        }
        return this.zoomLevelRPTree.get(n - 1);
    }

    public void printZoomHeaders() {
        if (this.zoomLevelHeaders.size() == this.zoomLevelsCount) {
            log.debug((Object)("Zoom level headers read for " + this.zoomLevelsCount + " levels:"));
        } else {
            log.error((Object)("Zoom level headers not successfully read for " + this.zoomLevelsCount + "levels."));
        }
        for (int i = 0; i < this.zoomLevelHeaders.size(); ++i) {
            this.zoomLevelHeaders.get(i).print();
        }
    }

    private int readZoomHeaders(SeekableStream seekableStream, long l, int n, boolean bl) {
        int n2 = 0;
        if (n < 1) {
            return 0;
        }
        this.zoomLevelHeaders = new ArrayList();
        for (int i = 0; i < n; ++i) {
            n2 = i + 1;
            BBZoomLevelHeader bBZoomLevelHeader = new BBZoomLevelHeader(seekableStream, l, n2, bl);
            this.zoomLevelHeaders.add(bBZoomLevelHeader);
            l += 24L;
        }
        return n2;
    }
}

