/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BPTreeChildNode;
import org.broad.igv.bbfile.BPTreeChildNodeItem;
import org.broad.igv.bbfile.BPTreeHeader;
import org.broad.igv.bbfile.BPTreeLeafNode;
import org.broad.igv.bbfile.BPTreeLeafNodeItem;
import org.broad.igv.bbfile.BPTreeNode;
import org.broad.igv.bbfile.BPTreeNodeItem;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.SeekableStream;

public class BPTree {
    private static Logger log = Logger.getLogger(BPTree.class);
    public static final int BPTREE_NODE_FORMAT_SIZE = 4;
    public static final int BPTREE_NODE_ITEM_SIZE = 8;
    private SeekableStream fis;
    private long treeOffset;
    private BPTreeHeader treeHeader;
    private int blockSize;
    private int keySize;
    private int valueSize;
    private long itemCount;
    private BPTreeNode rootNode;
    private long nodeCount;
    private long leafCount;
    Map<String, String> chromosomeKeyCache = new HashMap<String, String>();

    public BPTree(SeekableStream seekableStream, long l, boolean bl) {
        this.fis = seekableStream;
        this.treeOffset = l;
        this.treeHeader = new BPTreeHeader(this.fis, this.treeOffset, bl);
        if (!this.treeHeader.isHeaderOK()) {
            int n = this.treeHeader.getMagic();
            log.error((Object)("Error reading B+ tree header: bad magic = " + n));
            throw new RuntimeException("Error reading B+ tree header: bad magic = " + n);
        }
        this.blockSize = this.treeHeader.getBlockSize();
        this.keySize = this.treeHeader.getKeySize();
        this.valueSize = this.treeHeader.getValSize();
        this.itemCount = this.treeHeader.getItemCount();
        long l2 = this.treeOffset + 32L;
        BPTreeNode bPTreeNode = null;
        this.rootNode = this.readBPTreeNode(this.fis, l2, bPTreeNode, bl);
    }

    public SeekableStream getFis() {
        return this.fis;
    }

    public long getBPTreeOffset() {
        return this.treeOffset;
    }

    public BPTreeHeader getTreeHeader() {
        return this.treeHeader;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public int getValueSize() {
        return this.valueSize;
    }

    public long getItemCount() {
        return this.itemCount;
    }

    public long getNodeCount() {
        return this.nodeCount;
    }

    public BPTreeNode getRootNode() {
        return this.rootNode;
    }

    public String getChromosomeKey(String string) {
        String string2 = this.chromosomeKeyCache.get(string);
        if (string2 == null) {
            char[] cArray = new char[this.keySize];
            char[] cArray2 = string.toCharArray();
            System.arraycopy(cArray2, 0, cArray, 0, Math.min(this.keySize, cArray2.length));
            string2 = new String(cArray);
            this.chromosomeKeyCache.put(string, string2);
        }
        return string2;
    }

    public int getChromosomeID(String string) {
        BPTreeNode bPTreeNode = this.rootNode;
        int n = this.findChromosomeID(bPTreeNode, string);
        return n;
    }

    public String getChromosomeName(int n) {
        BPTreeNode bPTreeNode = this.rootNode;
        String string = this.findChromosomeName(bPTreeNode, n);
        return string;
    }

    public ArrayList<String> getChromosomeNames() {
        BPTreeNode bPTreeNode = this.rootNode;
        ArrayList<String> arrayList = new ArrayList<String>();
        this.findAllChromosomeNames(bPTreeNode, arrayList);
        return arrayList;
    }

    public HashMap<Integer, String> getChromosomeIDMap(int n, int n2) {
        BPTreeNode bPTreeNode = this.rootNode;
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        this.findChromosomeMap(bPTreeNode, n, n2, hashMap);
        return hashMap;
    }

    public void print() {
        if (!this.treeHeader.isHeaderOK()) {
            int n = this.treeHeader.getMagic();
            log.error((Object)("Error reading B+ tree header: bad magic = " + n));
            return;
        }
        this.treeHeader.print();
        if (this.rootNode != null) {
            this.rootNode.printItems();
        }
    }

    private int findChromosomeID(BPTreeNode bPTreeNode, String string) {
        int n = -1;
        if (bPTreeNode.isLeaf()) {
            int n2 = bPTreeNode.getItemCount();
            for (int i = 0; i < n2; ++i) {
                BPTreeLeafNodeItem bPTreeLeafNodeItem = (BPTreeLeafNodeItem)bPTreeNode.getItem(i);
                if (bPTreeLeafNodeItem == null) {
                    log.error((Object)"Error finding B+ tree leaf nodes, corruption suspected");
                    throw new RuntimeException("Error reading B+ tree leaf nodes, corruption suspected");
                }
                if (!bPTreeLeafNodeItem.chromKeysMatch(string)) continue;
                n = bPTreeLeafNodeItem.getChromID();
                break;
            }
        } else {
            int n3 = bPTreeNode.getItemCount();
            for (int i = 0; i < n3; ++i) {
                BPTreeChildNodeItem bPTreeChildNodeItem = (BPTreeChildNodeItem)bPTreeNode.getItem(i);
                BPTreeNode bPTreeNode2 = bPTreeChildNodeItem.getChildNode();
                String string2 = bPTreeNode2.getLowestChromKey();
                String string3 = bPTreeNode2.getHighestChromKey();
                if (string.compareTo(string2) < 0 || string.compareTo(string3) > 0 || (n = this.findChromosomeID(bPTreeNode2, string)) < 0) {
                    continue;
                }
                break;
            }
        }
        return n;
    }

    private String findChromosomeName(BPTreeNode bPTreeNode, int n) {
        String string = null;
        if (bPTreeNode.isLeaf()) {
            int n2 = bPTreeNode.getItemCount();
            for (int i = 0; i < n2; ++i) {
                BPTreeLeafNodeItem bPTreeLeafNodeItem = (BPTreeLeafNodeItem)bPTreeNode.getItem(i);
                if (bPTreeLeafNodeItem.getChromID() != n) continue;
                string = bPTreeLeafNodeItem.getChromKey();
                break;
            }
        } else {
            int n3 = bPTreeNode.getItemCount();
            for (int i = 0; i < n3; ++i) {
                BPTreeChildNodeItem bPTreeChildNodeItem = (BPTreeChildNodeItem)bPTreeNode.getItem(i);
                BPTreeNode bPTreeNode2 = bPTreeChildNodeItem.getChildNode();
                int n4 = bPTreeNode2.getLowestChromID();
                int n5 = bPTreeNode2.getHighestChromID();
                if (n < n4 || n > n5 || (string = this.findChromosomeName(bPTreeNode2, n)) == null) {
                    continue;
                }
                break;
            }
        }
        return string;
    }

    public void findAllChromosomeNames(BPTreeNode bPTreeNode, ArrayList<String> arrayList) {
        if (bPTreeNode.isLeaf()) {
            int n = bPTreeNode.getItemCount();
            for (int i = 0; i < n; ++i) {
                BPTreeLeafNodeItem bPTreeLeafNodeItem = (BPTreeLeafNodeItem)bPTreeNode.getItem(i);
                arrayList.add(bPTreeLeafNodeItem.getChromKey());
            }
        } else {
            int n = bPTreeNode.getItemCount();
            for (int i = 0; i < n; ++i) {
                BPTreeChildNodeItem bPTreeChildNodeItem = (BPTreeChildNodeItem)bPTreeNode.getItem(i);
                BPTreeNode bPTreeNode2 = bPTreeChildNodeItem.getChildNode();
                this.findAllChromosomeNames(bPTreeNode2, arrayList);
            }
        }
    }

    private void findChromosomeMap(BPTreeNode bPTreeNode, int n, int n2, HashMap<Integer, String> hashMap) {
        int n3 = bPTreeNode.getLowestChromID();
        if (n3 > n2) {
            return;
        }
        int n4 = bPTreeNode.getHighestChromID();
        if (n4 < n) {
            return;
        }
        if (bPTreeNode.isLeaf()) {
            int n5 = bPTreeNode.getItemCount();
            for (int i = 0; i < n5; ++i) {
                BPTreeLeafNodeItem bPTreeLeafNodeItem = (BPTreeLeafNodeItem)bPTreeNode.getItem(i);
                int n6 = bPTreeLeafNodeItem.getChromID();
                if (n6 >= n && n6 <= n2) {
                    hashMap.put(n6, bPTreeLeafNodeItem.getChromKey());
                    continue;
                }
                if (n6 <= n2) {
                    continue;
                }
                break;
            }
        } else {
            int n7 = bPTreeNode.getItemCount();
            for (int i = 0; i < n7; ++i) {
                BPTreeChildNodeItem bPTreeChildNodeItem = (BPTreeChildNodeItem)bPTreeNode.getItem(i);
                BPTreeNode bPTreeNode2 = bPTreeChildNodeItem.getChildNode();
                n3 = bPTreeNode2.getLowestChromID();
                n4 = bPTreeNode2.getHighestChromID();
                if (n3 <= n2 && n4 >= n) {
                    this.findChromosomeMap(bPTreeNode2, n, n2, hashMap);
                    continue;
                }
                if (n3 <= n2) {
                    continue;
                }
                break;
            }
        }
    }

    private BPTreeNode readBPTreeNode(SeekableStream seekableStream, long l, BPTreeNode bPTreeNode, boolean bl) {
        LittleEndianInputStream littleEndianInputStream = null;
        DataInputStream dataInputStream = null;
        byte[] byArray = new byte[4];
        BPTreeNode bPTreeNode2 = null;
        BPTreeNode bPTreeNode3 = null;
        try {
            int n;
            byte by;
            boolean bl2;
            seekableStream.seek(l);
            seekableStream.readFully(byArray);
            if (bl) {
                littleEndianInputStream = new LittleEndianInputStream(new ByteArrayInputStream(byArray));
            } else {
                dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            }
            byte by2 = bl ? littleEndianInputStream.readByte() : dataInputStream.readByte();
            if (by2 == 1) {
                bl2 = true;
                bPTreeNode2 = new BPTreeLeafNode(++this.nodeCount);
            } else {
                bl2 = false;
                bPTreeNode2 = new BPTreeChildNode(++this.nodeCount);
            }
            if (bl) {
                by = littleEndianInputStream.readByte();
                n = littleEndianInputStream.readShort();
            } else {
                by = dataInputStream.readByte();
                n = dataInputStream.readShort();
            }
            int n2 = 8 + this.keySize;
            int n3 = n2 * n;
            byte[] byArray2 = new byte[n3];
            seekableStream.readFully(byArray2);
            if (bl) {
                littleEndianInputStream = new LittleEndianInputStream(new ByteArrayInputStream(byArray2));
            } else {
                dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray2));
            }
            for (int i = 0; i < n; ++i) {
                BPTreeNodeItem bPTreeNodeItem;
                char[] cArray = new char[this.keySize];
                for (int j = 0; j < this.keySize; ++j) {
                    by = bl ? littleEndianInputStream.readByte() : dataInputStream.readByte();
                    cArray[j] = (char)by;
                }
                String string = new String(cArray).trim();
                if (bl2) {
                    int n4;
                    int n5;
                    if (bl) {
                        n5 = littleEndianInputStream.readInt();
                        n4 = littleEndianInputStream.readInt();
                    } else {
                        n5 = dataInputStream.readInt();
                        n4 = dataInputStream.readInt();
                    }
                    bPTreeNodeItem = new BPTreeLeafNodeItem(++this.leafCount, string, n5, n4);
                    bPTreeNode2.insertItem(bPTreeNodeItem);
                } else {
                    long l2 = bl ? littleEndianInputStream.readLong() : dataInputStream.readLong();
                    bPTreeNode3 = this.readBPTreeNode(this.fis, l2, bPTreeNode2, bl);
                    bPTreeNodeItem = new BPTreeChildNodeItem(i, string, bPTreeNode3);
                    bPTreeNode2.insertItem(bPTreeNodeItem);
                }
                l += (long)n2;
            }
        }
        catch (IOException iOException) {
            log.error((Object)("Error reading B+ tree node " + iOException));
            throw new RuntimeException("Error reading B+ tree node \n ", iOException);
        }
        return bPTreeNode2;
    }
}

