/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BBCompressionUtils;
import org.broad.igv.bbfile.BigWigSection;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTreeLeafNodeItem;
import org.broad.igv.bbfile.WigItem;
import org.broad.tribble.util.SeekableStream;

public class BigWigDataBlock {
    private static Logger log = Logger.getLogger(BigWigDataBlock.class);
    final int FIXED_STEP_ITEM_SIZE = 4;
    final int VAR_STEP_ITEM_SIZE = 8;
    final int BED_GRAPH_ITEM_SIZE = 12;
    private long fileOffset;
    private long leafDataSize;
    private boolean isLowToHigh;
    private HashMap<Integer, String> chromosomeMap;
    private RPTreeLeafNodeItem leafHitItem;
    private byte[] wigBuffer;
    private int remDataSize;
    private ArrayList<WigItem> wigItemList;

    public BigWigDataBlock(SeekableStream seekableStream, RPTreeLeafNodeItem rPTreeLeafNodeItem, HashMap<Integer, String> hashMap, boolean bl, int n) {
        this.leafHitItem = rPTreeLeafNodeItem;
        this.chromosomeMap = hashMap;
        this.isLowToHigh = bl;
        this.fileOffset = this.leafHitItem.getDataOffset();
        this.leafDataSize = this.leafHitItem.geDataSize();
        byte[] byArray = new byte[(int)this.leafDataSize];
        try {
            seekableStream.seek(this.fileOffset);
            seekableStream.readFully(byArray);
            this.wigBuffer = n > 0 ? BBCompressionUtils.decompress(byArray, n) : byArray;
        }
        catch (IOException iOException) {
            log.error((Object)"Error reading Wig section for leaf item ", (Throwable)iOException);
            String string = String.format("Error reading Wig section for leaf item %d\n", new Object[0]);
            throw new RuntimeException(string, iOException);
        }
        this.remDataSize = this.wigBuffer.length;
    }

    public ArrayList<WigItem> getWigData(RPChromosomeRegion rPChromosomeRegion, boolean bl) {
        this.wigItemList = new ArrayList();
        int n = 0;
        while (this.remDataSize > 0) {
            BigWigSection bigWigSection = new BigWigSection(this.wigBuffer, this.chromosomeMap, this.isLowToHigh, this.leafHitItem);
            int n2 = bigWigSection.getSectionData(rPChromosomeRegion, bl, this.wigItemList);
            this.remDataSize -= n2;
            ++n;
        }
        return this.wigItemList;
    }

    public void print() {
        log.debug((Object)"Wig section data referenced by leaf item ");
        for (int i = 0; i <= this.wigItemList.size(); ++i) {
            this.wigItemList.get(i).print();
        }
    }
}

