/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.InputResource;
import htsjdk.samtools.seekablestream.SeekablePathStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.sra.SRAAccession;
import htsjdk.samtools.util.Lazy;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;

class PathInputResource
extends InputResource {
    final Path pathResource;
    final Lazy<SeekableStream> lazySeekableStream = new Lazy<SeekableStream>(new Lazy.LazyInitializer<SeekableStream>(){

        @Override
        public SeekableStream make() {
            try {
                return new SeekablePathStream(PathInputResource.this.pathResource);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
    });

    PathInputResource(Path pathResource) {
        super(InputResource.Type.PATH);
        this.pathResource = pathResource;
    }

    @Override
    public File asFile() {
        try {
            return this.asPath().toFile();
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    @Override
    public Path asPath() {
        return this.pathResource;
    }

    @Override
    public URL asUrl() {
        try {
            return this.asPath().toUri().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public SeekableStream asUnbufferedSeekableStream() {
        return this.lazySeekableStream.get();
    }

    @Override
    public InputStream asUnbufferedInputStream() {
        return this.asUnbufferedSeekableStream();
    }

    @Override
    public SRAAccession asSRAAccession() {
        return null;
    }
}

