/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordComparator;
import htsjdk.samtools.SAMTag;
import java.io.Serializable;

public class SAMRecordQueryNameComparator
implements SAMRecordComparator,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public int compare(SAMRecord samRecord1, SAMRecord samRecord2) {
        int cmp = this.fileOrderCompare(samRecord1, samRecord2);
        if (cmp != 0) {
            return cmp;
        }
        boolean r1Paired = samRecord1.getReadPairedFlag();
        boolean r2Paired = samRecord2.getReadPairedFlag();
        if (r1Paired || r2Paired) {
            if (!r1Paired) {
                return 1;
            }
            if (!r2Paired) {
                return -1;
            }
            if (samRecord1.getFirstOfPairFlag() && samRecord2.getSecondOfPairFlag()) {
                return -1;
            }
            if (samRecord1.getSecondOfPairFlag() && samRecord2.getFirstOfPairFlag()) {
                return 1;
            }
        }
        if (samRecord1.getReadNegativeStrandFlag() != samRecord2.getReadNegativeStrandFlag()) {
            return samRecord1.getReadNegativeStrandFlag() ? 1 : -1;
        }
        if (samRecord1.getNotPrimaryAlignmentFlag() != samRecord2.getNotPrimaryAlignmentFlag()) {
            return samRecord2.getNotPrimaryAlignmentFlag() ? -1 : 1;
        }
        if (samRecord1.getSupplementaryAlignmentFlag() != samRecord2.getSupplementaryAlignmentFlag()) {
            return samRecord2.getSupplementaryAlignmentFlag() ? -1 : 1;
        }
        Integer hitIndex1 = samRecord1.getIntegerAttribute(SAMTag.HI.name());
        Integer hitIndex2 = samRecord2.getIntegerAttribute(SAMTag.HI.name());
        if (hitIndex1 != null) {
            if (hitIndex2 == null) {
                return 1;
            }
            cmp = hitIndex1.compareTo(hitIndex2);
            if (cmp != 0) {
                return cmp;
            }
        } else if (hitIndex2 != null) {
            return -1;
        }
        return 0;
    }

    @Override
    public int fileOrderCompare(SAMRecord samRecord1, SAMRecord samRecord2) {
        return SAMRecordQueryNameComparator.compareReadNames(samRecord1.getReadName(), samRecord2.getReadName());
    }

    public static int compareReadNames(String readName1, String readName2) {
        return readName1.compareTo(readName2);
    }
}

