/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;

public abstract class SimpleDiscreteSequence
extends Sequence<int[]> {
    public SimpleDiscreteSequence(AlphabetContainer container, SequenceAnnotation[] annotation) throws WrongAlphabetException {
        super(container, annotation);
        if (!container.isDiscrete()) {
            throw new WrongAlphabetException("The alphabet is not discrete.");
        }
    }

    @Override
    public final double continuousVal(int pos) {
        return this.discreteVal(pos);
    }

    @Override
    public boolean isMultiDimensional() {
        return false;
    }

    @Override
    public int[] getEmptyContainer() {
        return new int[1];
    }

    @Override
    public void fillContainer(int[] container, int pos) {
        container[0] = this.discreteVal(pos);
    }

    @Override
    protected Object getEmptyRepresentation() {
        return new StringBuffer();
    }

    @Override
    protected void addToRepresentation(Object representation, int pos, String delim) {
        ((StringBuffer)representation).append(String.valueOf(this.alphabetCon.getSymbol(pos, this.discreteVal(pos))) + delim);
    }

    @Override
    protected String getStringRepresentation(Object representation) {
        return representation.toString();
    }

    @Override
    protected int hashCodeForPos(int pos) {
        return this.discreteVal(pos);
    }

    @Override
    public int compareTo(int[] t1, int[] t2) {
        if (t1.length == t2.length) {
            int i = 0;
            while (i < t1.length) {
                if (t1[i] != t2[i]) {
                    return t1[i] - t2[i];
                }
                ++i;
            }
            return 0;
        }
        return t1.length - t2.length;
    }
}

