/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.motifDiscovery;

import de.jstacs.data.DeBruijnSequenceGenerator;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.io.ArrayHandler;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.ToolBox;
import projects.dispom.PFMComparator;

public class DeBruijnPFMDistance
extends PFMComparator.PFMDistance {
    private Sequence deBruijn;

    public DeBruijnPFMDistance(int n) throws WrongAlphabetException, WrongSequenceTypeException {
        this.deBruijn = DeBruijnSequenceGenerator.generate(DNAAlphabet.SINGLETON, n, 0);
    }

    @Override
    protected double getDistance(double[][] pfm1, double[][] pfm2, int l1, int l2) {
        try {
            double[] prof1 = this.getProfile(DeBruijnPFMDistance.getLogPwm(pfm1));
            double[] prof2 = this.getProfile(DeBruijnPFMDistance.getLogPwm(pfm2));
            return ToolBox.pearsonCorrelation(prof1, prof2, l1, l2);
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    @Override
    public double compare(double[][] pfm1, double[][] pfm2, int minimalOverlap) {
        try {
            double[] prof1 = this.getProfile(DeBruijnPFMDistance.getLogPwm(pfm1));
            double[] prof2 = this.getProfile(DeBruijnPFMDistance.getLogPwm(pfm2));
            return DeBruijnPFMDistance.compare(prof1, prof2, Math.max(pfm1.length, pfm2.length) - minimalOverlap);
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public static double compare(double[] profile, double[] profile2, int maximalShift) throws Exception {
        double corr = ToolBox.pearsonCorrelation(profile, profile2, 0, 0);
        int i = 1;
        while (i < maximalShift) {
            double temp = ToolBox.pearsonCorrelation(profile, profile2, 0, i);
            if (temp > corr) {
                corr = temp;
            }
            if ((temp = ToolBox.pearsonCorrelation(profile, profile2, i, 0)) > corr) {
                corr = temp;
            }
            ++i;
        }
        return corr;
    }

    private static double[][] getLogPwm(double[][] pfm) throws CloneNotSupportedException {
        double[][] pwm = (double[][])ArrayHandler.clone((Cloneable[])pfm);
        int i = 0;
        while (i < pwm.length) {
            int j = 0;
            while (j < pwm[i].length) {
                double[] dArray = pwm[i];
                int n = j++;
                dArray[n] = dArray[n] + 1.0;
            }
            Normalisation.sumNormalisation(pwm[i]);
            j = 0;
            while (j < pwm[i].length) {
                pwm[i][j] = Math.log(pwm[i][j]);
                ++j;
            }
            ++i;
        }
        return pwm;
    }

    private double[] getProfile(double[][] logPwm) {
        double[] prof = new double[this.deBruijn.getLength() - logPwm.length + 1];
        int i = 0;
        while (i < prof.length) {
            double sc = 0.0;
            int j = 0;
            while (j < logPwm.length) {
                sc += logPwm[j][this.deBruijn.discreteVal(i + j)];
                ++j;
            }
            prof[i] = sc;
            ++i;
        }
        return prof;
    }
}

