/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.motif;

import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.motif.DurationDiffSM;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.random.DirichletMRG;
import de.jstacs.utils.random.DirichletMRGParams;

public class MixtureDurationDiffSM
extends DurationDiffSM {
    private DurationDiffSM[] function;
    private double[] hiddenParams;
    private double[] scores;
    private double logNorm;
    private int[] paramRef;
    private int[] partDerOffset;
    private int starts;
    private IntList help;
    private static String XML_TAG = "MixtureDurationDiffSM";

    private static double getESS(DurationDiffSM ... function) {
        double ess = function[0].getESS();
        boolean noESS = ess == 0.0;
        int i = 1;
        while (i < function.length) {
            double e = function[i].getESS();
            if (noESS) {
                if (e > 0.0) {
                    throw new IllegalArgumentException("The ESS of duration " + i + " has to be zero.");
                }
            } else {
                ess += e;
            }
            ++i;
        }
        return ess;
    }

    public MixtureDurationDiffSM(int starts, DurationDiffSM ... function) throws WrongAlphabetException, CloneNotSupportedException, IllegalArgumentException {
        super(function[0].getMin(), function[0].getMax(), MixtureDurationDiffSM.getESS(function));
        if (starts <= 0) {
            throw new IllegalArgumentException("The number of recommended starts should be positive.");
        }
        this.starts = starts;
        this.function = new DurationDiffSM[function.length];
        this.scores = new double[function.length];
        this.hiddenParams = new double[function.length];
        this.paramRef = null;
        this.partDerOffset = new int[function.length];
        int i = 0;
        while (i < function.length) {
            if (!this.alphabets.checkConsistency(function[i].getAlphabetContainer())) {
                throw new WrongAlphabetException("All durations have to have the same alphabet: Violated at position " + i);
            }
            this.function[i] = (DurationDiffSM)function[i].clone();
            ++i;
        }
        this.logNorm = Normalisation.getLogSum(this.hiddenParams);
        this.setParamRef(false);
        this.help = new IntList();
    }

    private void setParamRef(boolean freeParams) {
        if (this.paramRef == null || this.paramRef.length != this.function.length + 2) {
            this.paramRef = new int[this.function.length + 2];
        }
        int i = 0;
        boolean unknown = false;
        while (i < this.function.length) {
            int n = this.function[i].getNumberOfParameters();
            unknown |= n < 0;
            this.paramRef[i + 1] = this.paramRef[i] + n;
            ++i;
        }
        this.paramRef[i + 1] = unknown ? -1 : this.paramRef[i] + this.scores.length - (freeParams ? 1 : 0);
    }

    public MixtureDurationDiffSM(StringBuffer source) throws NonParsableException {
        super(source);
    }

    @Override
    public MixtureDurationDiffSM clone() throws CloneNotSupportedException {
        MixtureDurationDiffSM clone = (MixtureDurationDiffSM)super.clone();
        clone.function = (DurationDiffSM[])ArrayHandler.clone((Cloneable[])this.function);
        clone.scores = (double[])this.scores.clone();
        clone.paramRef = (int[])this.paramRef.clone();
        clone.partDerOffset = (int[])this.partDerOffset.clone();
        clone.hiddenParams = (double[])this.hiddenParams.clone();
        clone.help = new IntList();
        return clone;
    }

    @Override
    public void adjust(int[] length, double[] weight) {
        double[][] assignedWeights = new double[this.function.length][];
        double[] stat = new double[this.hiddenParams.length];
        double all = 0.0;
        int i = 0;
        while (i < this.function.length) {
            this.function[i].adjust(length, weight);
            this.hiddenParams[i] = 0.0;
            assignedWeights[i] = new double[weight.length];
            stat[i] = this.function[i].getESS();
            all += stat[i];
            ++i;
        }
        this.logNorm = Normalisation.getLogSum(this.hiddenParams);
        int[] values = new int[1];
        int l = 0;
        while (l < length.length) {
            values[0] = length[l];
            int i2 = 0;
            while (i2 < this.function.length) {
                this.scores[i2] = this.hiddenParams[i2] + this.function[i2].getLogScore(values);
                ++i2;
            }
            Normalisation.logSumNormalisation(this.scores);
            i2 = 0;
            while (i2 < this.function.length) {
                assignedWeights[i2][l] = weight[l] * this.scores[i2];
                int n = i2;
                stat[n] = stat[n] + weight[l] * this.scores[i2];
                ++i2;
            }
            all += weight[l];
            ++l;
        }
        int i3 = 0;
        while (i3 < this.function.length) {
            this.function[i3].adjust(length, assignedWeights[i3]);
            this.hiddenParams[i3] = Math.log(stat[i3] / all);
            ++i3;
        }
        this.logNorm = 0.0;
    }

    @Override
    public double getLogScore(int ... values) {
        int i = 0;
        while (i < this.function.length) {
            this.scores[i] = this.hiddenParams[i] + this.function[i].getLogScore(values);
            ++i;
        }
        return Normalisation.getLogSum(this.scores) - this.logNorm;
    }

    @Override
    public double getLogScoreAndPartialDerivation(IntList indices, DoubleList partialDer, int ... values) {
        int j;
        int i = 0;
        int o = partialDer.length();
        while (i < this.function.length) {
            this.help.clear();
            this.scores[i] = this.hiddenParams[i] + this.function[i].getLogScoreAndPartialDerivation(this.help, partialDer, values);
            this.partDerOffset[i] = partialDer.length();
            j = 0;
            while (j < this.help.length()) {
                indices.add(this.paramRef[i] + this.help.get(j));
                ++j;
            }
            ++i;
        }
        double logScore = Normalisation.logSumNormalisation(this.scores);
        i = 0;
        while (i < this.function.length) {
            partialDer.multiply(o, this.partDerOffset[i], this.scores[i]);
            o = this.partDerOffset[i];
            ++i;
        }
        i = 0;
        j = this.paramRef[this.function.length];
        while (j < this.paramRef[this.function.length + 1]) {
            indices.add(j);
            partialDer.add(this.scores[i] - Math.exp(this.hiddenParams[i] - this.logNorm));
            ++j;
            ++i;
        }
        return logScore - this.logNorm;
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int start) throws Exception {
        if (this.ess > 0.0) {
            int i = 0;
            while (i < this.function.length) {
                this.function[i].addGradientOfLogPriorTerm(grad, this.paramRef[i] + start);
                ++i;
            }
            int j = 0;
            int i2 = this.paramRef[this.function.length];
            while (i2 < this.paramRef[this.function.length + 1]) {
                grad[i2 + start] = this.function[j].getESS() - this.ess * Math.exp(this.hiddenParams[j] - this.logNorm);
                ++i2;
                ++j;
            }
        }
    }

    @Override
    public double getLogPriorTerm() {
        double lp = 0.0;
        if (this.ess > 0.0) {
            int i = 0;
            while (i < this.function.length) {
                lp += this.function[i].getLogPriorTerm() + this.function[i].getESS() * this.hiddenParams[i];
                ++i;
            }
            lp -= this.ess * this.logNorm;
        }
        return lp;
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        int n = this.getNumberOfParameters();
        if (n > 0) {
            double[] params = new double[n];
            int i = 0;
            while (i < this.function.length) {
                double[] current = this.function[i].getCurrentParameterValues();
                System.arraycopy(current, 0, params, this.paramRef[i], current.length);
                ++i;
            }
            int j = 0;
            int i2 = this.paramRef[this.function.length];
            while (i2 < this.paramRef[this.function.length + 1]) {
                params[i2] = this.hiddenParams[j];
                ++i2;
                ++j;
            }
            return params;
        }
        throw new RuntimeException();
    }

    @Override
    public String getInstanceName() {
        String name = "mixture duration(" + this.function[0].getInstanceName();
        int i = 1;
        while (i < this.function.length) {
            name = String.valueOf(name) + ", " + this.function[i].getInstanceName();
            ++i;
        }
        return String.valueOf(name) + ")";
    }

    @Override
    public int getNumberOfParameters() {
        return this.paramRef[this.function.length + 1];
    }

    @Override
    public void initializeFunction(int index, boolean freeParams, DataSet[] data, double[][] weights) throws Exception {
        int i = 0;
        double w = 1.0;
        double all = 0.0;
        while (i < this.function.length) {
            this.hiddenParams[i] = this.function[i].getESS();
            all += this.hiddenParams[i];
            ++i;
        }
        DirichletMRGParams params = new DirichletMRGParams(this.hiddenParams);
        double[] current = new double[this.function.length];
        if (weights == null) {
            weights = new double[data.length][];
        }
        double[] help = weights[index];
        double[][] componentWeights = new double[this.function.length][data[index].getNumberOfElements()];
        int j = 0;
        while (j < componentWeights[0].length) {
            DirichletMRG.DEFAULT_INSTANCE.generate(current, 0, this.function.length, params);
            if (help != null) {
                w = help[j];
            }
            all += w;
            i = 0;
            while (i < this.function.length) {
                componentWeights[i][j] = w * current[i];
                int n = i;
                this.hiddenParams[n] = this.hiddenParams[n] + componentWeights[i][j];
                ++i;
            }
            ++j;
        }
        i = 0;
        while (i < this.function.length) {
            weights[index] = componentWeights[i];
            this.function[i].initializeFunction(index, freeParams, data, (double[][])weights);
            this.hiddenParams[i] = Math.log(this.hiddenParams[i] / all);
            ++i;
        }
        this.logNorm = 0.0;
        weights[index] = help;
        this.setParamRef(freeParams);
    }

    @Override
    public void initializeUniformly() {
        int i = 0;
        while (i < this.function.length) {
            this.function[i].initializeUniformly();
            this.hiddenParams[i] = 0.0;
            ++i;
        }
        this.logNorm = Normalisation.getLogSum(this.hiddenParams);
        this.setParamRef(false);
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        boolean noPrior = this.ess == 0.0;
        double[] hyper = (double[])this.scores.clone();
        int i = 0;
        while (i < this.function.length) {
            this.function[i].initializeFunctionRandomly(freeParams);
            hyper[i] = noPrior ? 1.0 : this.function[i].getESS();
            ++i;
        }
        DirichletMRG.DEFAULT_INSTANCE.generate(this.hiddenParams, 0, this.function.length, new DirichletMRGParams(hyper));
        i = 0;
        while (i < this.function.length) {
            this.hiddenParams[i] = Math.log(this.hiddenParams[i]);
            ++i;
        }
        this.logNorm = 0.0;
        this.setParamRef(freeParams);
    }

    @Override
    public boolean isInitialized() {
        int i = 0;
        while (i < this.function.length && this.function[i].isInitialized()) {
            ++i;
        }
        return i == this.function.length;
    }

    @Override
    public boolean isNormalized() {
        return true;
    }

    @Override
    public void setParameters(double[] params, int start) {
        int i = 0;
        while (i < this.function.length) {
            this.function[i].setParameters(params, start + this.paramRef[i]);
            ++i;
        }
        int j = 0;
        int i2 = this.paramRef[this.function.length];
        while (i2 < this.paramRef[this.function.length + 1]) {
            this.hiddenParams[j] = params[start + i2];
            ++i2;
            ++j;
        }
        this.logNorm = Normalisation.getLogSum(this.hiddenParams);
    }

    @Override
    protected String getRNotation(String distributionName) {
        String r = "";
        String sum = null;
        int i = 0;
        while (i < this.function.length) {
            r = String.valueOf(r) + this.function[i].getRNotation(String.valueOf(distributionName) + i) + "\n";
            sum = sum == null ? String.valueOf(distributionName) + " = " + Math.exp(this.hiddenParams[i] - this.logNorm) + " * " + distributionName + i : String.valueOf(sum) + " + " + Math.exp(this.hiddenParams[i] - this.logNorm) + " * " + distributionName + i;
            ++i;
        }
        return String.valueOf(r) + sum + ";";
    }

    @Override
    public void modify(int delta) {
        if (delta != 0) {
            super.modify(delta);
            int i = 0;
            while (i < this.function.length) {
                this.function[i].modify(delta);
                ++i;
            }
        }
    }

    @Override
    public int getNumberOfRecommendedStarts() {
        return this.starts;
    }

    @Override
    protected void fromXML(StringBuffer rep) throws NonParsableException {
        StringBuffer xml = XMLParser.extractForTag(rep, XML_TAG);
        super.fromXML(xml);
        this.function = XMLParser.extractObjectForTags(xml, "components", DurationDiffSM[].class);
        this.hiddenParams = XMLParser.extractObjectForTags(xml, "hiddenParams", double[].class);
        this.starts = XMLParser.extractObjectForTags(xml, "starts", Integer.TYPE);
        this.scores = new double[this.function.length];
        this.paramRef = null;
        this.partDerOffset = new int[this.function.length];
        this.logNorm = Normalisation.getLogSum(this.hiddenParams);
        this.setParamRef(false);
        this.help = new IntList();
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = super.toXML();
        XMLParser.appendObjectWithTags(xml, this.function, "components");
        XMLParser.appendObjectWithTags(xml, this.hiddenParams, "hiddenParams");
        XMLParser.appendObjectWithTags(xml, this.starts, "starts");
        XMLParser.addTags(xml, XML_TAG);
        return xml;
    }
}

