/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.DifferentiableEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.Emission;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import java.text.NumberFormat;
import java.util.LinkedList;
import javax.naming.OperationNotSupportedException;

public class UniformEmission
implements DifferentiableEmission {
    private AlphabetContainer con;
    private double logP;
    private static final String XML_TAG = "UniformEmission";

    public UniformEmission(AlphabetContainer con) {
        this.con = con;
        this.logP = -Math.log(con.getAlphabetLengthAt(0));
    }

    public UniformEmission(StringBuffer xml) throws NonParsableException {
        this(new AlphabetContainer(XMLParser.extractForTag(xml, XML_TAG)));
    }

    public UniformEmission clone() throws CloneNotSupportedException {
        return (UniformEmission)super.clone();
    }

    @Override
    public void addToStatistic(boolean forward, int startPos, int endPos, double weight, Sequence seq) throws OperationNotSupportedException {
    }

    @Override
    public void estimateFromStatistic() {
    }

    @Override
    public AlphabetContainer getAlphabetContainer() {
        return this.con;
    }

    @Override
    public double getLogPriorTerm() {
        return 0.0;
    }

    @Override
    public double getLogProbFor(boolean forward, int startPos, int endPos, Sequence seq) throws OperationNotSupportedException {
        return (double)(endPos - startPos + 1) * this.logP;
    }

    @Override
    public String getNodeLabel(double weight, String name, NumberFormat nf) {
        if (weight < 0.0) {
            return "\"" + name + "\"";
        }
        String res = "<<table border=\"0\" cellspacing=\"0\"><tr><td\">";
        res = weight < 0.5 ? String.valueOf(res) + "<font color=\"white\">" + name + "</font>" : String.valueOf(res) + name;
        res = String.valueOf(res) + "</td></tr></table>>";
        return res;
    }

    @Override
    public String getNodeShape(boolean forward) {
        String res = "";
        if (this.getAlphabetContainer().isReverseComplementable()) {
            res = String.valueOf(res) + "\"house\", orientation=";
            if (forward) {
                res = String.valueOf(res) + "-";
            }
            res = String.valueOf(res) + "90";
        } else {
            res = String.valueOf(res) + "\"diamond\"";
        }
        return res;
    }

    @Override
    public void initializeFunctionRandomly() {
    }

    @Override
    public void joinStatistics(Emission ... emissions) {
    }

    @Override
    public void resetStatistic() {
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = this.con.toXML();
        XMLParser.addTags(xml, XML_TAG);
        return xml;
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int offset) {
    }

    @Override
    public void fillCurrentParameter(double[] params) {
    }

    @Override
    public void fillSamplingGroups(int parameterOffset, LinkedList<int[]> list) {
    }

    @Override
    public double getLogProbAndPartialDerivationFor(boolean forward, int startPos, int endPos, IntList indices, DoubleList partDer, Sequence seq) throws OperationNotSupportedException {
        return this.getLogProbFor(forward, startPos, endPos, seq);
    }

    @Override
    public int getNumberOfParameters() {
        return 0;
    }

    @Override
    public int getSizeOfEventSpace() {
        return 0;
    }

    @Override
    public void setParameter(double[] params, int offset) {
    }

    @Override
    public int setParameterOffset(int offset) {
        return offset;
    }

    @Override
    public void setParameters(Emission t) throws IllegalArgumentException {
        if (!t.getClass().equals(this.getClass()) || ((UniformEmission)t).logP != this.logP) {
            throw new IllegalArgumentException("The transitions are not comparable.");
        }
    }
}

